/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.adapter;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.red5.io.IStreamableFile;
import org.red5.io.ITagReader;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.adapter.IApplication;
import org.red5.server.adapter.StatefulScopeWrappingAdapter;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.plugin.IRed5Plugin;
import org.red5.server.api.plugin.IRed5PluginHandler;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IBasicScope;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.service.IBroadcastStreamService;
import org.red5.server.api.service.IOnDemandStreamService;
import org.red5.server.api.service.IStreamSecurityService;
import org.red5.server.api.service.IStreamableFileService;
import org.red5.server.api.service.ISubscriberStreamService;
import org.red5.server.api.service.ServiceUtils;
import org.red5.server.api.so.ISharedObject;
import org.red5.server.api.so.ISharedObjectSecurity;
import org.red5.server.api.so.ISharedObjectSecurityService;
import org.red5.server.api.so.ISharedObjectService;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IOnDemandStream;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.IStreamAwareScopeHandler;
import org.red5.server.api.stream.IStreamPlaybackSecurity;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.red5.server.api.stream.IStreamService;
import org.red5.server.api.stream.IStreamableFileFactory;
import org.red5.server.api.stream.ISubscriberStream;
import org.red5.server.exception.ClientRejectedException;
import org.red5.server.jmx.mxbeans.ApplicationMXBean;
import org.red5.server.messaging.AbstractPipe;
import org.red5.server.messaging.IMessageInput;
import org.red5.server.plugin.PluginDescriptor;
import org.red5.server.plugin.PluginRegistry;
import org.red5.server.plugin.Red5Plugin;
import org.red5.server.scheduling.QuartzSchedulingService;
import org.red5.server.so.SharedObjectService;
import org.red5.server.stream.IProviderService;
import org.red5.server.stream.PlaylistSubscriberStream;
import org.red5.server.stream.ProviderService;
import org.red5.server.stream.StreamService;
import org.red5.server.stream.StreamableFileFactory;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;

public class MultiThreadedApplicationAdapter
extends StatefulScopeWrappingAdapter
implements ISharedObjectService,
IBroadcastStreamService,
IOnDemandStreamService,
ISubscriberStreamService,
ISchedulingService,
IStreamSecurityService,
ISharedObjectSecurityService,
IStreamAwareScopeHandler,
ApplicationMXBean {
    protected Logger log = null;
    private CopyOnWriteArraySet<IApplication> listeners = new CopyOnWriteArraySet();
    protected ISchedulingService schedulingService;
    private Set<IStreamPublishSecurity> publishSecurity = new HashSet<IStreamPublishSecurity>();
    private Set<IStreamPlaybackSecurity> playbackSecurity = new HashSet<IStreamPlaybackSecurity>();
    private Set<ISharedObjectSecurity> sharedObjectSecurity = new HashSet<ISharedObjectSecurity>();

    public void addListener(IApplication listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IApplication listener) {
        this.listeners.remove(listener);
    }

    public Set<IApplication> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public void registerStreamPublishSecurity(IStreamPublishSecurity handler) {
        this.publishSecurity.add(handler);
    }

    public void unregisterStreamPublishSecurity(IStreamPublishSecurity handler) {
        this.publishSecurity.remove(handler);
    }

    public Set<IStreamPublishSecurity> getStreamPublishSecurity() {
        return this.publishSecurity;
    }

    public void registerStreamPlaybackSecurity(IStreamPlaybackSecurity handler) {
        this.playbackSecurity.add(handler);
    }

    public void unregisterStreamPlaybackSecurity(IStreamPlaybackSecurity handler) {
        this.playbackSecurity.remove(handler);
    }

    public Set<IStreamPlaybackSecurity> getStreamPlaybackSecurity() {
        return this.playbackSecurity;
    }

    public void registerSharedObjectSecurity(ISharedObjectSecurity handler) {
        this.sharedObjectSecurity.add(handler);
    }

    public void unregisterSharedObjectSecurity(ISharedObjectSecurity handler) {
        this.sharedObjectSecurity.remove(handler);
    }

    public Set<ISharedObjectSecurity> getSharedObjectSecurity() {
        return this.sharedObjectSecurity;
    }

    protected boolean rejectClient() throws ClientRejectedException {
        throw new ClientRejectedException();
    }

    protected boolean rejectClient(Object reason) throws ClientRejectedException {
        throw new ClientRejectedException(reason);
    }

    public boolean connect(IConnection conn) {
        if (this.log == null) {
            this.log = Red5LoggerFactory.getLogger(this.getClass());
        }
        IScope scope = conn.getScope();
        this.log.debug("connect: {} > {}", (Object)conn, (Object)scope);
        return this.connect(conn, scope, null);
    }

    public boolean connect(IConnection conn, IScope scope, Object[] params) {
        if (this.log == null) {
            this.log = Red5LoggerFactory.getLogger(this.getClass());
        }
        this.log.debug("connect: {} > {}", (Object)conn, (Object)scope);
        boolean success = false;
        if (super.connect(conn, scope, params)) {
            if (this.log.isInfoEnabled() && ScopeUtils.isApp((IBasicScope)scope)) {
                IClient client = conn.getClient();
                if (client == null) {
                    this.log.info("W3C x-category:session x-event:connect c-ip:{}", (Object)conn.getRemoteAddress());
                } else {
                    this.log.info("W3C x-category:session x-event:connect c-ip:{} c-client-id:{}", (Object)conn.getRemoteAddress(), (Object)client.getId());
                }
            }
            if (ScopeUtils.isApp((IBasicScope)scope)) {
                success = this.appConnect(conn, params);
            } else if (ScopeUtils.isRoom((IBasicScope)scope)) {
                success = this.roomConnect(conn, params);
            } else {
                this.log.warn("Scope was not of app or room type, connect failed");
            }
        }
        return success;
    }

    public boolean start(IScope scope) {
        if (this.log == null) {
            this.log = Red5LoggerFactory.getLogger(this.getClass());
        }
        this.log.debug("start: {}", (Object)scope);
        this.log.trace("Plugins: {}", (Object)this.plugins);
        if (this.plugins != null) {
            for (PluginDescriptor desc : this.plugins) {
                this.log.debug("Plugin: {}", (Object)desc);
                try {
                    ClassLoader classLoader = scope.getClassLoader();
                    Class<?> clazz = Class.forName(desc.getPluginType(), true, classLoader);
                    this.log.trace("Class: {}", clazz);
                    IRed5Plugin plugin = PluginRegistry.getPlugin(desc.getPluginName());
                    this.log.debug("Got plugin from the registry: {}", (Object)plugin);
                    if (plugin instanceof Red5Plugin) {
                        ((Red5Plugin)plugin).setApplication(this);
                    }
                    if (desc.getMethod() == null) continue;
                    Method method = plugin.getClass().getMethod(desc.getMethod(), null);
                    if (desc.getMethodReturnType() == null) {
                        this.log.debug("Invoking plugin");
                        method.invoke((Object)plugin, (Object[])null);
                        continue;
                    }
                    this.log.debug("Invoking plugin");
                    Object returnClass = method.invoke((Object)plugin, (Object[])null);
                    if (returnClass instanceof IRed5PluginHandler) {
                        Map props = desc.getProperties();
                        if (props != null) {
                            Method setProps = returnClass.getClass().getMethod("setProperties", Map.class);
                            setProps.invoke(returnClass, props);
                        }
                        Method init = returnClass.getClass().getMethod("init", null);
                        init.invoke(returnClass, (Object[])null);
                    }
                    if (returnClass instanceof IApplication) {
                        this.log.debug("Adding result class to listeners");
                        this.addListener((IApplication)returnClass);
                        continue;
                    }
                    this.log.info("Returned class did not implement IApplication");
                }
                catch (Exception e) {
                    this.log.warn("Exception setting up a plugin", (Throwable)e);
                }
            }
        }
        boolean started = false;
        if (super.start(scope)) {
            if (ScopeUtils.isApp((IBasicScope)scope)) {
                started = this.appStart(scope);
            } else if (ScopeUtils.isRoom((IBasicScope)scope)) {
                started = this.roomStart(scope);
            } else {
                this.log.warn("Scope wasn't of app or room type, it was not started");
            }
            if (started) {
                super.setCanConnect(true);
                super.setCanCallService(true);
            }
        }
        return started;
    }

    public void disconnect(IConnection conn, IScope scope) {
        this.log.debug("disconnect: {} < {}", (Object)conn, (Object)scope);
        if (this.log.isInfoEnabled() && ScopeUtils.isApp((IBasicScope)scope)) {
            IClient client = conn.getClient();
            if (client == null) {
                this.log.info("W3C x-category:session x-event:disconnect c-ip:{}", (Object)conn.getRemoteAddress());
            } else {
                this.log.info("W3C x-category:session x-event:disconnect c-ip:{} c-client-id:{}", (Object)conn.getRemoteAddress(), (Object)client.getId());
            }
        }
        if (ScopeUtils.isApp((IBasicScope)scope)) {
            this.appDisconnect(conn);
        } else if (ScopeUtils.isRoom((IBasicScope)scope)) {
            this.roomDisconnect(conn);
        }
        super.disconnect(conn, scope);
    }

    public void stop(IScope scope) {
        this.log.debug("stop: {}", (Object)scope.getName());
        if (ScopeUtils.isApp((IBasicScope)scope)) {
            super.setCanConnect(false);
            super.setCanCallService(false);
            this.appStop(scope);
        } else if (ScopeUtils.isRoom((IBasicScope)scope)) {
            this.roomStop(scope);
        }
        super.stop(scope);
    }

    public boolean join(IClient client, IScope scope) {
        if (!super.join(client, scope)) {
            return false;
        }
        if (ScopeUtils.isApp((IBasicScope)scope)) {
            return this.appJoin(client, scope);
        }
        return ScopeUtils.isRoom((IBasicScope)scope) && this.roomJoin(client, scope);
    }

    public void leave(IClient client, IScope scope) {
        this.log.debug("leave: {} << {}", (Object)client, (Object)scope);
        if (ScopeUtils.isApp((IBasicScope)scope)) {
            this.appLeave(client, scope);
        } else if (ScopeUtils.isRoom((IBasicScope)scope)) {
            this.roomLeave(client, scope);
        }
        super.leave(client, scope);
    }

    @Override
    public boolean appStart(IScope app) {
        this.log.debug("appStart: {}", (Object)app);
        for (IApplication listener : this.listeners) {
            if (listener.appStart(app)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void appStop(IScope app) {
        this.log.debug("appStop: {}", (Object)app);
        for (IApplication listener : this.listeners) {
            listener.appStop(app);
        }
    }

    @Override
    public boolean roomStart(IScope room) {
        this.log.debug("roomStart: {}", (Object)room);
        for (IApplication listener : this.listeners) {
            if (listener.roomStart(room)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void roomStop(IScope room) {
        this.log.debug("roomStop: {}", (Object)room);
        for (IApplication listener : this.listeners) {
            listener.roomStop(room);
        }
    }

    @Override
    public boolean appConnect(IConnection conn, Object[] params) {
        this.log.debug("appConnect: {}", (Object)conn);
        for (IApplication listener : this.listeners) {
            if (listener.appConnect(conn, params)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean roomConnect(IConnection conn, Object[] params) {
        this.log.debug("roomConnect: {}", (Object)conn);
        for (IApplication listener : this.listeners) {
            if (listener.roomConnect(conn, params)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void appDisconnect(IConnection conn) {
        this.log.debug("appDisconnect: {}", (Object)conn);
        for (IApplication listener : this.listeners) {
            listener.appDisconnect(conn);
        }
    }

    @Override
    public void roomDisconnect(IConnection conn) {
        this.log.debug("roomDisconnect: {}", (Object)conn);
        for (IApplication listener : this.listeners) {
            listener.roomDisconnect(conn);
        }
    }

    @Override
    public boolean appJoin(IClient client, IScope app) {
        this.log.debug("appJoin: {} >> {}", (Object)client, (Object)app);
        for (IApplication listener : this.listeners) {
            if (listener.appJoin(client, app)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void appLeave(IClient client, IScope app) {
        this.log.debug("appLeave: {} << {}", (Object)client, (Object)app);
        for (IApplication listener : this.listeners) {
            listener.appLeave(client, app);
        }
    }

    @Override
    public boolean roomJoin(IClient client, IScope room) {
        this.log.debug("roomJoin: {} >> {}", (Object)client, (Object)room);
        for (IApplication listener : this.listeners) {
            if (listener.roomJoin(client, room)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void roomLeave(IClient client, IScope room) {
        this.log.debug("roomLeave: {} << {}", (Object)client, (Object)room);
        for (IApplication listener : this.listeners) {
            listener.roomLeave(client, room);
        }
    }

    public void measureBandwidth() {
        this.measureBandwidth(Red5.getConnectionLocal());
    }

    public void measureBandwidth(IConnection conn) {
        ServiceUtils.invokeOnConnection(conn, "onBWDone", new Object[0]);
    }

    public boolean createSharedObject(IScope scope, String name, boolean persistent) {
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService((IScope)scope, ISharedObjectService.class, SharedObjectService.class, (boolean)false);
        return service.createSharedObject(scope, name, persistent);
    }

    public ISharedObject getSharedObject(IScope scope, String name) {
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService((IScope)scope, ISharedObjectService.class, SharedObjectService.class, (boolean)false);
        return service.getSharedObject(scope, name);
    }

    public ISharedObject getSharedObject(IScope scope, String name, boolean persistent) {
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService((IScope)scope, ISharedObjectService.class, SharedObjectService.class, (boolean)false);
        return service.getSharedObject(scope, name, persistent);
    }

    public Set<String> getSharedObjectNames(IScope scope) {
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService((IScope)scope, ISharedObjectService.class, SharedObjectService.class, (boolean)false);
        return service.getSharedObjectNames(scope);
    }

    public boolean hasSharedObject(IScope scope, String name) {
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService((IScope)scope, ISharedObjectService.class, SharedObjectService.class, (boolean)false);
        return service.hasSharedObject(scope, name);
    }

    @Override
    public boolean hasBroadcastStream(IScope scope, String name) {
        IProviderService service = (IProviderService)ScopeUtils.getScopeService((IScope)scope, IProviderService.class, ProviderService.class);
        return service.getLiveProviderInput(scope, name, false) != null;
    }

    @Override
    public IBroadcastStream getBroadcastStream(IScope scope, String name) {
        IBroadcastScope bs;
        IStreamService service = (IStreamService)ScopeUtils.getScopeService((IScope)scope, IStreamService.class, StreamService.class);
        if (service instanceof StreamService && (bs = ((StreamService)service).getBroadcastScope(scope, name)) != null) {
            return bs.getClientBroadcastStream();
        }
        return null;
    }

    @Override
    public Set<String> getBroadcastStreamNames(IScope scope) {
        IProviderService service = (IProviderService)ScopeUtils.getScopeService((IScope)scope, IProviderService.class, ProviderService.class);
        return service.getBroadcastStreamNames(scope);
    }

    @Override
    public boolean hasOnDemandStream(IScope scope, String name) {
        IProviderService service = (IProviderService)ScopeUtils.getScopeService((IScope)scope, IProviderService.class, ProviderService.class);
        IMessageInput msgIn = service.getVODProviderInput(scope, name);
        if (msgIn instanceof AbstractPipe) {
            ((AbstractPipe)msgIn).close();
        }
        return msgIn != null;
    }

    @Override
    public IOnDemandStream getOnDemandStream(IScope scope, String name) {
        this.log.warn("This won't work until the refactoring of the streaming code is complete.");
        IOnDemandStreamService service = (IOnDemandStreamService)ScopeUtils.getScopeService((IScope)scope, IOnDemandStreamService.class, StreamService.class, (boolean)false);
        return service.getOnDemandStream(scope, name);
    }

    @Override
    public ISubscriberStream getSubscriberStream(IScope scope, String name) {
        this.log.warn("This won't work until the refactoring of the streaming code is complete.");
        ISubscriberStreamService service = (ISubscriberStreamService)ScopeUtils.getScopeService((IScope)scope, ISubscriberStreamService.class, StreamService.class, (boolean)false);
        return service.getSubscriberStream(scope, name);
    }

    public String addScheduledJob(int interval, IScheduledJob job) {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService((IScope)this.scope, ISchedulingService.class, QuartzSchedulingService.class, (boolean)false);
        return service.addScheduledJob(interval, job);
    }

    public String addScheduledOnceJob(long timeDelta, IScheduledJob job) {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService((IScope)this.scope, ISchedulingService.class, QuartzSchedulingService.class, (boolean)false);
        return service.addScheduledOnceJob(timeDelta, job);
    }

    public String addScheduledOnceJob(Date date, IScheduledJob job) {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService((IScope)this.scope, ISchedulingService.class, QuartzSchedulingService.class, (boolean)false);
        return service.addScheduledOnceJob(date, job);
    }

    public String addScheduledJobAfterDelay(int interval, IScheduledJob job, int delay) {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService((IScope)this.scope, ISchedulingService.class, QuartzSchedulingService.class, (boolean)false);
        return service.addScheduledJobAfterDelay(interval, job, delay);
    }

    public void pauseScheduledJob(String name) {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService((IScope)this.scope, ISchedulingService.class, QuartzSchedulingService.class, (boolean)false);
        service.pauseScheduledJob(name);
    }

    public void resumeScheduledJob(String name) {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService((IScope)this.scope, ISchedulingService.class, QuartzSchedulingService.class, (boolean)false);
        service.resumeScheduledJob(name);
    }

    public void removeScheduledJob(String name) {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService((IScope)this.scope, ISchedulingService.class, QuartzSchedulingService.class, (boolean)false);
        service.removeScheduledJob(name);
    }

    public List<String> getScheduledJobNames() {
        ISchedulingService service = (ISchedulingService)ScopeUtils.getScopeService((IScope)this.scope, ISchedulingService.class, QuartzSchedulingService.class, (boolean)false);
        return service.getScheduledJobNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStreamLength(String name) {
        double duration = 0.0;
        IProviderService provider = (IProviderService)ScopeUtils.getScopeService((IScope)this.scope, IProviderService.class, ProviderService.class);
        File file = provider.getVODProviderFile(this.scope, name);
        if (file != null && file.canRead()) {
            IStreamableFileFactory factory = (IStreamableFileFactory)ScopeUtils.getScopeService((IScope)this.scope, IStreamableFileFactory.class, StreamableFileFactory.class);
            IStreamableFileService service = factory.getService(file);
            if (service != null) {
                try (ITagReader reader = null;){
                    IStreamableFile streamFile = service.getStreamableFile(file);
                    reader = streamFile.getReader();
                    duration = (double)reader.getDuration() / 1000.0;
                }
            } else {
                this.log.error("No service found for {}", (Object)file.getAbsolutePath());
            }
            file = null;
        }
        return duration;
    }

    public boolean clearSharedObjects(IScope scope, String name) {
        ISharedObjectService service = (ISharedObjectService)ScopeUtils.getScopeService((IScope)scope, ISharedObjectService.class, SharedObjectService.class, (boolean)false);
        return service.clearSharedObjects(scope, name);
    }

    @Deprecated
    public long getClientTTL() {
        return -1L;
    }

    @Deprecated
    public void setClientTTL(int clientTTL) {
    }

    @Deprecated
    public int getGhostConnsCleanupPeriod() {
        return -1;
    }

    @Deprecated
    public void setGhostConnsCleanupPeriod(int ghostConnsCleanupPeriod) {
    }

    public void startTransmit(Boolean bool, int num) {
    }

    public void stopTransmit() {
    }

    public void stopTransmit(Boolean bool, int num) {
    }

    public void FCPublish(String streamName) {
    }

    public void FCUnpublish() {
    }

    public void FCUnpublish(String streamName) {
    }

    public void FCSubscribe(String streamName) {
    }

    public void streamBroadcastClose(IBroadcastStream stream) {
        IConnection conn = Red5.getConnectionLocal();
        long publishDuration = (System.currentTimeMillis() - stream.getCreationTime()) / 1000L;
        if (conn != null) {
            this.log.info("W3C x-category:stream x-event:unpublish c-ip:{} cs-bytes:{} sc-bytes:{} x-sname:{} x-file-length:{} x-name:{}", new Object[]{conn.getRemoteAddress(), conn.getReadBytes(), conn.getWrittenBytes(), stream.getName(), publishDuration, stream.getPublishedName()});
        } else {
            this.log.info("W3C x-category:stream x-event:unpublish x-sname:{} x-file-length:{} x-name:{}", new Object[]{stream.getName(), publishDuration, stream.getPublishedName()});
        }
        String recordingName = stream.getSaveFilename();
        if (recordingName != null) {
            if (conn != null) {
                this.log.info("W3C x-category:stream x-event:recordstop c-ip:{} cs-bytes:{} sc-bytes:{} x-sname:{} x-file-name:{} x-file-length:{} x-file-size:{}", new Object[]{conn.getRemoteAddress(), conn.getReadBytes(), conn.getWrittenBytes(), stream.getName(), recordingName, publishDuration, conn.getReadBytes()});
            } else {
                this.log.info("W3C x-category:stream x-event:recordstop x-sname:{} x-file-name:{} x-file-length:{}", new Object[]{stream.getName(), recordingName, publishDuration});
            }
            String webappsPath = System.getProperty("red5.webapp.root");
            File file = new File(webappsPath, this.getName() + '/' + recordingName);
            if (file != null) {
                this.log.debug("File path: {}", (Object)file.getAbsolutePath());
                if (file.exists() && (publishDuration == 0L || file.length() == 0L)) {
                    if (file.delete()) {
                        this.log.info("File {} was deleted", (Object)file.getName());
                    } else {
                        this.log.info("File {} was not deleted, it will be deleted on exit", (Object)file.getName());
                        file.deleteOnExit();
                    }
                }
                file = null;
            }
        }
    }

    public void streamBroadcastStart(IBroadcastStream stream) {
    }

    public void streamPlayItemPlay(ISubscriberStream stream, IPlayItem item, boolean isLive) {
        this.log.info("W3C x-category:stream x-event:play c-ip:{} x-sname:{} x-name:{}", new Object[]{Red5.getConnectionLocal().getRemoteAddress(), stream.getName(), item.getName()});
    }

    public void streamPlayItemStop(ISubscriberStream stream, IPlayItem item) {
        if (this.log.isInfoEnabled()) {
            String remoteAddress = "";
            long readBytes = -1L;
            long writtenBytes = -1L;
            IConnection conn = Red5.getConnectionLocal();
            if (conn != null) {
                remoteAddress = conn.getRemoteAddress();
                readBytes = conn.getReadBytes();
                writtenBytes = conn.getWrittenBytes();
            }
            long playDuration = -1L;
            if (stream instanceof PlaylistSubscriberStream) {
                playDuration = (System.currentTimeMillis() - ((PlaylistSubscriberStream)stream).getCreationTime()) / 1000L;
            }
            long playItemSize = -1L;
            String playItemName = "";
            if (item != null) {
                playItemName = item.getName();
                IProviderService providerService = (IProviderService)this.scope.getContext().getBean("providerService");
                if (providerService != null) {
                    File file = providerService.getVODProviderFile(this.scope, playItemName);
                    if (file != null) {
                        playItemSize = file.length();
                    } else {
                        this.log.debug("File was null, this is ok for live streams");
                    }
                } else {
                    this.log.debug("ProviderService was null");
                }
            }
            this.log.info("W3C x-category:stream x-event:stop c-ip:{} cs-bytes:{} sc-bytes:{} x-sname:{} x-file-length:{} x-file-size:{} x-name:{}", new Object[]{remoteAddress, readBytes, writtenBytes, stream.getName(), playDuration, playItemSize, playItemName});
        }
    }

    public void streamPlayItemPause(ISubscriberStream stream, IPlayItem item, int position) {
        this.log.info("W3C x-category:stream x-event:pause c-ip:{} x-sname:{}", (Object)Red5.getConnectionLocal().getRemoteAddress(), (Object)stream.getName());
    }

    public void streamPlayItemResume(ISubscriberStream stream, IPlayItem item, int position) {
        this.log.info("W3C x-category:stream x-event:unpause c-ip:{} x-sname:{}", (Object)Red5.getConnectionLocal().getRemoteAddress(), (Object)stream.getName());
    }

    public void streamPlayItemSeek(ISubscriberStream stream, IPlayItem item, int position) {
    }

    public void streamPublishStart(IBroadcastStream stream) {
        IConnection connection = Red5.getConnectionLocal();
        this.log.info("W3C x-category:stream x-event:publish c-ip:{} x-sname:{} x-name:{}", new Object[]{connection != null ? connection.getRemoteAddress() : "0.0.0.0", stream.getName(), stream.getPublishedName()});
    }

    public void streamRecordStart(IBroadcastStream stream) {
        IConnection connection = Red5.getConnectionLocal();
        this.log.info("W3C x-category:stream x-event:record-start c-ip:{} x-sname:{} x-file-name:{}", new Object[]{connection != null ? connection.getRemoteAddress() : "0.0.0.0", stream.getName(), stream.getSaveFilename()});
    }

    public void streamRecordStop(IBroadcastStream stream) {
        IConnection connection = Red5.getConnectionLocal();
        this.log.info("W3C x-category:stream x-event:record-stop c-ip:{} x-sname:{} x-file-name:{}", new Object[]{connection != null ? connection.getRemoteAddress() : "0.0.0.0", stream.getName(), stream.getSaveFilename()});
    }

    public void streamSubscriberClose(ISubscriberStream stream) {
        IConnection conn = Red5.getConnectionLocal();
        this.log.info("W3C x-category:stream x-event:stop c-ip:{} cs-bytes:{} sc-bytes:{} x-sname:{}", new Object[]{conn.getRemoteAddress(), conn.getReadBytes(), conn.getWrittenBytes(), stream.getName()});
    }

    public void streamSubscriberStart(ISubscriberStream stream) {
        this.log.info("W3C x-category:stream x-event:play c-ip:{} x-sname:{}", (Object)Red5.getConnectionLocal().getRemoteAddress(), (Object)stream.getName());
    }

    public boolean handleEvent(IEvent event) {
        this.log.debug("handleEvent: {}", (Object)event);
        return super.handleEvent(event);
    }
}

