/*
 * Decompiled with CFR 0.152.
 */
package com.antstreaming.rtsp;

import com.antstreaming.rtsp.IMuxerListener;
import com.antstreaming.rtsp.PacketReceiverRunnable;
import com.antstreaming.rtsp.PacketSenderRunnable;
import com.antstreaming.rtsp.protocol.RTSPTransport;
import com.antstreaming.rtsp.protocol.RtspCode;
import com.antstreaming.rtsp.protocol.RtspHeaderCode;
import com.antstreaming.rtsp.protocol.RtspRequest;
import com.antstreaming.rtsp.protocol.RtspResponse;
import com.antstreaming.rtsp.session.DateUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.mina.core.session.IoSession;
import org.red5.server.api.IContext;
import org.red5.server.api.IServer;
import org.red5.server.api.scope.IGlobalScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IStreamFilenameGenerator;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.stream.DefaultStreamFilenameGenerator;
import org.red5.server.stream.IProviderService;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class RtspConnection
extends RTMPMinaConnection
implements IMuxerListener {
    private Logger logger = LoggerFactory.getLogger(RtspConnection.class);
    protected static final String SLASH = "/";
    private static final String CSEQ = "cseq";
    private static final String REQUIRE_VALUE_NGOD_R2 = "com.comcast.ngod.r2";
    private static final String REQUIRE_VALUE_NGOD_C1 = "com.comcast.ngod.c1";
    public static final int UDP_PORT_MIN = 5000;
    public static final int UDP_PORT_MAX = 65000;
    public static AtomicInteger PORT_NUMBER = new AtomicInteger(5000);
    private ThreadPoolTaskScheduler mTaskScheduler;
    private IoSession mSession;
    private IServer mServer;
    private ScheduledFuture<?> mPacketSenderScheduledFuture;
    private String mSessionKey = RandomStringUtils.randomAlphanumeric((int)17).toUpperCase();
    private int[][] serverPort;
    private int[][] clientPort;
    private String remoteAddress;
    private StringBuffer liveStreamSdpDef;
    private ApplicationContext mApplicationContext;
    private ScheduledFuture<?> mPacketReceiverScheduledFuture;
    private PacketReceiverRunnable frameReceiver;
    private PacketSenderRunnable frameSender;
    private IScope scope;
    private String announcedStreamName;
    private String mode;

    public void handleMessage(IoSession session, Object message) {
        RtspRequest request = (RtspRequest)message;
        String cseq = request.getHeader(RtspHeaderCode.CSeq);
        session.setAttribute((Object)CSEQ, (Object)cseq);
        switch (request.getVerb()) {
            case OPTIONS: {
                this.onOptions(session, request);
                break;
            }
            case DESCRIBE: {
                this.onDescribe(session, request);
                break;
            }
            case SETUP: {
                this.onSetup(session, request);
                break;
            }
            case TEARDOWN: {
                this.onTeardown(session, request);
                break;
            }
            case PLAY: {
                this.onPlay(session, request);
                break;
            }
            case PAUSE: {
                this.onPause(session, request);
                break;
            }
            case GET_PARAMETER: {
                this.onGP(session, request);
                break;
            }
            case ANNOUNCE: {
                this.onAnnounce(session, request);
                break;
            }
            case RECORD: {
                this.onRecord(session, request);
                break;
            }
            default: {
                this.onDefaultRequest(session, request, request.getHeader(RtspHeaderCode.CSeq));
            }
        }
    }

    private void onRecord(IoSession session, RtspRequest request) {
        String sessionKey;
        String cseq = request.getHeader(RtspHeaderCode.CSeq);
        if (cseq == null || "".equals(cseq)) {
            cseq = "0";
        }
        if (null == (sessionKey = request.getHeader(RtspHeaderCode.Session)) || "".equals(sessionKey) || this.mSessionKey == null || !this.mSessionKey.equals(sessionKey)) {
            this.logger.error("sessionKey is null...................");
            this.handleError(session, cseq, RtspCode.SessionNotFound);
            return;
        }
        this.frameReceiver = new PacketReceiverRunnable(this.mTaskScheduler, cseq, sessionKey, session, this.announcedStreamName, this.liveStreamSdpDef, request.getUrl());
        this.mPacketReceiverScheduledFuture = this.mTaskScheduler.schedule((Runnable)this.frameReceiver, new Date());
    }

    private void onAnnounce(IoSession session, RtspRequest request) {
        String contentType = request.getHeader(RtspHeaderCode.ContentType);
        String cseq = request.getHeader(RtspHeaderCode.CSeq);
        if (cseq == null || "".equals(cseq)) {
            cseq = "0";
        }
        if (contentType.indexOf("application/sdp") == -1) {
            this.handleError(session, cseq, RtspCode.UnsupportedMediaType);
            return;
        }
        try {
            URI url = new URI(request.getUrl());
            this.announcedStreamName = this.getStreamName(url.getPath());
            String app = this.getAppName(url.getPath());
            IScope scope = this.getScope(url, app);
            if (scope == null) {
                this.handleError(session, cseq, RtspCode.DestinationUnreachable);
                return;
            }
            IStreamFilenameGenerator generator = (IStreamFilenameGenerator)ScopeUtils.getScopeService((IScope)scope, IStreamFilenameGenerator.class, DefaultStreamFilenameGenerator.class);
            String fileName = generator.generateFilename(scope, this.announcedStreamName, ".mp4", IStreamFilenameGenerator.GenerationType.RECORD);
            this.liveStreamSdpDef = request.getBuffer();
            int streamCount = 0;
            if (this.liveStreamSdpDef.indexOf("m=video") != -1) {
                ++streamCount;
            }
            if (this.liveStreamSdpDef.indexOf("m=audio") != -1) {
                ++streamCount;
            }
            this.serverPort = new int[streamCount][2];
            this.clientPort = new int[streamCount][2];
            RtspResponse rtspResponse = new RtspResponse();
            rtspResponse.setHeader(RtspHeaderCode.CSeq, cseq);
            session.write((Object)rtspResponse);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private IScope getScope(URI url, String app) {
        IContext context;
        IGlobalScope global;
        if (this.scope == null && (global = this.mServer.lookupGlobal(url.getHost(), app)) != null && (context = global.getContext()) != null) {
            this.scope = context.resolveScope((IScope)global, app);
        }
        return this.scope;
    }

    private void onPlay(IoSession session, RtspRequest request) {
        String cseq = request.getHeader(RtspHeaderCode.CSeq);
        if (null == cseq || "".equals(cseq)) {
            this.logger.error("cesq is null...................");
            this.handleError(session, "0", RtspCode.HeaderFieldNotValidForResource);
            return;
        }
        String sessionKey = request.getHeader(RtspHeaderCode.Session);
        if (null == sessionKey || "".equals(sessionKey) || !this.mSessionKey.equals(sessionKey)) {
            this.logger.error("sessionKey is null...................");
            this.handleError(session, cseq, RtspCode.SessionNotFound);
            return;
        }
        RtspResponse response = new RtspResponse();
        response.setCode(RtspCode.OK);
        response.setHeader(RtspHeaderCode.CSeq, cseq);
        response.setHeader(RtspHeaderCode.Date, DateUtil.getGmtDate());
        response.setHeader(RtspHeaderCode.Session, sessionKey);
        String rangeValue = request.getHeader(RtspHeaderCode.Range);
        long duration = this.frameSender.getDuration();
        float durationInSeconds = duration / 1000000L;
        long seekTime = 0L;
        if (null != rangeValue) {
            String[] rangeValues = rangeValue.split("=");
            String startTime = "0.000";
            if (rangeValues.length >= 2) {
                startTime = rangeValues[1].substring(0, rangeValues[1].indexOf("-"));
                seekTime = (long)(Float.parseFloat(startTime) * 1000000.0f);
                this.logger.debug("seek time :" + seekTime);
                if (durationInSeconds < 0.0f) {
                    response.setHeader(RtspHeaderCode.Range, "npt=0.000-");
                } else if (seekTime <= duration) {
                    int ret = this.frameSender.seek(seekTime);
                    if (ret >= 0) {
                        response.setHeader(RtspHeaderCode.Range, "npt=" + startTime + "-" + durationInSeconds);
                    } else {
                        this.logger.debug("cannot seek the file to specified timestamp" + seekTime);
                        response.setCode(RtspCode.InternalServerError);
                    }
                } else {
                    response.setCode(RtspCode.InvalidRange);
                }
            }
        } else {
            response.setHeader(RtspHeaderCode.Range, "npt=0.000-" + durationInSeconds);
        }
        String scale = request.getHeader(RtspHeaderCode.Scale);
        if (null != scale) {
            response.setHeader(RtspHeaderCode.Scale, scale);
        } else {
            response.setHeader(RtspHeaderCode.Scale, "1.00");
        }
        session.write((Object)response);
        if (response.getCode() == RtspCode.OK) {
            this.logger.warn("starting to play");
            this.mTaskScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    RtspConnection.this.frameSender.reinitialize();
                    RtspConnection.this.mPacketSenderScheduledFuture = RtspConnection.this.mTaskScheduler.scheduleAtFixedRate((Runnable)RtspConnection.this.frameSender, 10L);
                }
            }, new Date());
        } else {
            this.logger.debug("not starting to play");
        }
    }

    private void onOptions(IoSession session, RtspRequest request) {
        RtspResponse response = new RtspResponse();
        response.setHeader(RtspHeaderCode.CSeq, request.getHeader(RtspHeaderCode.CSeq));
        response.setHeader(RtspHeaderCode.Public, "DESCRIBE, SETUP, TEARDOWN, PLAY, PAUSE, ANNOUNCE");
        response.setHeader(RtspHeaderCode.Server, "RtspServer");
        response.setHeader(RtspHeaderCode.ContentLength, "0");
        session.write((Object)response);
    }

    private void onDescribe(final IoSession session, RtspRequest request) {
        final RtspResponse response = new RtspResponse();
        String cseq = request.getHeader(RtspHeaderCode.CSeq);
        if (null != cseq && !"".equals(cseq)) {
            response.setHeader(RtspHeaderCode.CSeq, cseq);
        }
        try {
            URI url = new URI(request.getUrl());
            final String rtmpUrl = "rtmp://" + url.getHost() + url.getPath();
            this.logger.debug("rtmp url is: " + rtmpUrl);
            this.logger.debug("on request describe host: " + url.getHost() + " path:" + url.getPath());
            String streamName = this.getStreamName(url.getPath());
            String app = this.getAppName(url.getPath());
            this.logger.debug("app:" + app + " streamName:" + streamName);
            IScope scope = this.getScope(url, app);
            IProviderService providerService = this.getProviderService(scope);
            IProviderService.INPUT_TYPE input = providerService.lookupProviderInput(scope, streamName, -2);
            this.logger.debug("input type is " + input + " live wait is:" + IProviderService.INPUT_TYPE.LIVE_WAIT);
            if (input != IProviderService.INPUT_TYPE.LIVE_WAIT) {
                response.setHeader(RtspHeaderCode.Date, DateUtil.getGmtDate());
                response.setHeader(RtspHeaderCode.ContentType, "application/sdp");
                response.setHeader(RtspHeaderCode.Server, "RtspServer");
                this.frameSender = new PacketSenderRunnable(this);
                this.mPacketSenderScheduledFuture = this.mTaskScheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        String sdpDescription = RtspConnection.this.frameSender.getSdpDescription(rtmpUrl);
                        if (sdpDescription != null) {
                            int streamCount = RtspConnection.this.frameSender.getStreamCount();
                            RtspConnection.access$302(RtspConnection.this, new int[streamCount][2]);
                            RtspConnection.access$402(RtspConnection.this, new int[streamCount][2]);
                            StringBuffer sdp = new StringBuffer();
                            sdp.append(new String(sdpDescription));
                            response.setHeader(RtspHeaderCode.ContentLength, String.valueOf(sdp.length()));
                            response.setBuffer(sdp);
                            session.write((Object)response);
                        } else {
                            response.setCode(RtspCode.InternalServerError);
                            session.write((Object)response);
                        }
                    }
                }, new Date());
            } else {
                response.setCode(RtspCode.NotFound);
                session.write((Object)response);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private IProviderService getProviderService(IScope scope) {
        IContext ctx = scope.getContext();
        IProviderService providerService = null;
        providerService = ctx.hasBean("providerService") ? (IProviderService)ctx.getBean("providerService") : (IProviderService)scope.getParent().getContext().getBean("providerService");
        return providerService;
    }

    private String getAppName(String path) {
        int secondIndex;
        String app = SLASH;
        int slashIndex = path.indexOf(SLASH);
        if (slashIndex != -1 && (secondIndex = path.indexOf(SLASH, slashIndex + 1)) != -1) {
            app = path.substring(slashIndex + 1, secondIndex);
        }
        return app;
    }

    private String getStreamName(String path) {
        String streamName = null;
        int lastIndexOf = path.lastIndexOf(SLASH);
        if (lastIndexOf != -1) {
            streamName = path.substring(path.lastIndexOf(SLASH) + 1);
        }
        return streamName;
    }

    private void onSetup(IoSession session, RtspRequest request) {
        RtspResponse response = new RtspResponse();
        String cseq = request.getHeader(RtspHeaderCode.CSeq);
        if (null == cseq || "".equals(cseq)) {
            this.logger.error("cesq is null.....");
            this.handleError(session, "0", RtspCode.HeaderFieldNotValidForResource);
            return;
        }
        response.setHeader(RtspHeaderCode.CSeq, cseq);
        String streamIdText = "streamid=";
        int streamIdIndex = request.getUrl().indexOf(streamIdText);
        int startIndex = streamIdIndex + streamIdText.length();
        int streamId = Integer.valueOf(request.getUrl().substring(startIndex, startIndex + 1));
        String transport = request.getHeader(RtspHeaderCode.Transport);
        RTSPTransport rtspTransport = new RTSPTransport(transport);
        if (rtspTransport.getLowerTransport() == RTSPTransport.LowerTransport.None) {
            rtspTransport.setLowerTransport(RTSPTransport.LowerTransport.UDP);
        } else if (rtspTransport.getLowerTransport() != RTSPTransport.LowerTransport.UDP) {
            this.handleError(session, cseq, RtspCode.UnsupportedTransport);
            return;
        }
        this.clientPort[streamId] = rtspTransport.getClientPort();
        this.mode = rtspTransport.getMode();
        if (this.mode != null && this.mode.equals("record")) {
            int portNo;
            this.serverPort[streamId][0] = portNo = PORT_NUMBER.getAndAdd(2);
            this.serverPort[streamId][1] = portNo + 1;
            if (streamId == 0) {
                String videoDef = "m=video 0";
                this.liveStreamSdpDef.replace(this.liveStreamSdpDef.indexOf(videoDef) + videoDef.length() - 1, this.liveStreamSdpDef.indexOf(videoDef) + videoDef.length(), String.valueOf(portNo));
            } else if (streamId == 1) {
                String audioDef = "m=audio 0";
                this.liveStreamSdpDef.replace(this.liveStreamSdpDef.indexOf(audioDef) + audioDef.length() - 1, this.liveStreamSdpDef.indexOf(audioDef) + audioDef.length(), String.valueOf(portNo));
            }
            rtspTransport.setServerPort(this.serverPort[streamId]);
            response.setHeader(RtspHeaderCode.Session, this.mSessionKey);
            rtspTransport.setLowerTransport(RTSPTransport.LowerTransport.UDP);
            response.setHeader(RtspHeaderCode.Transport, rtspTransport.toString());
        } else {
            SocketAddress remote = session.getRemoteAddress();
            this.remoteAddress = remote instanceof InetSocketAddress ? ((InetSocketAddress)remote).getAddress().getHostAddress() : remote.toString();
            if (this.frameSender.prepare_output_context(streamId, this.remoteAddress, this.clientPort[streamId], this.serverPort[streamId])) {
                response.setCode(RtspCode.OK);
                response.setHeader(RtspHeaderCode.CSeq, cseq);
                response.setHeader(RtspHeaderCode.Session, this.mSessionKey);
                rtspTransport.setServerPort(this.serverPort[streamId]);
                rtspTransport.setLowerTransport(RTSPTransport.LowerTransport.UDP);
                response.setHeader(RtspHeaderCode.Transport, rtspTransport.toString());
            } else {
                this.logger.debug("Failed to copy context from input to output stream codec context\n");
                response.setCode(RtspCode.InternalServerError);
            }
        }
        session.write((Object)response);
    }

    private void onPause(IoSession session, RtspRequest request) {
        String cseq = request.getHeader(RtspHeaderCode.CSeq);
        if (null == cseq || "".equals(cseq)) {
            this.logger.error("cesq is null...................");
            this.handleError(session, "0", RtspCode.HeaderFieldNotValidForResource);
            return;
        }
        String sessionKey = request.getHeader(RtspHeaderCode.Session);
        if (null == sessionKey || "".equals(sessionKey) || this.mSessionKey == null || !this.mSessionKey.equals(sessionKey)) {
            this.logger.error("sessionKey is null...................");
            this.handleError(session, cseq, RtspCode.SessionNotFound);
            return;
        }
        RtspResponse response = new RtspResponse();
        response.setCode(RtspCode.OK);
        response.setHeader(RtspHeaderCode.CSeq, cseq);
        response.setHeader(RtspHeaderCode.Date, DateUtil.getGmtDate());
        response.setHeader(RtspHeaderCode.Session, sessionKey);
        response.setHeader(RtspHeaderCode.Scale, "1.00");
        this.frameSender.closeMuxer(false);
        this.mPacketSenderScheduledFuture.cancel(true);
        int streamCount = this.frameSender.getStreamCount();
        for (int i = 0; i < streamCount; ++i) {
            if (!this.frameSender.prepare_output_context(i, this.remoteAddress, this.clientPort[i], this.serverPort[i])) {
                this.logger.debug("prepare output context failed...");
                continue;
            }
            this.logger.debug("prepare output context is ok");
        }
        session.write((Object)response);
    }

    private void onGP(IoSession session, RtspRequest request) {
        String cseq = request.getHeader(RtspHeaderCode.CSeq);
        if (null == cseq || "".equals(cseq)) {
            this.logger.error("cesq is null...................");
            this.handleError(session, "0", RtspCode.HeaderFieldNotValidForResource);
            return;
        }
        String requireValue = request.getHeader(RtspHeaderCode.Require);
        if (null == requireValue || "".equals(requireValue) || !requireValue.equals(REQUIRE_VALUE_NGOD_C1)) {
            this.logger.error("require value ==> {} ", (Object)requireValue);
            this.handleError(session, "0", RtspCode.HeaderFieldNotValidForResource);
            return;
        }
        String sessionKey = request.getHeader(RtspHeaderCode.Session);
        if (null == sessionKey || "".equals(sessionKey) || this.mSessionKey == null || !this.mSessionKey.equals(sessionKey)) {
            this.logger.debug("sessionKey is null...................");
            this.handleError(session, cseq, RtspCode.SessionNotFound);
        } else {
            StringBuffer sdp = new StringBuffer();
            sdp.append("position: 22\r\n");
            sdp.append("presentation state: play\r\n\r\n");
            sdp.append("scale: 1\r\n");
            RtspResponse response = new RtspResponse();
            response.setCode(RtspCode.OK);
            response.setHeader(RtspHeaderCode.CSeq, cseq);
            response.setHeader(RtspHeaderCode.Date, DateUtil.getGmtDate());
            response.setHeader(RtspHeaderCode.Session, sessionKey);
            response.setHeader(RtspHeaderCode.ContentLength, String.valueOf(sdp.length()));
            response.appendToBuffer(sdp);
            session.write((Object)response);
        }
    }

    private void onDefaultRequest(IoSession session, RtspRequest request, String cseq) {
        RtspResponse response = new RtspResponse();
        response.setCode(RtspCode.BadRequest);
        response.setHeader(RtspHeaderCode.CSeq, cseq);
        session.write((Object)response);
    }

    private void handleError(IoSession session, String cseq, RtspCode code) {
        RtspResponse response = new RtspResponse();
        response.setCode(code);
        response.setHeader(RtspHeaderCode.CSeq, cseq);
        session.write((Object)response);
    }

    private void onTeardown(IoSession session, RtspRequest request) {
        String cseq = request.getHeader(RtspHeaderCode.CSeq);
        if (null == cseq || "".equals(cseq)) {
            this.logger.error("cesq is null...................");
            this.handleError(session, "0", RtspCode.HeaderFieldNotValidForResource);
            return;
        }
        String sessionKey = request.getHeader(RtspHeaderCode.Session);
        if (null == sessionKey || "".equals(sessionKey) || this.mSessionKey == null || !this.mSessionKey.equals(sessionKey)) {
            this.handleError(session, "0", RtspCode.SessionNotFound);
            return;
        }
        RtspResponse response = new RtspResponse();
        response.setCode(RtspCode.OK);
        response.setHeader(RtspHeaderCode.CSeq, cseq);
        response.setHeader(RtspHeaderCode.Date, DateUtil.getGmtDate());
        response.setHeader(RtspHeaderCode.Session, sessionKey);
        session.write((Object)response);
        this.logger.debug("tear down called");
        this.close();
    }

    public ThreadPoolTaskScheduler getScheduler() {
        return this.mTaskScheduler;
    }

    public void setScheduler(ThreadPoolTaskScheduler taskScheduler) {
        this.mTaskScheduler = taskScheduler;
        this.logger.debug("setting task scheduler");
    }

    public void setSession(IoSession session) {
        this.mSession = session;
    }

    public IoSession getSession() {
        return this.mSession;
    }

    public void close() {
        if (this.mPacketSenderScheduledFuture != null && !this.mPacketSenderScheduledFuture.isDone()) {
            this.logger.debug("cancelling packet sender scheduledFuture");
            this.mPacketSenderScheduledFuture.cancel(false);
        }
        if (this.frameSender != null) {
            this.frameSender.closeMuxer(true);
            this.frameSender = null;
        }
        if (this.frameReceiver != null) {
            this.frameReceiver.closeMuxer();
            this.frameReceiver = null;
        }
        if (this.mPacketReceiverScheduledFuture != null && !this.mPacketReceiverScheduledFuture.isDone()) {
            this.logger.debug("cancelling packet receiver scheduledFuture");
            this.mPacketReceiverScheduledFuture.cancel(false);
        }
    }

    @Override
    public void muxingFinished(Runnable runnable) {
        if (this.mPacketSenderScheduledFuture != null && !this.mPacketSenderScheduledFuture.isDone()) {
            this.logger.debug("cancelling packet sender scheduledFuture");
            this.mPacketSenderScheduledFuture.cancel(false);
        }
    }

    public void setServer(IServer server) {
        this.mServer = server;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.mApplicationContext = applicationContext;
    }

    static /* synthetic */ int[][] access$302(RtspConnection x0, int[][] x1) {
        x0.serverPort = x1;
        return x1;
    }

    static /* synthetic */ int[][] access$402(RtspConnection x0, int[][] x1) {
        x0.clientPort = x1;
        return x1;
    }
}

