/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import com.mongodb.MongoClient;
import com.mongodb.WriteResult;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.query.FindOptions;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;

public class MongoStore
implements IDataStore {
    private Morphia morphia = new Morphia();
    private Datastore datastore;

    public MongoStore(String dbName) {
        this.morphia.mapPackage("io.antmedia.datastore.db.types");
        this.datastore = this.morphia.createDatastore(new MongoClient(), dbName);
        this.datastore.ensureIndexes();
    }

    public String save(Broadcast broadcast) {
        try {
            String streamId = null;
            if (broadcast.getStreamId() == null) {
                streamId = RandomStringUtils.randomAlphanumeric((int)12) + System.currentTimeMillis();
                broadcast.setStreamId(streamId);
            }
            streamId = broadcast.getStreamId();
            String rtmpURL = broadcast.getRtmpURL();
            if (rtmpURL != null) {
                rtmpURL = rtmpURL + streamId;
            }
            broadcast.setRtmpURL(rtmpURL);
            Key key = this.datastore.save((Object)broadcast);
            return streamId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Broadcast get(String id) {
        try {
            return (Broadcast)((Query)this.datastore.find(Broadcast.class).field("streamId").equal((Object)id)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean updateName(String id, String name, String description) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set("name", (Object)name).set("description", (Object)description);
            UpdateResults update = this.datastore.update(query, ops);
            return update.getUpdatedCount() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateStatus(String id, String status) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set("status", (Object)status);
            UpdateResults update = this.datastore.update(query, ops);
            return update.getUpdatedCount() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateDuration(String id, long duration) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set("duration", (Object)duration);
            UpdateResults update = this.datastore.update(query, ops);
            return update.getUpdatedCount() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updatePublish(String id, boolean publish) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("dbId").equal((Object)new ObjectId(id));
            UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set("publish", (Object)publish);
            UpdateResults update = this.datastore.update(query, ops);
            return update.getUpdatedCount() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean addEndpoint(String id, Endpoint endpoint) {
        if (id != null && endpoint != null) {
            try {
                Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
                UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).push("endPointList", (Object)endpoint);
                UpdateResults update = this.datastore.update(query, ops);
                return update.getUpdatedCount() == 1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean removeEndpoint(String id, Endpoint endpoint) {
        boolean result = false;
        if (id != null && endpoint != null) {
            UpdateOperations ops;
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            UpdateResults update = this.datastore.update(query, ops = this.datastore.createUpdateOperations(Broadcast.class).removeAll("endPointList", (Object)endpoint));
            return update.getUpdatedCount() == 1;
        }
        return result;
    }

    public boolean removeAllEndpoints(String id) {
        boolean result = false;
        if (id != null) {
            UpdateOperations ops;
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            UpdateResults update = this.datastore.update(query, ops = this.datastore.createUpdateOperations(Broadcast.class).unset("endPointList"));
            return update.getUpdatedCount() == 1;
        }
        return result;
    }

    public long getBroadcastCount() {
        return this.datastore.getCount(Broadcast.class);
    }

    public boolean delete(String id) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            WriteResult delete = this.datastore.delete(query);
            return delete.getN() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<Broadcast> getBroadcastList(int offset, int size) {
        return this.datastore.find(Broadcast.class).asList(new FindOptions().skip(offset).limit(size));
    }

    public Datastore getDataStore() {
        return this.datastore;
    }
}

