/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import com.google.gson.Gson;
import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointChannel;
import io.antmedia.muxer.Muxer;
import io.antmedia.rest.model.Result;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import io.antmedia.storage.StorageClient;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
@Path(value="/")
public class BroadcastRestService {
    private static final int ERROR_SOCIAL_ENDPOINT_UNDEFINED_CLIENT_ID = -1;
    private static final int ERROR_SOCIAL_ENDPOINT_UNDEFINED_ENDPOINT = -2;
    private static final int ERROR_SOCIAL_ENDPOINT_NO_ENDPOINT = -3;
    @Context
    private ServletContext servletContext;
    private IScope scope;
    private ApplicationContext appCtx;
    private static Gson gson = new Gson();
    private AntMediaApplicationAdapter app;
    private IDataStore dataStore;
    private AppSettings appSettings;
    protected static Logger logger = LoggerFactory.getLogger(BroadcastRestService.class);

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/create")
    @Produces(value={"application/json"})
    public Broadcast createBroadcast(Broadcast broadcast) {
        if (broadcast != null) {
            broadcast.resetStreamId();
        }
        return BroadcastRestService.saveBroadcast(broadcast, "created", this.getScope().getName(), this.getDataStore(), this.getAppSettings());
    }

    public static Broadcast saveBroadcast(Broadcast broadcast, String status, String scopeName, IDataStore dataStore, AppSettings settings) {
        if (broadcast == null) {
            broadcast = new Broadcast();
        }
        broadcast.setStatus(status);
        broadcast.setDate(Long.valueOf(System.currentTimeMillis()));
        String listenerHookURL = broadcast.getListenerHookURL();
        if (settings != null) {
            String fqdn;
            String settingsListenerHookURL;
            if ((listenerHookURL == null || listenerHookURL.length() == 0) && (settingsListenerHookURL = settings.getListenerHookURL()) != null && settingsListenerHookURL.length() > 0) {
                broadcast.setListenerHookURL(settingsListenerHookURL);
            }
            if ((fqdn = settings.getServerName()) == null || fqdn.length() == 0) {
                try {
                    fqdn = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
            if (fqdn != null && fqdn.length() >= 0) {
                broadcast.setRtmpURL("rtmp://" + fqdn + "/" + scopeName + "/");
            }
        }
        dataStore.save(broadcast);
        return broadcast;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/createWithSocial")
    @Produces(value={"application/json"})
    public Broadcast createWithSocial(Broadcast broadcast, @QueryParam(value="socialNetworks") String socialNetworksToPublish) {
        if ((broadcast = this.createBroadcast(broadcast)).getStreamId() != null && socialNetworksToPublish != null) {
            String[] socialNetworks;
            for (String networkName : socialNetworks = socialNetworksToPublish.split(",")) {
                this.addSocialEndpoint(broadcast.getStreamId(), networkName);
            }
        }
        return this.getBroadcast(broadcast.getStreamId());
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/stop/{streamId}")
    @Produces(value={"application/json"})
    public Result stopBroadcast(@PathParam(value="streamId") String streamId) {
        boolean result = false;
        String message = "";
        IBroadcastStream broadcastStream = this.getApplication().getBroadcastStream(this.getScope(), streamId);
        if (broadcastStream != null) {
            ((IClientBroadcastStream)broadcastStream).getConnection().close();
            result = true;
        } else {
            message = "No active broadcast found with id " + streamId;
        }
        return new Result(result, message);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/update")
    @Produces(value={"application/json"})
    public Result updateBroadcast(Broadcast broadcast, @QueryParam(value="socialNetworks") String socialNetworksToPublish) {
        boolean result = this.getDataStore().updateName(broadcast.getStreamId(), broadcast.getName(), broadcast.getDescription());
        String message = "";
        int errorId = 0;
        if (result) {
            Broadcast fetchedBroadcast = this.getDataStore().get(broadcast.getStreamId());
            this.getDataStore().removeAllEndpoints(fetchedBroadcast.getStreamId());
            if (socialNetworksToPublish != null && socialNetworksToPublish.length() > 0) {
                String[] socialNetworks;
                for (String networkName : socialNetworks = socialNetworksToPublish.split(",")) {
                    Result addSocialEndpoint = this.addSocialEndpoint(broadcast.getStreamId(), networkName);
                    if (addSocialEndpoint.isSuccess()) continue;
                    result = false;
                    message = message + networkName + " ";
                    errorId = -1;
                    break;
                }
            }
        }
        if (message.length() > 0) {
            message = message + " endpoint cannot be added";
        }
        return new Result(result, message, errorId);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/broadcast/updatePublishStatus")
    @Produces(value={"application/json"})
    public Result updatePublishInfo(@FormParam(value="id") String id, @FormParam(value="publish") boolean publish) {
        boolean success = false;
        String message = null;
        if (this.getDataStore().updatePublish(id, publish)) {
            success = true;
            message = "Modified count is not equal to 1";
        }
        return new Result(success, message);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/revokeSocialNetwork/{serviceName}")
    @Produces(value={"application/json"})
    public Result revokeSocialNetwork(@PathParam(value="serviceName") String serviceName) {
        List<VideoServiceEndpoint> endPoint = this.getEndpointList();
        String message = null;
        boolean serviceFound = false;
        boolean result = false;
        if (endPoint != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                if (!videoServiceEndpoint.getName().equals(serviceName)) continue;
                serviceFound = true;
                try {
                    videoServiceEndpoint.resetCredentials();
                    result = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!serviceFound) {
                message = "Service with the name specified is not found in this app";
            }
        } else {
            message = "No endpoint is defined for this app";
        }
        return new Result(result, message);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/broadcast/addSocialEndpoint")
    @Produces(value={"application/json"})
    public Result addSocialEndpoint(@FormParam(value="id") String id, @FormParam(value="serviceName") String serviceName) {
        boolean success = false;
        String message = null;
        Broadcast broadcast = this.lookupBroadcast(id);
        if (broadcast != null) {
            List<VideoServiceEndpoint> endPointServiceList = this.getEndpointList();
            if (endPointServiceList != null) {
                boolean serviceFound = false;
                for (VideoServiceEndpoint videoServiceEndpoint : endPointServiceList) {
                    boolean authenticated;
                    if (!videoServiceEndpoint.getName().equals(serviceName)) continue;
                    serviceFound = true;
                    boolean bl = authenticated = videoServiceEndpoint.isInitialized() && videoServiceEndpoint.isAuthenticated();
                    if (authenticated) {
                        try {
                            Endpoint endpoint = videoServiceEndpoint.createBroadcast(broadcast.getName(), broadcast.getDescription(), broadcast.isIs360(), broadcast.isPublicStream(), 720);
                            success = this.getDataStore().addEndpoint(id, endpoint);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            message = e.getMessage();
                        }
                        continue;
                    }
                    message = serviceName + " is not authenticated. Authenticate first";
                }
                if (!serviceFound) {
                    message = serviceName + " endpoint does not exist in this app.";
                }
            } else {
                message = "No social endpoint is defined for this app. Consult your app developer";
            }
        } else {
            message = "No broadcast exist with the id specified";
        }
        return new Result(success, message);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/broadcast/addEndpoint")
    @Produces(value={"application/json"})
    public Result addEndpoint(@FormParam(value="id") String id, @FormParam(value="rtmpUrl") String rtmpUrl) {
        boolean success = false;
        String message = null;
        try {
            Broadcast broadcast = this.lookupBroadcast(id);
            Endpoint endpoint = new Endpoint();
            endpoint.rtmpUrl = rtmpUrl;
            endpoint.type = "generic";
            success = this.getDataStore().addEndpoint(id, endpoint);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Result(success, message);
    }

    protected Broadcast lookupBroadcast(String id) {
        Broadcast broadcast = null;
        try {
            broadcast = this.getDataStore().get(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return broadcast;
    }

    @GET
    @Path(value="/broadcast/get")
    @Produces(value={"application/json"})
    public Broadcast getBroadcast(@QueryParam(value="id") String id) {
        Broadcast broadcast = null;
        if (id != null) {
            broadcast = this.lookupBroadcast(id);
        }
        if (broadcast == null) {
            broadcast = new Broadcast();
        }
        return broadcast;
    }

    @GET
    @Path(value="/broadcast/getList/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<Broadcast> getBroadcastList(@PathParam(value="offset") int offset, @PathParam(value="size") int size) {
        return this.getDataStore().getBroadcastList(offset, size);
    }

    @GET
    @Path(value="/broadcast/getAppLiveStatistics")
    @Produces(value={"application/json"})
    public LiveStatistics getAppLiveStatistics() {
        Set basicBroadcastScopes = this.getScope().getBasicScopeNames(ScopeType.BROADCAST);
        int totalLiveStreamCount = this.getScope().getBasicScopeNames(ScopeType.BROADCAST).size();
        int totalRTMPWatcherCount = this.getScope().getStatistics().getActiveClients() - totalLiveStreamCount;
        return new LiveStatistics(totalLiveStreamCount, totalRTMPWatcherCount, 0, 0);
    }

    @GET
    @Path(value="/broadcast/getBroadcastLiveStatistics")
    @Produces(value={"application/json"})
    public BroadcastStatistics getBroadcastStatistics(@QueryParam(value="id") String id) {
        IBroadcastScope broadcastScope = this.getScope().getBroadcastScope(id);
        BroadcastStatistics broadcastStatistics = null;
        broadcastStatistics = broadcastScope != null ? new BroadcastStatistics(broadcastScope.getConsumers().size(), 0, 0) : new BroadcastStatistics(-1, -1, -1);
        return broadcastStatistics;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/deleteVoDFile/{id}")
    @Produces(value={"application/json"})
    public Result deleteVoDFile(@PathParam(value="id") String fileName) {
        boolean success = false;
        String message = "";
        if (this.getAppContext() != null) {
            File recordFile = Muxer.getRecordFile((IScope)this.getScope(), (String)fileName, (String)".mp4");
            System.out.println("recordfile : " + recordFile.getAbsolutePath());
            if (recordFile.exists()) {
                success = true;
                recordFile.delete();
            } else {
                message = "No file to delete";
            }
            File previewFile = Muxer.getPreviewFile((IScope)this.getScope(), (String)fileName, (String)".png");
            if (previewFile.exists()) {
                previewFile.delete();
            }
            if (this.getAppContext().containsBean("app.storageClient")) {
                StorageClient storageClient = (StorageClient)this.getAppContext().getBean("app.storageClient");
                storageClient.delete(fileName + ".mp4", StorageClient.FileType.TYPE_STREAM);
                storageClient.delete(fileName + ".png", StorageClient.FileType.TYPE_PREVIEW);
            }
        }
        return new Result(success, message);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/delete/{id}")
    @Produces(value={"application/json"})
    public Result deleteBroadcast(@PathParam(value="id") String id) {
        boolean success = false;
        String message = null;
        if (this.getDataStore().delete(id)) {
            success = true;
        }
        return new Result(success, message);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/getDeviceAuthParameters/{serviceName}")
    @Produces(value={"application/json"})
    public Object getDeviceAuthParameters(@PathParam(value="serviceName") String serviceName) {
        List<VideoServiceEndpoint> endPoint = this.getEndpointList();
        String message = null;
        int errorId = 0;
        boolean serviceFound = false;
        if (endPoint != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                if (!videoServiceEndpoint.getName().equals(serviceName)) continue;
                serviceFound = true;
                try {
                    if (videoServiceEndpoint.isInitialized()) {
                        VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters = videoServiceEndpoint.askDeviceAuthParameters();
                        this.getApplication().startDeviceAuthStatusPolling(videoServiceEndpoint, askDeviceAuthParameters);
                        return askDeviceAuthParameters;
                    }
                    message = "Please enter service client id and client secret in app configuration";
                    errorId = -1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!serviceFound) {
                message = "Service with the name specified is not found in this app";
                errorId = -2;
            }
        } else {
            message = "No endpoint is defined for this app";
            errorId = -3;
        }
        return new Result(false, message, errorId);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/checkDeviceAuthStatus/{serviceName}")
    @Produces(value={"application/json"})
    public Result checkDeviceAuthStatus(@PathParam(value="serviceName") String serviceName) {
        List<VideoServiceEndpoint> endPoint = this.getEndpointList();
        boolean authenticated = false;
        if (endPoint != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                if (!videoServiceEndpoint.getName().equals(serviceName)) continue;
                authenticated = videoServiceEndpoint.isInitialized() && videoServiceEndpoint.isAuthenticated();
            }
        }
        return new Result(authenticated, null);
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/getSocialNetworkChannel/{serviceName}")
    @Produces(value={"application/json"})
    public SocialEndpointChannel getSocialNetworkChannel(@PathParam(value="serviceName") String serviceName) {
        List<VideoServiceEndpoint> endPoint = this.getEndpointList();
        SocialEndpointChannel channel = null;
        if (endPoint != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                if (!videoServiceEndpoint.getName().equals(serviceName)) continue;
                channel = videoServiceEndpoint.getChannel();
                break;
            }
        }
        return channel;
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/getSocialNetworkChannelList/{serviceName}/{type}")
    @Produces(value={"application/json"})
    public List<SocialEndpointChannel> getSocialNetworkChannelList(@PathParam(value="serviceName") String serviceName, @PathParam(value="type") String type) {
        List<VideoServiceEndpoint> endPoint = this.getEndpointList();
        List<SocialEndpointChannel> channelList = null;
        if (endPoint != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                if (!videoServiceEndpoint.getName().equals(serviceName)) continue;
                channelList = videoServiceEndpoint.getChannelList(type);
                break;
            }
        }
        return channelList;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/setSocialNetworkChannel/{serviceName}/{type}/{id}")
    @Produces(value={"application/json"})
    public Result setSocialNetworkChannelList(@PathParam(value="serviceName") String serviceName, @PathParam(value="type") String type, @PathParam(value="id") String id) {
        boolean result = false;
        List<VideoServiceEndpoint> endPoint = this.getEndpointList();
        if (endPoint != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                if (!videoServiceEndpoint.getName().equals(serviceName)) continue;
                result = videoServiceEndpoint.setActiveChannel(type, id);
                break;
            }
        }
        return new Result(result, null);
    }

    public static boolean isEnterprise() {
        try {
            Class.forName("io.antmedia.enterprise.adaptive.EncoderAdaptor");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public long getRecordCount() {
        return this.getDataStore().getBroadcastCount();
    }

    protected List<VideoServiceEndpoint> getEndpointList() {
        return this.getApplication().getVideoServiceEndpoints();
    }

    private ApplicationContext getAppContext() {
        if (this.appCtx == null && this.servletContext != null) {
            this.appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        return this.appCtx;
    }

    public IDataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = (IDataStore)this.getAppContext().getBean("db.datastore");
        }
        return this.dataStore;
    }

    public void setDataStore(IDataStore dataStore) {
        this.dataStore = dataStore;
    }

    protected AntMediaApplicationAdapter getApplication() {
        if (this.app == null) {
            this.app = (AntMediaApplicationAdapter)this.getAppContext().getBean("web.handler");
        }
        return this.app;
    }

    private AppSettings getAppSettings() {
        if (this.appSettings == null) {
            this.appSettings = (AppSettings)this.getAppContext().getBean("app.settings");
        }
        return this.appSettings;
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = this.getApplication().getScope();
        }
        return this.scope;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public void setAppCtx(ApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public static class LiveStatistics
    extends BroadcastStatistics {
        public final int totalLiveStreamCount;

        public LiveStatistics(int totalLiveStreamCount, int totalRTMPWatchersCount, int totalHLSWatchersCount, int totalWebRTCWatchersCount) {
            super(totalRTMPWatchersCount, totalHLSWatchersCount, totalWebRTCWatchersCount);
            this.totalLiveStreamCount = totalLiveStreamCount;
        }
    }

    public static class BroadcastStatistics {
        public final int totalRTMPWatchersCount;
        public final int totalHLSWatchersCount;
        public final int totalWebRTCWatchersCount;

        public BroadcastStatistics(int totalRTMPWatchersCount, int totalHLSWatchersCount, int totalWebRTCWatchersCount) {
            this.totalRTMPWatchersCount = totalRTMPWatchersCount;
            this.totalHLSWatchersCount = totalHLSWatchersCount;
            this.totalWebRTCWatchersCount = totalWebRTCWatchersCount;
        }
    }
}

