/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtc;

import io.antmedia.muxer.Muxer;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.antmedia.webrtc.api.IWebRTCClient;
import io.antmedia.webrtc.api.IWebRTCMuxer;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.avcodec;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;
import org.red5.server.api.scope.IScope;
import org.red5.server.scheduling.QuartzSchedulingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRTCMuxer
extends Muxer
implements IWebRTCMuxer {
    private IWebRTCAdaptor webRTCAdaptor;
    private ConcurrentLinkedQueue<IWebRTCClient> webRTCClientList = new ConcurrentLinkedQueue();
    private String streamId;
    private int width;
    private int height;
    private int videoBitrate;
    private int audioBitrate;
    protected int videoStreamIndex = -1;
    protected int audioStreamIndex = -1;
    private boolean videoConfParsed = false;
    private byte[] sps;
    private byte[] pps;
    private byte[] keyFrame;
    private byte[] videoConf;
    private boolean isPrepareIOCalled = false;
    protected avutil.AVRational videoTimebase;
    protected avutil.AVRational audioTimebase;
    protected static Logger logger = LoggerFactory.getLogger(WebRTCMuxer.class);
    private avutil.AVRational timeBaseForMS;

    public WebRTCMuxer(QuartzSchedulingService scheduler, IWebRTCAdaptor webRTCAdaptor) {
        super(scheduler);
        this.webRTCAdaptor = webRTCAdaptor;
        this.timeBaseForMS = new avutil.AVRational();
        this.timeBaseForMS.num(1);
        this.timeBaseForMS.den(1000);
    }

    public void init(IScope scope, String name, int resolution) {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.streamId = name;
        }
    }

    @Override
    public void setWebRTCAdaptor(IWebRTCAdaptor webRTCAdaptor) {
        this.webRTCAdaptor = webRTCAdaptor;
    }

    @Override
    public void registerToAdaptor() {
        this.webRTCAdaptor.registerMuxer(this.streamId, this);
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public int getVideoHeight() {
        return this.height;
    }

    @Override
    public int getVideoWidth() {
        return this.width;
    }

    @Override
    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    @Override
    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    @Override
    public void registerWebRTCClient(IWebRTCClient webRTCClient) {
        this.webRTCClientList.add(webRTCClient);
        webRTCClient.setWebRTCMuxer(this);
        webRTCClient.setVideoResolution(this.width, this.height);
        if (this.videoConfParsed) {
            webRTCClient.sendVideoConfPacket(this.videoConf, this.keyFrame, 0L);
        }
    }

    @Override
    public boolean unRegisterWebRTCClient(IWebRTCClient webRTCClient) {
        return this.webRTCClientList.remove(webRTCClient);
    }

    @Override
    public void sendVideoPacket(byte[] videoPacket, boolean isKeyFrame, long timestamp) {
        for (IWebRTCClient iWebRTCClient : this.webRTCClientList) {
            iWebRTCClient.sendVideoPacket(videoPacket, isKeyFrame, timestamp);
        }
    }

    public void sendVideoConfPacket(byte[] videoPacket, long timestamp) {
        for (IWebRTCClient iWebRTCClient : this.webRTCClientList) {
            iWebRTCClient.sendVideoConfPacket(this.videoConf, videoPacket, timestamp);
        }
    }

    @Override
    public void sendAudioPacket(byte[] audioPacket, long timestamp) {
        for (IWebRTCClient iWebRTCClient : this.webRTCClientList) {
            iWebRTCClient.sendAudioPacket(audioPacket, timestamp);
        }
    }

    public boolean prepare(avformat.AVFormatContext inputFormatContext) {
        return true;
    }

    public boolean addStream(avcodec.AVCodec codec, avcodec.AVCodecContext codecContext, int streamIndex) {
        if (codecContext.codec_type() == 0) {
            this.videoStreamIndex = streamIndex;
            this.width = codecContext.width();
            this.height = codecContext.height();
            this.videoBitrate = (int)codecContext.bit_rate();
            this.videoTimebase = codecContext.time_base();
        } else if (codecContext.codec_type() == 1) {
            this.audioStreamIndex = streamIndex;
            this.audioBitrate = (int)codecContext.bit_rate();
            this.audioTimebase = codecContext.time_base();
        }
        return true;
    }

    public synchronized boolean prepareIO() {
        if (!this.isPrepareIOCalled) {
            this.isPrepareIOCalled = true;
            this.registerToAdaptor();
        }
        return true;
    }

    public synchronized void writeTrailer() {
        this.webRTCAdaptor.unRegisterMuxer(this.streamId, this);
        for (IWebRTCClient iWebRTCClient : this.webRTCClientList) {
            iWebRTCClient.stop();
        }
    }

    public void writePacket(avcodec.AVPacket avpacket, avformat.AVStream inStream) {
    }

    public int findNALStartCode(byte[] data, int offset) {
        int i;
        for (i = offset; i < data.length; ++i) {
            if (data[i] != 0 || data[i + 1] != 0 || data[i + 2] != 1 && (data[i + 2] != 0 || data[i + 3] != 1)) continue;
            return i;
        }
        if (i == data.length) {
            return i;
        }
        return -1;
    }

    public boolean parseVideoConfData(byte[] data) {
        int nalEndIndex;
        int nalStartIndex = this.findNALStartCode(data, 0);
        while ((nalEndIndex = this.findNALStartCode(data, nalStartIndex + 3)) != -1) {
            int nalLength = 0;
            int startCodeLength = 3;
            if (data[nalStartIndex + 3] == 1) {
                startCodeLength = 4;
            }
            nalLength = nalEndIndex - nalStartIndex - startCodeLength;
            byte nalType = (byte)(data[nalStartIndex + startCodeLength] & 0x1F);
            if (nalType == 7) {
                this.sps = new byte[nalLength + startCodeLength];
                System.arraycopy(data, nalStartIndex, this.sps, 0, nalLength + startCodeLength);
            } else if (nalType == 8) {
                this.pps = new byte[nalLength + startCodeLength];
                System.arraycopy(data, nalStartIndex, this.pps, 0, nalLength + startCodeLength);
            } else if (nalType == 5) {
                this.keyFrame = new byte[nalLength + startCodeLength];
                System.arraycopy(data, nalStartIndex, this.keyFrame, 0, nalLength + startCodeLength);
            }
            nalStartIndex = nalEndIndex;
        }
        return this.sps != null && this.pps != null && this.keyFrame != null;
    }

    public synchronized void writePacket(avcodec.AVPacket pkt) {
        if (pkt.stream_index() == this.videoStreamIndex) {
            long pts = avutil.av_rescale_q((long)pkt.pts(), (avutil.AVRational)this.videoTimebase, (avutil.AVRational)this.timeBaseForMS);
            BytePointer data = pkt.data();
            byte[] byteArray = new byte[pkt.size()];
            data.get(byteArray, 0, byteArray.length);
            boolean isKeyFrame = false;
            if ((pkt.flags() & 1) == 1) {
                isKeyFrame = true;
            }
            if (!this.videoConfParsed) {
                this.videoConfParsed = true;
                this.parseVideoConfData(byteArray);
                this.videoConf = new byte[this.sps.length + this.pps.length];
                System.arraycopy(this.sps, 0, this.videoConf, 0, this.sps.length);
                System.arraycopy(this.pps, 0, this.videoConf, this.sps.length, this.pps.length);
                this.sendVideoConfPacket(this.keyFrame, pts);
            } else {
                if (isKeyFrame) {
                    this.keyFrame = byteArray;
                }
                this.sendVideoPacket(byteArray, isKeyFrame, pts);
            }
        } else if (pkt.stream_index() == this.audioStreamIndex) {
            long pts = avutil.av_rescale_q((long)pkt.pts(), (avutil.AVRational)this.audioTimebase, (avutil.AVRational)this.timeBaseForMS);
            BytePointer data = pkt.data();
            byte[] byteArray = new byte[pkt.size()];
            data.get(byteArray, 0, byteArray.length);
            this.sendAudioPacket(byteArray, pts);
        }
    }

    public boolean isExtradata_parsed() {
        return this.videoConfParsed;
    }

    public void setExtradata_parsed(boolean extradata_parsed) {
        this.videoConfParsed = extradata_parsed;
    }

    public byte[] getKeyFrame() {
        return this.keyFrame;
    }

    public void setKeyFrame(byte[] keyFrame) {
        this.keyFrame = keyFrame;
    }

    public byte[] getPps() {
        return this.pps;
    }

    public void setPps(byte[] pps) {
        this.pps = pps;
    }

    public byte[] getSps() {
        return this.sps;
    }

    public void setSps(byte[] sps) {
        this.sps = sps;
    }

    @Override
    public boolean contains(IWebRTCClient webRTCClient) {
        return this.webRTCClientList.contains(webRTCClient);
    }

    public void setVideoResolution(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setBitrate(int videoBitrate, int audioBitrate) {
        this.videoBitrate = videoBitrate;
        this.audioBitrate = audioBitrate;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }
}

