/*
 * Decompiled with CFR 0.152.
 */
package com.antstreaming.rtsp.protocol;

import com.antstreaming.rtsp.protocol.RtspMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtspRequest
extends RtspMessage {
    private static Logger logger = LoggerFactory.getLogger(RtspRequest.class);
    private Verb verb = Verb.None;
    private String url;

    @Override
    public RtspMessage.Type getType() {
        return RtspMessage.Type.TypeRequest;
    }

    public String getVerbString() {
        return this.verb.toString();
    }

    public void setVerb(Verb verb) {
        this.verb = verb;
    }

    public Verb getVerb() {
        return this.verb;
    }

    public void setVerb(String strVerb) {
        try {
            this.verb = Verb.valueOf(strVerb);
        }
        catch (Exception e) {
            this.verb = Verb.None;
            logger.error("Invalid verb: " + strVerb);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getVerbString() + " ");
        sb.append(this.url != null ? this.url : "*");
        sb.append(" RTSP/1.0\r\n");
        sb.append(this.getHeadersString());
        sb.append("\r\n");
        if (this.getBufferSize() > 0) {
            sb.append(this.getBuffer());
        }
        return sb.toString();
    }

    public static enum Verb {
        None,
        ANNOUNCE,
        DESCRIBE,
        GET_PARAMETER,
        OPTIONS,
        PAUSE,
        PLAY,
        RECORD,
        REDIRECT,
        SETUP,
        SET_PARAMETER,
        TEARDOWN,
        PING;

    }
}

