/*
 * Decompiled with CFR 0.152.
 */
package com.antstreaming.rtsp.protocol;

import com.antstreaming.rtsp.protocol.RtspCode;
import com.antstreaming.rtsp.protocol.RtspMessage;
import com.antstreaming.rtsp.protocol.RtspRequest;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtspResponse
extends RtspMessage {
    private static Logger logger = LoggerFactory.getLogger(RtspResponse.class);
    RtspCode code;
    RtspRequest.Verb requestVerb = RtspRequest.Verb.None;

    public RtspResponse() {
        this.code = RtspCode.OK;
    }

    @Override
    public RtspMessage.Type getType() {
        return RtspMessage.Type.TypeResponse;
    }

    public RtspCode getCode() {
        return this.code;
    }

    public void setCode(RtspCode code) {
        this.code = code;
    }

    public void setRequestVerb(RtspRequest.Verb requestVerb) {
        this.requestVerb = requestVerb;
    }

    public RtspRequest.Verb getRequestVerb() {
        return this.requestVerb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RTSP/1.0 ").append(this.code.value()).append(" ");
        sb.append(this.code.description()).append("\r\n");
        sb.append(this.getHeadersString());
        sb.append("\r\n");
        if (this.getBufferSize() > 0) {
            sb.append(this.getBuffer());
            logger.debug("Buffer Size: " + this.getBufferSize());
        }
        return sb.toString();
    }

    public ByteBuffer toByteBuffer() throws Exception {
        try {
            String msg = this.toString();
            ByteBuffer buffer = ByteBuffer.wrap(msg.getBytes("UTF-8"));
            return buffer;
        }
        catch (Exception e) {
            logger.error("failed to serialize message to byte buffer", (Throwable)e);
            throw e;
        }
    }

    public static RtspResponse errorResponse(RtspCode errorCode) {
        RtspResponse response = new RtspResponse();
        response.setCode(errorCode);
        return response;
    }
}

