/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.Vod;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBStore
implements IDataStore {
    private DB db;
    private BTreeMap<String, String> map;
    private BTreeMap<String, String> vodMap;
    private BTreeMap<String, String> userVodMap;
    private Gson gson;
    private BTreeMap<String, String> socialEndpointsCredentialsMap;
    protected static Logger logger = LoggerFactory.getLogger(MapDBStore.class);
    private static final String MAP_NAME = "broadcast";
    private static final String VOD_MAP_NAME = "vod";
    private static final String USER_MAP_NAME = "userVod";
    private static final String SOCIAL_ENDPONT_CREDENTIALS_MAP_NAME = "SOCIAL_ENDPONT_CREDENTIALS_MAP_NAME";

    public MapDBStore(String dbName) {
        this.db = DBMaker.fileDB((String)dbName).transactionEnable().make();
        this.map = this.db.treeMap(MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.vodMap = this.db.treeMap(VOD_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.userVodMap = this.db.treeMap(USER_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.socialEndpointsCredentialsMap = this.db.treeMap(SOCIAL_ENDPONT_CREDENTIALS_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        GsonBuilder builder = new GsonBuilder();
        this.gson = builder.create();
    }

    public BTreeMap<String, String> getUserVodMap() {
        return this.userVodMap;
    }

    public void setUserVodMap(BTreeMap<String, String> userVodMap) {
        this.userVodMap = userVodMap;
    }

    public BTreeMap<String, String> getVodMap() {
        return this.vodMap;
    }

    public void setVodMap(BTreeMap<String, String> vodMap) {
        this.vodMap = vodMap;
    }

    public BTreeMap<String, String> getMap() {
        return this.map;
    }

    public void setMap(BTreeMap<String, String> map) {
        this.map = map;
    }

    public String save(Broadcast broadcast) {
        String streamId = null;
        boolean result = false;
        if (broadcast != null) {
            try {
                if (broadcast.getStreamId() == null) {
                    streamId = RandomStringUtils.randomNumeric((int)24);
                    broadcast.setStreamId(streamId);
                }
                streamId = broadcast.getStreamId();
                String rtmpURL = broadcast.getRtmpURL();
                if (rtmpURL != null) {
                    rtmpURL = rtmpURL + streamId;
                }
                broadcast.setRtmpURL(rtmpURL);
                this.map.put((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                streamId = null;
            }
        }
        return streamId;
    }

    public Broadcast get(String id) {
        String jsonString;
        if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            return (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
        }
        return null;
    }

    public boolean updateName(String id, String name, String description) {
        String jsonString;
        boolean result = false;
        if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            broadcast.setName(name);
            broadcast.setDescription(description);
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public boolean updateStatus(String id, String status) {
        String jsonString;
        boolean result = false;
        if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            broadcast.setStatus(status);
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public boolean updateDuration(String id, long duration) {
        String jsonString;
        boolean result = false;
        if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            broadcast.setDuration(Long.valueOf(duration));
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public boolean updatePublish(String id, boolean publish) {
        String jsonString = (String)this.map.get((Object)id);
        boolean result = false;
        if (jsonString != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            broadcast.setPublish(publish);
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public boolean addEndpoint(String id, Endpoint endpoint) {
        String jsonString;
        boolean result = false;
        if (id != null && endpoint != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            ArrayList<Endpoint> endPointList = broadcast.getEndPointList();
            if (endPointList == null) {
                endPointList = new ArrayList<Endpoint>();
            }
            endPointList.add(endpoint);
            broadcast.setEndPointList(endPointList);
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public boolean removeEndpoint(String id, Endpoint endpoint) {
        Broadcast broadcast;
        List endPointList;
        String jsonString;
        boolean result = false;
        if (id != null && endpoint != null && (jsonString = (String)this.map.get((Object)id)) != null && (endPointList = (broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class)).getEndPointList()) != null) {
            Iterator iterator = endPointList.iterator();
            while (iterator.hasNext()) {
                Endpoint endpointItem = (Endpoint)iterator.next();
                if (!endpointItem.rtmpUrl.equals(endpoint.rtmpUrl)) continue;
                iterator.remove();
                result = true;
                break;
            }
            if (result) {
                broadcast.setEndPointList(endPointList);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
            }
        }
        return result;
    }

    public boolean removeAllEndpoints(String id) {
        String jsonString;
        boolean result = false;
        if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            broadcast.setEndPointList(null);
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public long getBroadcastCount() {
        return this.map.getSize();
    }

    public boolean delete(String id) {
        boolean result;
        boolean bl = result = this.map.remove((Object)id) != null;
        if (result) {
            this.db.commit();
        }
        return result;
    }

    public List<Broadcast> getBroadcastList(int offset, int size) {
        Collection values = this.map.values();
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        for (String broadcastString : values) {
            if (t < offset) {
                ++t;
                continue;
            }
            list.add((Broadcast)this.gson.fromJson(broadcastString, Broadcast.class));
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }

    public List<Vod> getVodList(int offset, int size) {
        Collection values = this.vodMap.values();
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        ArrayList<Vod> list = new ArrayList<Vod>();
        for (String vodString : values) {
            if (t < offset) {
                ++t;
                continue;
            }
            list.add((Vod)this.gson.fromJson(vodString, Vod.class));
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }

    public List<Broadcast> filterBroadcastList(int offset, int size, String type) {
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        Object[] objectArray = this.map.getValues().toArray();
        Broadcast[] broadcastArray = new Broadcast[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            broadcastArray[i] = (Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class);
        }
        ArrayList<Object> filterList = new ArrayList<Object>();
        for (int i = 0; i < broadcastArray.length; ++i) {
            if (!broadcastArray[i].getType().equals(type)) continue;
            filterList.add(this.gson.fromJson((String)objectArray[i], Broadcast.class));
        }
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        for (Broadcast broadcast : filterList) {
            if (t < offset) {
                ++t;
                continue;
            }
            list.add(broadcast);
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }

    public boolean addVod(String id, Vod vod) {
        String vodId = null;
        boolean result = false;
        if (vod != null) {
            try {
                vodId = RandomStringUtils.randomNumeric((int)24);
                vod.setVodId(vodId);
                this.vodMap.put((Object)vodId, (Object)this.gson.toJson((Object)vod));
                this.db.commit();
                result = true;
                logger.warn(Long.toString(vod.getCreationDate()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean addUserVod(String id, Vod vod) {
        String vodId = null;
        boolean result = false;
        if (vod != null) {
            try {
                vodId = RandomStringUtils.randomNumeric((int)24);
                vod.setVodId(vodId);
                this.vodMap.put((Object)vodId, (Object)this.gson.toJson((Object)vod));
                this.db.commit();
                result = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean editCameraInfo(Broadcast camera) {
        boolean result = false;
        try {
            logger.warn("inside of editCameraInfo");
            Broadcast oldCam = this.get(camera.getStreamId());
            oldCam.setName(camera.getName());
            oldCam.setUsername(camera.getUsername());
            oldCam.setPassword(camera.getPassword());
            oldCam.setIpAddr(camera.getIpAddr());
            this.getMap().replace((Object)oldCam.getStreamId(), (Object)this.gson.toJson((Object)oldCam));
            this.db.commit();
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        logger.warn("result inside edit camera: " + result);
        return result;
    }

    public boolean deleteStream(String id) {
        boolean result = false;
        try {
            if (this.map.containsKey((Object)id)) {
                logger.warn("inside of deleteStream");
                this.map.remove((Object)id);
                this.db.commit();
                result = true;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public Broadcast getCamera(String ipAddr) {
        Object[] objectArray = this.map.getValues().toArray();
        Broadcast[] broadcastArray = new Broadcast[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            broadcastArray[i] = (Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class);
        }
        Broadcast camera = new Broadcast();
        for (int i = 0; i < broadcastArray.length; ++i) {
            if (broadcastArray[i].getType() != "ipCamera" || !broadcastArray[i].getIpAddr().equals(ipAddr)) continue;
            camera = broadcastArray[i];
            break;
        }
        return camera;
    }

    public List<Broadcast> getExternalStreamsList() {
        int i;
        Object[] objectArray = this.map.getValues().toArray();
        Broadcast[] broadcastArray = new Broadcast[objectArray.length];
        ArrayList<Broadcast> streamsList = new ArrayList<Broadcast>();
        for (i = 0; i < objectArray.length; ++i) {
            broadcastArray[i] = (Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class);
        }
        for (i = 0; i < broadcastArray.length; ++i) {
            if (!broadcastArray[i].getType().equals("ipCamera") && !broadcastArray[i].getType().equals("streamSource")) continue;
            streamsList.add((Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class));
        }
        return streamsList;
    }

    public void close() {
        this.db.close();
    }

    public boolean deleteVod(String id) {
        boolean result;
        boolean bl = result = this.vodMap.remove((Object)id) != null;
        if (result) {
            this.db.commit();
        }
        return result;
    }

    public long getTotalVodNumber() {
        return this.getVodMap().size();
    }

    public boolean fetchUserVodList(File userfile) {
        File[] listOfFiles;
        int i;
        Object[] objectArray = this.vodMap.getValues().toArray();
        Vod[] vodtArray = new Vod[objectArray.length];
        for (i = 0; i < objectArray.length; ++i) {
            vodtArray[i] = (Vod)this.gson.fromJson((String)objectArray[i], Vod.class);
        }
        for (i = 0; i < vodtArray.length; ++i) {
            if (!vodtArray[i].getType().equals(USER_MAP_NAME)) continue;
            this.vodMap.remove((Object)vodtArray[i].getVodId());
        }
        for (File file : listOfFiles = userfile.listFiles()) {
            String fileExtension = FilenameUtils.getExtension((String)file.getName());
            if (!file.isFile() || !fileExtension.equals("mp4")) continue;
            long fileSize = file.length();
            long unixTime = System.currentTimeMillis();
            Vod newVod = new Vod("vodFile", "vodFile", file.getPath(), file.getName(), unixTime, 0L, fileSize, USER_MAP_NAME);
            this.addUserVod("vodFile", newVod);
        }
        return true;
    }

    public boolean updateSourceQuality(String id, String quality) {
        String jsonString;
        boolean result = false;
        if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            broadcast.setQuality(quality);
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public boolean updateSourceSpeed(String id, double speed) {
        String jsonString;
        boolean result = false;
        if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            broadcast.setSpeed(speed);
            this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public SocialEndpointCredentials addSocialEndpointCredentials(SocialEndpointCredentials credentials) {
        SocialEndpointCredentials addedCredential = null;
        if (credentials != null && credentials.getAccountName() != null && credentials.getAccessToken() != null && credentials.getServiceName() != null) {
            if (credentials.getId() == null) {
                String id = RandomStringUtils.randomAlphanumeric((int)6);
                credentials.setId(id);
                this.socialEndpointsCredentialsMap.put((Object)id, (Object)this.gson.toJson((Object)credentials));
                this.db.commit();
                addedCredential = credentials;
            } else if (this.socialEndpointsCredentialsMap.get((Object)credentials.getId()) != null) {
                this.socialEndpointsCredentialsMap.put((Object)credentials.getId(), (Object)this.gson.toJson((Object)credentials));
                this.db.commit();
                addedCredential = credentials;
            }
        }
        return addedCredential;
    }

    public List<SocialEndpointCredentials> getSocialEndpoints(int offset, int size) {
        Collection values = this.socialEndpointsCredentialsMap.values();
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        ArrayList<SocialEndpointCredentials> list = new ArrayList<SocialEndpointCredentials>();
        for (String credentialString : values) {
            if (t < offset) {
                ++t;
                continue;
            }
            list.add((SocialEndpointCredentials)this.gson.fromJson(credentialString, SocialEndpointCredentials.class));
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }

    public boolean removeSocialEndpointCredentials(String id) {
        boolean result;
        boolean bl = result = this.socialEndpointsCredentialsMap.remove((Object)id) != null;
        if (result) {
            this.db.commit();
        }
        return result;
    }

    public SocialEndpointCredentials getSocialEndpointCredentials(String id) {
        String jsonString;
        SocialEndpointCredentials credential = null;
        if (id != null && (jsonString = (String)this.socialEndpointsCredentialsMap.get((Object)id)) != null) {
            credential = (SocialEndpointCredentials)this.gson.fromJson(jsonString, SocialEndpointCredentials.class);
        }
        return credential;
    }
}

