/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.datastore.db.MapDBStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.ipcamera.OnvifCamera;
import io.antmedia.ipcamera.onvifdiscovery.OnvifDiscovery;
import io.antmedia.rest.model.Result;
import io.antmedia.streamsource.StreamSources;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.red5.server.api.scope.IScope;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Component
@Path(value="/streamSource")
public class StreamsSourceRestService {
    @Context
    private ServletContext servletContext;
    private MapDBStore dbStore;
    private ApplicationContext appCtx;
    private StreamSources app;
    private IScope scope;
    private AntMediaApplicationAdapter appInstance;
    protected static Logger logger = LoggerFactory.getLogger(StreamsSourceRestService.class);

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/addStreamSource")
    @Produces(value={"application/json"})
    public Result addStreamSource(Broadcast stream) {
        boolean result = false;
        String message = "";
        if (stream.getName() != null && stream.getName().length() > 0) {
            if (stream.getType().equals("ipCamera")) {
                OnvifCamera onvif = new OnvifCamera();
                onvif.connect(stream.getIpAddr(), stream.getUsername(), stream.getPassword());
                String rtspURL = onvif.getRTSPStreamURI();
                if (rtspURL != "no") {
                    String authparam = stream.getUsername() + ":" + stream.getPassword() + "@";
                    String rtspURLWithAuth = "rtsp://" + authparam + rtspURL.substring("rtsp://".length());
                    System.out.println("rtsp url with auth:" + rtspURLWithAuth);
                    stream.setStreamUrl(rtspURLWithAuth);
                    Date currentDate = new Date();
                    long unixTime = currentDate.getTime();
                    stream.setDate(Long.valueOf(unixTime));
                    stream.setStatus("created");
                    String id = this.getStore().save(stream);
                    if (id.length() > 0) {
                        Broadcast newCam = this.getStore().get(stream.getStreamId());
                        this.getInstance().startStreaming(newCam);
                    }
                    onvif.disconnect();
                    result = true;
                    message = "IP Camera successfully added";
                }
            } else if (stream.getType().equals("streamSource")) {
                Date currentDate = new Date();
                long unixTime = currentDate.getTime();
                stream.setDate(Long.valueOf(unixTime));
                stream.setStatus("created");
                String id = this.getStore().save(stream);
                if (id.length() > 0) {
                    Broadcast newSource = this.getStore().get(stream.getStreamId());
                    this.getInstance().startStreaming(newSource);
                }
                result = true;
                message = "StreamSource successfully added";
            } else {
                message = "No stream added";
            }
        }
        return new Result(result, message);
    }

    @GET
    @Path(value="/deleteCamera")
    @Produces(value={"application/json"})
    public Result deleteCamera(@QueryParam(value="ipAddr") String ipAddr) {
        boolean result = false;
        logger.warn("inside of rest service" + ipAddr);
        Broadcast cam = this.getStore().getCamera(ipAddr);
        if (cam != null) {
            this.getInstance().stopStreaming(cam);
            result = this.getStore().deleteStream(ipAddr);
        }
        return new Result(result);
    }

    @GET
    @Path(value="/getUserVodList/{folderPath}")
    @Produces(value={"application/json"})
    public boolean getUserVodList(@PathParam(value="folderPath") String folderPath) {
        boolean result = false;
        String appScopeName = ScopeUtils.findApplication((IScope)this.getScope()).getName();
        File directory = new File(String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, folderPath));
        if (!directory.exists()) {
            try {
                directory.mkdir();
            }
            catch (SecurityException se) {
                se.printStackTrace();
            }
        }
        result = this.getStore().fetchUserVodList(directory);
        return result;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/updateCamInfo")
    @Produces(value={"application/json"})
    public Result updateCamInfo(Broadcast camera) {
        boolean result = false;
        OnvifCamera onvif = null;
        logger.warn("inside of rest service");
        logger.warn(camera.getStatus());
        if (camera.getStatus() != null) {
            if (camera.getStatus().equals("broadcasting")) {
                this.getInstance().stopStreaming(camera);
                result = this.getStore().editCameraInfo(camera);
                logger.warn("after edit:" + result);
                onvif = new OnvifCamera();
                onvif.connect(camera.getIpAddr(), camera.getUsername(), camera.getPassword());
                String rtspURL = onvif.getRTSPStreamURI();
                logger.warn("camera starting point inside camera edit:  " + camera.getStreamId());
                result = rtspURL != "no";
                if (result) {
                    String authparam = camera.getUsername() + ":" + camera.getPassword() + "@";
                    String rtspURLWithAuth = "rtsp://" + authparam + rtspURL.substring("rtsp://".length());
                    System.out.println("rtsp url with auth:" + rtspURLWithAuth);
                    camera.setStreamUrl(rtspURLWithAuth);
                    Broadcast newCam = this.getStore().get(camera.getStreamId());
                    this.getInstance().startStreaming(newCam);
                }
            } else {
                logger.warn("camera couldnot started");
                camera.setStatus("finished");
                result = this.getStore().editCameraInfo(camera);
            }
        } else {
            result = this.getStore().editCameraInfo(camera);
        }
        logger.warn("final result:" + result);
        if (onvif != null) {
            onvif.disconnect();
        }
        return new Result(result);
    }

    @GET
    @Path(value="/searchOnvifDevices")
    @Produces(value={"application/json"})
    public String[] searchOnvifDevices() {
        String localIP = null;
        String[] list = null;
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface i = interfaces.nextElement();
                Enumeration<InetAddress> addresses = i.getInetAddresses();
                while (addresses.hasMoreElements() && (localIP == null || localIP.isEmpty())) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || !address.isSiteLocalAddress()) continue;
                    localIP = address.getHostAddress();
                }
            }
            logger.warn("IP Address:  " + localIP);
        }
        if (localIP != null) {
            String[] ipAddrParts = localIP.split("\\.");
            String ipAd = ipAddrParts[0] + "." + ipAddrParts[1] + "." + ipAddrParts[2] + ".";
            System.out.println(ipAd);
            logger.warn("inside of auto discovery");
            ArrayList<String> addressList = new ArrayList<String>();
            for (int i = 2; i < 255; ++i) {
                addressList.add(ipAd + i);
            }
            List<URL> onvifDevices = OnvifDiscovery.discoverOnvifDevices(true, addressList);
            list = new String[onvifDevices.size()];
            if (onvifDevices.size() > 0) {
                for (int i = 0; i < onvifDevices.size(); ++i) {
                    logger.warn("inside of for loop" + i);
                    logger.warn("inside of for loop" + onvifDevices.get(i).toString());
                    list[i] = StringUtils.substringBetween((String)onvifDevices.get(i).toString(), (String)"http://", (String)"/");
                }
            }
        } else {
            logger.warn("IP Address is not found");
        }
        return list;
    }

    @GET
    @Path(value="/get")
    @Produces(value={"application/json"})
    public Broadcast getCamera(@QueryParam(value="ipAddr") String ipAddr) {
        Broadcast camera = this.getStore().getCamera(ipAddr);
        if (camera == null) {
            camera = new Broadcast("null", "null", "null", "null", "null", "null");
        }
        return camera;
    }

    @GET
    @Path(value="/moveUp")
    @Produces(value={"application/json"})
    public Result moveUp(@QueryParam(value="id") String id) {
        boolean result = false;
        OnvifCamera camera = this.getInstance().getOnvifCamera(id);
        if (camera != null) {
            camera.MoveUp();
            result = true;
        }
        return new Result(result);
    }

    @GET
    @Path(value="/moveDown")
    @Produces(value={"application/json"})
    public Result moveDown(@QueryParam(value="id") String id) {
        boolean result = false;
        OnvifCamera camera = this.getInstance().getOnvifCamera(id);
        if (camera != null) {
            camera.MoveDown();
            result = true;
        }
        return new Result(result);
    }

    @GET
    @Path(value="/moveLeft")
    @Produces(value={"application/json"})
    public Result moveLeft(@QueryParam(value="id") String id) {
        boolean result = false;
        OnvifCamera camera = this.getInstance().getOnvifCamera(id);
        if (camera != null) {
            camera.MoveLeft();
            result = true;
        }
        return new Result(result);
    }

    @GET
    @Path(value="/moveRight")
    @Produces(value={"application/json"})
    public Result moveRight(@QueryParam(value="id") String id) {
        boolean result = false;
        OnvifCamera camera = this.getInstance().getOnvifCamera(id);
        if (camera != null) {
            camera.MoveRight();
            result = true;
        }
        return new Result(result);
    }

    @Nullable
    private ApplicationContext getAppContext() {
        if (this.servletContext != null) {
            this.appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        return this.appCtx;
    }

    public AntMediaApplicationAdapter getInstance() {
        if (this.appInstance == null) {
            this.appInstance = (AntMediaApplicationAdapter)this.getAppContext().getBean("web.handler");
        }
        return this.appInstance;
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = this.getInstance().getScope();
        }
        return this.scope;
    }

    public MapDBStore getStore() {
        if (this.dbStore == null) {
            WebApplicationContext ctxt = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
            this.dbStore = (MapDBStore)ctxt.getBean("db.datastore");
        }
        return this.dbStore;
    }

    public void setCameraStore(MapDBStore cameraStore) {
        this.dbStore = cameraStore;
    }
}

