/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.social.endpoint;

import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointChannel;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VideoServiceEndpoint {
    public static final Long THREE_DAYS_IN_MS = 259200000L;
    public static final String LIVE_STREAMING_NOT_ENABLED = "LIVE_STREAMING_NOT_ENABLED";
    public static final String AUTHENTICATION_TIMEOUT = "AUTHENTICATION_TIMEOUT";
    protected static Logger logger = LoggerFactory.getLogger(VideoServiceEndpoint.class);
    protected String clientId;
    protected String clientSecret;
    protected IDataStore dataStore;
    private SocialEndpointCredentials credentials;
    protected DeviceAuthParameters authParameters;
    private String error;

    public VideoServiceEndpoint(String clientId, String clientSecret, IDataStore dataStore, SocialEndpointCredentials endpointCredentials) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.dataStore = dataStore;
        this.credentials = endpointCredentials;
        if (this.credentials != null) {
            String expireTimeSeconds = this.credentials.getExpireTimeInSeconds();
            String authtimeMilliSeconds = this.credentials.getAuthTimeInMilliseconds();
            long expireTime = 0L;
            long authTime = 0L;
            if (expireTimeSeconds != null) {
                expireTime = Long.valueOf(expireTimeSeconds);
            }
            if (authtimeMilliSeconds != null) {
                authTime = Long.valueOf(authtimeMilliSeconds);
            }
            try {
                this.init(this.credentials.getAccountName(), this.credentials.getAccessToken(), this.credentials.getRefreshToken(), expireTime, this.credentials.getTokenType(), authTime);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.init(null, null, null, 0L, null, 0L);
        }
    }

    public abstract void init(String var1, String var2, String var3, long var4, String var6, long var7);

    public void saveCredentials(String accountName, String accessToken, String refreshToken, String expireTimeInSeconds, String token_type, String accountId) throws Exception {
        SocialEndpointCredentials tmpCredentials = new SocialEndpointCredentials(accountName, this.getName(), String.valueOf(System.currentTimeMillis()), expireTimeInSeconds, token_type, accessToken, refreshToken);
        if (this.credentials != null) {
            tmpCredentials.setId(this.credentials.getId());
        }
        tmpCredentials.setAccountId(accountId);
        SocialEndpointCredentials addedCredential = this.dataStore.addSocialEndpointCredentials(tmpCredentials);
        if (addedCredential == null) {
            throw new Exception("Social endpoint credential cannot be added for account name: " + accountName + " and service name " + this.getName());
        }
        this.setCredentials(addedCredential);
    }

    public void resetCredentials() {
        boolean removeSocialEndpointCredentials = this.dataStore.removeSocialEndpointCredentials(this.credentials.getId());
        if (!removeSocialEndpointCredentials) {
            logger.warn("Social endpoint is not deleted having id: " + this.credentials.getId() + " and service name: " + this.getName());
        }
        this.credentials = null;
    }

    public abstract String getName();

    public abstract DeviceAuthParameters askDeviceAuthParameters() throws Exception;

    public abstract boolean askIfDeviceAuthenticated() throws Exception;

    public abstract boolean isAuthenticated();

    public abstract Endpoint createBroadcast(String var1, String var2, boolean var3, boolean var4, int var5, boolean var6) throws Exception;

    public abstract void publishBroadcast(Endpoint var1) throws Exception;

    public abstract void stopBroadcast(Endpoint var1) throws Exception;

    public abstract String getBroadcast(Endpoint var1) throws Exception;

    protected String getClientId() {
        return this.clientId;
    }

    protected void setClientId(String clientId) {
        this.clientId = clientId;
    }

    protected String getClientSecret() {
        return this.clientSecret;
    }

    protected void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public boolean isInitialized() {
        return this.clientId != null && this.clientSecret != null && this.clientId.length() > 0 && this.clientSecret.length() > 0;
    }

    public SocialEndpointChannel getChannel() {
        return null;
    }

    public List<SocialEndpointChannel> getChannelList() {
        return null;
    }

    public boolean setActiveChannel(String type, String id) {
        return false;
    }

    public SocialEndpointCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(SocialEndpointCredentials credentials) {
        this.credentials = credentials;
    }

    public DeviceAuthParameters getAuthParameters() {
        return this.authParameters;
    }

    public void setAuthParameters(DeviceAuthParameters authParameters) {
        this.authParameters = authParameters;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public static class DeviceAuthParameters {
        public String device_code;
        public String user_code;
        public String verification_url;
        public int expires_in;
        public int interval;
    }
}

