/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.streamsource;

import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.streamsource.StreamFetcher;
import java.util.ArrayList;
import java.util.List;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamSources {
    protected static Logger logger = LoggerFactory.getLogger(StreamSources.class);
    public static final String BROADCAST_STATUS_FINISHED = "finished";
    private int streamCheckerCount = 0;
    private List<StreamFetcher> schedulerList = new ArrayList<StreamFetcher>();
    private int streamCheckerInterval = 10000;
    private ISchedulingService schedulingService;

    public StreamSources(ISchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    public int getStreamCheckerInterval() {
        return this.streamCheckerInterval;
    }

    public void setStreamCheckerInterval(int streamCheckerInterval) {
        this.streamCheckerInterval = streamCheckerInterval;
    }

    public void startStreaming(Broadcast broadcast) {
        StreamFetcher streamScheduler = new StreamFetcher(broadcast);
        streamScheduler.startStream();
        this.schedulerList.add(streamScheduler);
    }

    public List<StreamFetcher> getCamSchedulerList() {
        return this.schedulerList;
    }

    public void stopStreaming(Broadcast stream) {
        logger.warn("inside of stopStreaming");
        for (StreamFetcher streamScheduler : this.schedulerList) {
            if (!streamScheduler.getStream().getStreamId().equals(stream.getStreamId())) continue;
            streamScheduler.stopStream();
            this.schedulerList.remove(streamScheduler);
            break;
        }
    }

    public void startStreams(List<Broadcast> streams) {
        for (int i = 0; i < streams.size(); ++i) {
            this.startStreaming(streams.get(i));
        }
        this.schedulingService.addScheduledJobAfterDelay(this.streamCheckerInterval, new IScheduledJob(){

            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                block5: {
                    if (StreamSources.this.schedulerList.size() <= 0) break block5;
                    StreamSources.this.streamCheckerCount++;
                    logger.warn("checkerCount is  :" + StreamSources.this.streamCheckerCount);
                    if (StreamSources.this.streamCheckerCount % 180 == 0) {
                        for (StreamFetcher streamScheduler : StreamSources.this.schedulerList) {
                            if (streamScheduler.isRunning()) {
                                streamScheduler.stopStream();
                            }
                            streamScheduler.startStream();
                        }
                    } else {
                        for (StreamFetcher streamScheduler : StreamSources.this.schedulerList) {
                            if (streamScheduler.isRunning()) continue;
                            streamScheduler.getStream().setStatus(StreamSources.BROADCAST_STATUS_FINISHED);
                            streamScheduler.startStream();
                        }
                    }
                }
            }
        }, 5000);
    }
}

