/*
 * Decompiled with CFR 0.152.
 */
package com.antstreaming.rtsp.protocol;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTSPTransport {
    private static Logger log = LoggerFactory.getLogger(RTSPTransport.class);
    TransportProtocol transportProtocol;
    Profile profile;
    LowerTransport lowerTransport;
    DeliveryType deliveryType;
    String destination = null;
    String interleaved = null;
    int layers = 0;
    boolean append = false;
    int ttl = 0;
    int[] port = new int[2];
    int[] client_port = new int[2];
    int[] server_port = new int[2];
    String ssrc;
    String mode;
    String source;

    public RTSPTransport(String transport) {
        this.transportProtocol = TransportProtocol.None;
        this.profile = Profile.None;
        this.lowerTransport = LowerTransport.None;
        this.deliveryType = DeliveryType.None;
        this.port[0] = 0;
        this.port[1] = 0;
        this.client_port[0] = 0;
        this.client_port[1] = 0;
        this.server_port[0] = 0;
        this.server_port[1] = 0;
        this.ssrc = null;
        this.mode = null;
        this.source = null;
        this.parseTransport(transport);
        if (transport.compareToIgnoreCase(this.toString()) != 0) {
            log.warn("Transport header incorrectly parsed.");
        }
    }

    private void parseTransport(String transport) {
        for (String tok : transport.split(";")) {
            if (tok.startsWith("RTP") || tok.startsWith("RDT")) {
                String[] tpl = tok.split("/");
                this.transportProtocol = TransportProtocol.valueOf(tpl[0]);
                if (tpl.length > 1) {
                    this.profile = Profile.valueOf(tpl[1]);
                }
                if (tpl.length <= 2) continue;
                this.lowerTransport = LowerTransport.valueOf(tpl[2]);
                continue;
            }
            if (tok.compareToIgnoreCase("unicast") == 0) {
                this.deliveryType = DeliveryType.unicast;
                continue;
            }
            if (tok.compareToIgnoreCase("multicast") == 0) {
                this.deliveryType = DeliveryType.multicast;
                continue;
            }
            if (tok.startsWith("destination")) {
                this.setDestination(RTSPTransport._getStrValue(tok));
                continue;
            }
            if (tok.startsWith("interleaved")) {
                this.setInterleaved(RTSPTransport._getStrValue(tok));
                continue;
            }
            if (tok.startsWith("append")) {
                this.setAppend(true);
                continue;
            }
            if (tok.startsWith("layers")) {
                this.setLayers(Integer.valueOf(RTSPTransport._getStrValue(tok)));
                continue;
            }
            if (tok.startsWith("ttl")) {
                this.setTTL(Integer.valueOf(RTSPTransport._getStrValue(tok)));
                continue;
            }
            if (tok.startsWith("port")) {
                this.setPort(RTSPTransport._getPairValue(tok));
                continue;
            }
            if (tok.startsWith("client_port")) {
                this.setClientPort(RTSPTransport._getPairValue(tok));
                continue;
            }
            if (tok.startsWith("server_port")) {
                this.setServerPort(RTSPTransport._getPairValue(tok));
                continue;
            }
            if (tok.startsWith("ssrc")) {
                this.setSSRC(RTSPTransport._getStrValue(tok));
                continue;
            }
            if (tok.startsWith("mode")) {
                this.setMode(RTSPTransport._getStrValue(tok));
                continue;
            }
            if (!tok.startsWith("source")) continue;
            this.setSource(RTSPTransport._getStrValue(tok));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.transportProtocol);
        if (this.profile != Profile.None) {
            sb.append("/").append((Object)this.profile);
            if (this.lowerTransport != LowerTransport.None) {
                sb.append("/").append((Object)this.lowerTransport);
            }
        }
        if (this.deliveryType != DeliveryType.None) {
            sb.append(";").append((Object)this.deliveryType);
        }
        if (this.destination != null) {
            sb.append(";destination=").append(this.destination);
        }
        if (this.interleaved != null) {
            sb.append(";interleaved=").append(this.interleaved);
        }
        if (this.append) {
            sb.append(";append");
        }
        if (this.layers > 0) {
            sb.append(";layers=").append(this.layers);
        }
        if (this.ttl > 0) {
            sb.append(";ttl=").append(this.ttl);
        }
        if (this.port[0] > 0) {
            sb.append(";port=").append(this.port[0]).append("-").append(this.port[1]);
        }
        if (this.client_port[0] > 0) {
            sb.append(";client_port=").append(this.client_port[0]).append("-").append(this.client_port[1]);
        }
        if (this.server_port[0] > 0) {
            sb.append(";server_port=").append(this.server_port[0]).append("-").append(this.server_port[1]);
        }
        if (this.ssrc != null) {
            sb.append(";ssrc=").append(this.ssrc);
        }
        if (this.source != null) {
            sb.append(";source=").append(this.source);
        }
        if (this.mode != null) {
            sb.append(";mode=").append(this.mode);
        }
        return sb.toString();
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public int[] getClientPort() {
        return this.client_port;
    }

    public void setClientPort(int[] client_port) {
        this.client_port = client_port;
    }

    public DeliveryType getDeliveryType() {
        return this.deliveryType;
    }

    public void setDeliveryType(DeliveryType deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getInterleaved() {
        return this.interleaved;
    }

    public void setInterleaved(String interleaved) {
        this.interleaved = interleaved;
    }

    public int getLayers() {
        return this.layers;
    }

    public void setLayers(int layers) {
        this.layers = layers;
    }

    public LowerTransport getLowerTransport() {
        return this.lowerTransport;
    }

    public void setLowerTransport(LowerTransport lowerTransport) {
        this.lowerTransport = lowerTransport;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public int[] getPort() {
        return this.port;
    }

    public void setPort(int[] port) {
        this.port = port;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public int[] getServerPort() {
        return this.server_port;
    }

    public void setServerPort(int[] server_port) {
        this.server_port = server_port;
    }

    public String getSSRC() {
        return this.ssrc;
    }

    public void setSSRC(String ssrc) {
        this.ssrc = ssrc;
    }

    public void setSSRC(long ssrc) {
        this.ssrc = Long.toHexString(ssrc & 0xFFFFFFFFL).toUpperCase();
    }

    public TransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    public void setTransportProtocol(TransportProtocol transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void setTTL(int ttl) {
        this.ttl = ttl;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    private static String _getStrValue(String str) {
        String[] list = str.split("=");
        if (list.length != 2) {
            return null;
        }
        return list[1];
    }

    private static int[] _getPairValue(String str) {
        int[] pair = new int[]{0, 0};
        String[] list = str.split("=");
        if (list.length != 2) {
            return pair;
        }
        try {
            pair[0] = Integer.parseInt(list[1].split("-")[0]);
            pair[1] = Integer.parseInt(list[1].split("-")[1]);
        }
        catch (Exception e) {
            return pair;
        }
        return pair;
    }

    public static enum DeliveryType {
        None,
        unicast,
        multicast;

    }

    public static enum LowerTransport {
        None,
        TCP,
        UDP;

    }

    public static enum Profile {
        None,
        AVP;

    }

    public static enum TransportProtocol {
        None,
        RTP,
        RDT,
        RAW;

    }
}

