/*
 * Decompiled with CFR 0.152.
 */
package com.antstreaming.rtsp.protocol;

import com.antstreaming.rtsp.protocol.RtspCode;
import com.antstreaming.rtsp.protocol.RtspMessage;
import com.antstreaming.rtsp.protocol.RtspRequest;
import com.antstreaming.rtsp.protocol.RtspResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtspDecoder
extends CumulativeProtocolDecoder {
    private static Logger logger = LoggerFactory.getLogger(RtspDecoder.class);
    private static final Pattern rtspRequestPattern = Pattern.compile("([A-Z_]+) +([^ ]+) +RTSP/1.0");
    private static final Pattern rtspResponsePattern = Pattern.compile("RTSP/1.0 ([0-9]+) .+");
    private static final Pattern rtspHeaderPattern = Pattern.compile("([a-zA-Z\\-\\_]+[0-9]?):\\s?(.*)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        in.mark();
        BufferedReader reader = null;
        StringBuffer originMsg = new StringBuffer();
        try {
            reader = new BufferedReader(new InputStreamReader(in.asInputStream(), "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException", (Throwable)e);
        }
        ReadState state = (ReadState)((Object)session.getAttribute((Object)"state"));
        if (state == null) {
            state = ReadState.Command;
        }
        RtspMessage rtspMessage = (RtspMessage)session.getAttribute((Object)"rtspMessage");
        try {
            String line;
            while ((state == ReadState.Command || state == ReadState.Header) && (line = reader.readLine()) != null) {
                if (line.length() == 0) {
                    originMsg.append("\r\n");
                    if (null == rtspMessage) continue;
                    state = ReadState.Body;
                    rtspMessage.saveOriginRequest("\r\n");
                    break;
                }
                switch (state) {
                    case Command: {
                        Matcher m;
                        if (line.startsWith("RTSP")) {
                            m = rtspResponsePattern.matcher(line);
                            if (!m.matches()) {
                                session.removeAttribute((Object)"state");
                                session.removeAttribute((Object)"rtspMessage");
                                throw new ProtocolDecoderException("Malformed response line: " + line);
                            }
                            RtspCode code = RtspCode.fromString(m.group(1));
                            rtspMessage = new RtspResponse();
                            ((RtspResponse)rtspMessage).setCode(code);
                            RtspRequest.Verb verb = (RtspRequest.Verb)((Object)session.getAttribute((Object)"lastRequestVerb"));
                            ((RtspResponse)rtspMessage).setRequestVerb(verb);
                        } else {
                            m = rtspRequestPattern.matcher(line);
                            if (!m.matches()) {
                                session.removeAttribute((Object)"state");
                                session.removeAttribute((Object)"rtspMessage");
                                throw new ProtocolDecoderException("Malformed request line: " + line);
                            }
                            String verb = m.group(1);
                            String strUrl = m.group(2);
                            String url = null;
                            if (!strUrl.equalsIgnoreCase("*")) {
                                url = new String(strUrl);
                            }
                            rtspMessage = new RtspRequest();
                            ((RtspRequest)rtspMessage).setVerb(verb);
                            if (((RtspRequest)rtspMessage).getVerb() == RtspRequest.Verb.None) {
                                session.removeAttribute((Object)"state");
                                session.removeAttribute((Object)"rtspMessage");
                                logger.error("Invalid method: " + verb);
                                throw new ProtocolDecoderException("Invalid method: " + verb);
                            }
                            ((RtspRequest)rtspMessage).setUrl(url);
                        }
                        rtspMessage.saveOriginRequest(originMsg.toString() + line + "\r\n");
                        state = ReadState.Header;
                        break;
                    }
                    case Header: {
                        Matcher m = rtspHeaderPattern.matcher(line);
                        if (!m.matches()) {
                            session.removeAttribute((Object)"state");
                            session.removeAttribute((Object)"rtspMessage");
                            throw new ProtocolDecoderException("RTSP header not valid line:" + line);
                        }
                        rtspMessage.setHeader(m.group(1), m.group(2));
                        rtspMessage.saveOriginRequest(line + "\r\n");
                        break;
                    }
                }
            }
            if (state == ReadState.Body) {
                int contentLength = Integer.parseInt(rtspMessage.getHeader("Content-Length", "0"));
                if (contentLength == 0) {
                    state = ReadState.Dispatch;
                } else {
                    int bytesToRead = contentLength - rtspMessage.getBufferSize();
                    CharBuffer bufferContent = CharBuffer.allocate(bytesToRead);
                    reader.read(bufferContent);
                    bufferContent.flip();
                    rtspMessage.appendToBuffer(bufferContent);
                    if (rtspMessage.getBufferSize() >= contentLength) {
                        state = ReadState.Dispatch;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        if (state == ReadState.Dispatch) {
            session.removeAttribute((Object)"state");
            session.removeAttribute((Object)"rtspMessage");
            out.write((Object)rtspMessage);
            return true;
        }
        session.setAttribute((Object)"state", (Object)state);
        session.setAttribute((Object)"rtspMessage", (Object)rtspMessage);
        return false;
    }

    public static enum ReadState {
        Failed,
        Sync,
        Ready,
        Packet,
        Command,
        Header,
        Body,
        Dispatch;

    }
}

