/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.streamsource;

import io.antmedia.datastore.db.types.Broadcast;
import org.bytedeco.javacpp.avcodec;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFetcher {
    protected static Logger logger = LoggerFactory.getLogger(StreamFetcher.class);
    private Broadcast stream;
    private WorkerThread thread;
    private avcodec.AVPacket pkt = new avcodec.AVPacket();
    private long[] lastDTS;
    private int timeout;
    public boolean exceptionInThread = false;
    private long lastPacketReceivedTime = 0L;
    private static final int PACKET_RECEIVED_INTERVAL_TIMEOUT = 3000;

    public StreamFetcher(Broadcast stream) {
        this.stream = stream;
    }

    public StreamFetcher() {
    }

    public boolean prepareInput(avformat.AVFormatContext inputFormatContext) {
        this.setConnectionTimeout(4000);
        if (inputFormatContext == null) {
            logger.info("cannot allocate input context");
            return false;
        }
        if (this.stream == null || this.stream.getStreamUrl() == null) {
            logger.info("stream is null");
            return false;
        }
        avutil.AVDictionary optionsDictionary = new avutil.AVDictionary();
        avutil.av_dict_set((avutil.AVDictionary)optionsDictionary, (String)"rtsp_transport", (String)"tcp", (int)0);
        String timeout = String.valueOf(this.timeout);
        avutil.av_dict_set((avutil.AVDictionary)optionsDictionary, (String)"stimeout", (String)timeout, (int)0);
        logger.info("stream url:  " + this.stream.getStreamUrl());
        int ret = avformat.avformat_open_input((avformat.AVFormatContext)inputFormatContext, (String)this.stream.getStreamUrl(), null, (avutil.AVDictionary)optionsDictionary);
        if (ret < 0) {
            byte[] data = new byte[1024];
            avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
            logger.info("cannot open input context with error: " + new String(data, 0, data.length));
            return false;
        }
        avutil.av_dict_free((avutil.AVDictionary)optionsDictionary);
        ret = avformat.avformat_find_stream_info((avformat.AVFormatContext)inputFormatContext, (avutil.AVDictionary)null);
        if (ret < 0) {
            logger.info("Could not find stream information\n");
            return false;
        }
        this.lastDTS = new long[inputFormatContext.nb_streams()];
        for (int i = 0; i < this.lastDTS.length; ++i) {
            this.lastDTS[i] = -1L;
        }
        return true;
    }

    public boolean prepare(avformat.AVFormatContext inputFormatContext, avformat.AVFormatContext outputRTMPFormatContext) {
        if (this.prepareInput(inputFormatContext)) {
            return this.prepareOutput(inputFormatContext, outputRTMPFormatContext);
        }
        return false;
    }

    private boolean prepareOutput(avformat.AVFormatContext inputFormatContext, avformat.AVFormatContext outputRTMPFormatContext) {
        int ret = avformat.avformat_alloc_output_context2((avformat.AVFormatContext)outputRTMPFormatContext, null, (String)"flv", null);
        for (int i = 0; i < inputFormatContext.nb_streams(); ++i) {
            avformat.AVStream in_stream = inputFormatContext.streams(i);
            avformat.AVStream out_stream = avformat.avformat_new_stream((avformat.AVFormatContext)outputRTMPFormatContext, (avcodec.AVCodec)in_stream.codec().codec());
            ret = avcodec.avcodec_parameters_copy((avcodec.AVCodecParameters)out_stream.codecpar(), (avcodec.AVCodecParameters)in_stream.codecpar());
            if (ret < 0) {
                logger.warn("Cannot get codec parameters\n");
                return false;
            }
            out_stream.codec().codec_tag(0);
        }
        if ((outputRTMPFormatContext.oformat().flags() & 0x40) != 0) {
            outputRTMPFormatContext.oformat().flags(outputRTMPFormatContext.oformat().flags() | 0x400000);
        }
        if ((outputRTMPFormatContext.flags() & 1) == 0) {
            avformat.AVIOContext pb = new avformat.AVIOContext(null);
            String urlStr = "rtmp://localhost/LiveApp/" + this.stream.getStreamId();
            ret = avformat.avio_open((avformat.AVIOContext)pb, (String)urlStr, (int)2);
            if (ret < 0) {
                byte[] data = new byte[1024];
                avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                logger.info("Cannot open url: " + urlStr + " error is " + new String(data, 0, data.length));
                return false;
            }
            outputRTMPFormatContext.pb(pb);
            ret = avformat.avformat_write_header((avformat.AVFormatContext)outputRTMPFormatContext, (avutil.AVDictionary)null);
            if (ret < 0) {
                logger.info("Cannot write header to rtmp\n");
                return false;
            }
        }
        return true;
    }

    public void startStream() {
        this.exceptionInThread = false;
        this.thread = new WorkerThread();
        this.thread.start();
    }

    public boolean isStreamAlive() {
        return System.currentTimeMillis() - this.lastPacketReceivedTime < 3000L;
    }

    public boolean isStopped() {
        return this.thread.isInterrupted();
    }

    public void stopStream() {
        logger.warn("stop stream called");
        this.thread.setStopRequestReceived();
    }

    public boolean isStopRequestReceived() {
        return this.thread.isStopRequestReceived();
    }

    public Broadcast getStream() {
        return this.stream;
    }

    public void restart() {
        this.stopStream();
        new Thread(){

            @Override
            public void run() {
                try {
                    while (StreamFetcher.this.isStreamAlive()) {
                        logger.warn("thread isRunning");
                        Thread.sleep(100L);
                    }
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                StreamFetcher.this.startStream();
            }
        }.start();
    }

    public void setConnectionTimeout(int timeout) {
        this.timeout = timeout * 1000;
    }

    public boolean isExceptionInThread() {
        return this.exceptionInThread;
    }

    public class WorkerThread
    extends Thread {
        private volatile boolean stopRequestReceived = false;

        @Override
        public void run() {
            avformat.AVFormatContext inputFormatContext = new avformat.AVFormatContext(null);
            avformat.AVFormatContext outputRTMPFormatContext = new avformat.AVFormatContext(null);
            logger.info("before prepare");
            try {
                block13: {
                    if (!StreamFetcher.this.prepare(inputFormatContext, outputRTMPFormatContext)) {
                        if (inputFormatContext != null) {
                            avformat.avformat_close_input((avformat.AVFormatContext)inputFormatContext);
                        }
                        if (outputRTMPFormatContext != null && !outputRTMPFormatContext.isNull()) {
                            if (outputRTMPFormatContext.pb() != null) {
                                avformat.avio_closep((avformat.AVIOContext)outputRTMPFormatContext.pb());
                            }
                            avformat.avformat_free_context((avformat.AVFormatContext)outputRTMPFormatContext);
                        }
                        logger.warn("Prepare for " + StreamFetcher.this.stream.getName() + " returned false");
                        return;
                    }
                    while (true) {
                        int ret;
                        if ((ret = avformat.av_read_frame((avformat.AVFormatContext)inputFormatContext, (avcodec.AVPacket)StreamFetcher.this.pkt)) < 0) {
                            logger.info("cannot read frame from input context");
                            break block13;
                        }
                        StreamFetcher.this.lastPacketReceivedTime = System.currentTimeMillis();
                        int packetIndex = StreamFetcher.this.pkt.stream_index();
                        avformat.AVStream in_stream = inputFormatContext.streams(packetIndex);
                        avformat.AVStream out_stream = outputRTMPFormatContext.streams(packetIndex);
                        if (StreamFetcher.this.pkt.dts() < 0L) {
                            avcodec.av_packet_unref((avcodec.AVPacket)StreamFetcher.this.pkt);
                            continue;
                        }
                        if (StreamFetcher.this.lastDTS[packetIndex] >= StreamFetcher.this.pkt.dts()) {
                            StreamFetcher.this.pkt.dts(StreamFetcher.this.lastDTS[packetIndex] + 1L);
                        }
                        ((StreamFetcher)StreamFetcher.this).lastDTS[packetIndex] = StreamFetcher.this.pkt.dts();
                        if (StreamFetcher.this.pkt.dts() > StreamFetcher.this.pkt.pts()) {
                            StreamFetcher.this.pkt.pts(StreamFetcher.this.pkt.dts());
                        }
                        StreamFetcher.this.pkt.pts(avutil.av_rescale_q_rnd((long)StreamFetcher.this.pkt.pts(), (avutil.AVRational)in_stream.time_base(), (avutil.AVRational)out_stream.time_base(), (int)8197));
                        StreamFetcher.this.pkt.dts(avutil.av_rescale_q_rnd((long)StreamFetcher.this.pkt.dts(), (avutil.AVRational)in_stream.time_base(), (avutil.AVRational)out_stream.time_base(), (int)8197));
                        StreamFetcher.this.pkt.duration(avutil.av_rescale_q((long)StreamFetcher.this.pkt.duration(), (avutil.AVRational)in_stream.time_base(), (avutil.AVRational)out_stream.time_base()));
                        StreamFetcher.this.pkt.pos(-1L);
                        ret = avformat.av_interleaved_write_frame((avformat.AVFormatContext)outputRTMPFormatContext, (avcodec.AVPacket)StreamFetcher.this.pkt);
                        if (ret < 0) {
                            logger.info("cannot write frame to muxer");
                            break block13;
                        }
                        avcodec.av_packet_unref((avcodec.AVPacket)StreamFetcher.this.pkt);
                        if (this.stopRequestReceived) break;
                    }
                    logger.warn("breaking the loop");
                }
                avformat.avformat_close_input((avformat.AVFormatContext)inputFormatContext);
                inputFormatContext = null;
                avformat.av_write_trailer((avformat.AVFormatContext)outputRTMPFormatContext);
                if ((outputRTMPFormatContext.flags() & 1) == 0) {
                    logger.warn("before avio_closep(outputRTMPFormatContext.pb());");
                    avformat.avio_closep((avformat.AVIOContext)outputRTMPFormatContext.pb());
                    outputRTMPFormatContext.pb(null);
                }
                logger.warn("before avformat_free_context(outputRTMPFormatContext);");
                avformat.avformat_free_context((avformat.AVFormatContext)outputRTMPFormatContext);
                outputRTMPFormatContext = null;
            }
            catch (Exception e) {
                logger.info("---Exception in thread---");
                e.printStackTrace();
                StreamFetcher.this.exceptionInThread = true;
            }
        }

        public void setStopRequestReceived() {
            logger.warn("inside of setStopRequestReceived");
            this.stopRequestReceived = true;
        }

        public boolean isStopRequestReceived() {
            return this.stopRequestReceived;
        }
    }
}

