/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.streamsource;

import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.streamsource.StreamFetcher;
import java.util.ArrayList;
import java.util.List;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFetcherManager {
    protected static Logger logger = LoggerFactory.getLogger(StreamFetcherManager.class);
    private int streamCheckerCount = 0;
    private List<StreamFetcher> streamFetcherList = new ArrayList<StreamFetcher>();
    private int streamCheckerInterval = 10000;
    private ISchedulingService schedulingService;
    private IDataStore datastore;

    public StreamFetcherManager(ISchedulingService schedulingService, IDataStore datastore) {
        this.schedulingService = schedulingService;
        this.datastore = datastore;
    }

    public int getStreamCheckerInterval() {
        return this.streamCheckerInterval;
    }

    public void setStreamCheckerInterval(int streamCheckerInterval) {
        this.streamCheckerInterval = streamCheckerInterval;
    }

    public void startStreaming(Broadcast broadcast) {
        StreamFetcher streamScheduler = new StreamFetcher(broadcast);
        streamScheduler.startStream();
        this.streamFetcherList.add(streamScheduler);
    }

    public List<StreamFetcher> getCamSchedulerList() {
        return this.streamFetcherList;
    }

    public void stopStreaming(Broadcast stream) {
        logger.warn("inside of stopStreaming");
        for (StreamFetcher streamScheduler : this.streamFetcherList) {
            if (!streamScheduler.getStream().getStreamId().equals(stream.getStreamId())) continue;
            streamScheduler.stopStream();
            this.streamFetcherList.remove(streamScheduler);
            break;
        }
    }

    public void startStreams(List<Broadcast> streams) {
        for (int i = 0; i < streams.size(); ++i) {
            this.startStreaming(streams.get(i));
        }
        this.schedulingService.addScheduledJobAfterDelay(this.streamCheckerInterval, new IScheduledJob(){

            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                block6: {
                    if (StreamFetcherManager.this.streamFetcherList.size() <= 0) break block6;
                    StreamFetcherManager.this.streamCheckerCount++;
                    logger.warn("checkerCount is  :" + StreamFetcherManager.this.streamCheckerCount);
                    if (StreamFetcherManager.this.streamCheckerCount % 180 == 0) {
                        for (StreamFetcher streamScheduler : StreamFetcherManager.this.streamFetcherList) {
                            if (streamScheduler.isStreamAlive()) {
                                streamScheduler.stopStream();
                            }
                            streamScheduler.startStream();
                        }
                    } else {
                        for (StreamFetcher streamScheduler : StreamFetcherManager.this.streamFetcherList) {
                            if (streamScheduler.isStreamAlive()) continue;
                            String streamId = streamScheduler.getStream().getStreamId();
                            if (StreamFetcherManager.this.datastore != null && streamId != null) {
                                logger.info("Updating stream status to finished, updating status of stream {}", (Object)streamScheduler.getStream().getStreamId());
                                StreamFetcherManager.this.datastore.updateStatus(streamId, "finished");
                            }
                            streamScheduler.startStream();
                        }
                    }
                }
            }
        }, 5000);
    }

    public IDataStore getDatastore() {
        return this.datastore;
    }

    public void setDatastore(IDataStore datastore) {
        this.datastore = datastore;
    }
}

