/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmps;

import java.io.File;
import java.io.NotActiveException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.KeyStoreFactory;
import org.apache.mina.filter.ssl.SslContextFactory;
import org.apache.mina.filter.ssl.SslFilter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.red5.server.net.rtmp.InboundHandshake;
import org.red5.server.net.rtmp.RTMPHandler;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmp.RTMPMinaIoHandler;
import org.red5.server.net.rtmps.RTMPSIoFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPSMinaIoHandler
extends RTMPMinaIoHandler {
    private static Logger log = LoggerFactory.getLogger(RTMPSMinaIoHandler.class);
    private String keystorePassword;
    private String truststorePassword;
    private String keystoreFile;
    private String truststoreFile;
    private String[] cipherSuites;
    private String[] protocols;
    private boolean useClientMode;
    private boolean needClientAuth;
    private boolean wantClientAuth;

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        log.debug("Session created: RTMPS");
        if (this.keystoreFile == null || this.truststoreFile == null) {
            throw new NotActiveException("Keystore or truststore are null");
        }
        SSLContext sslContext = null;
        try {
            log.debug("Keystore: {}", (Object)this.keystoreFile);
            File keyStore = new File(this.keystoreFile);
            log.trace("Keystore - read: {} path: {}", (Object)keyStore.canRead(), (Object)keyStore.getCanonicalPath());
            log.debug("Truststore: {}", (Object)this.truststoreFile);
            File trustStore = new File(this.truststoreFile);
            log.trace("Truststore - read: {} path: {}", (Object)trustStore.canRead(), (Object)trustStore.getCanonicalPath());
            if (keyStore.exists() && trustStore.exists()) {
                KeyStoreFactory keyStoreFactory = new KeyStoreFactory();
                keyStoreFactory.setDataFile(keyStore);
                keyStoreFactory.setPassword(this.keystorePassword);
                KeyStoreFactory trustStoreFactory = new KeyStoreFactory();
                trustStoreFactory.setDataFile(trustStore);
                trustStoreFactory.setPassword(this.truststorePassword);
                SslContextFactory sslContextFactory = new SslContextFactory();
                KeyStore ks = keyStoreFactory.newInstance();
                sslContextFactory.setKeyManagerFactoryKeyStore(ks);
                KeyStore ts = trustStoreFactory.newInstance();
                sslContextFactory.setTrustManagerFactoryKeyStore(ts);
                sslContextFactory.setKeyManagerFactoryKeyStorePassword(this.keystorePassword);
                sslContext = sslContextFactory.newInstance();
                log.debug("SSL provider is: {}", (Object)sslContext.getProvider());
                SSLParameters params = sslContext.getDefaultSSLParameters();
                if (log.isDebugEnabled()) {
                    String[] supportedProtocols;
                    log.debug("SSL context params - need client auth: {} want client auth: {} endpoint id algorithm: {}", new Object[]{params.getNeedClientAuth(), params.getWantClientAuth(), params.getEndpointIdentificationAlgorithm()});
                    for (String protocol : supportedProtocols = params.getProtocols()) {
                        log.debug("SSL context supported protocol: {}", (Object)protocol);
                    }
                }
            } else {
                log.warn("Keystore or Truststore file does not exist");
            }
        }
        catch (Exception ex) {
            log.error("Exception getting SSL context", (Throwable)ex);
        }
        SslFilter sslFilter = new SslFilter(sslContext);
        sslFilter.setUseClientMode(this.useClientMode);
        sslFilter.setNeedClientAuth(this.needClientAuth);
        sslFilter.setWantClientAuth(this.wantClientAuth);
        if (this.cipherSuites != null) {
            sslFilter.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.protocols != null) {
            if (log.isDebugEnabled()) {
                log.debug("Using these protocols: {}", (Object)Arrays.toString(this.protocols));
            }
            sslFilter.setEnabledProtocols(this.protocols);
        }
        IoFilterChain chain = session.getFilterChain();
        chain.addFirst("sslFilter", (IoFilter)sslFilter);
        session.setAttribute((Object)SslFilter.USE_NOTIFICATION, (Object)Boolean.TRUE);
        log.debug("isSslStarted: {}", (Object)sslFilter.isSslStarted(session));
        session.getFilterChain().addAfter("sslFilter", "rtmpsFilter", (IoFilter)new RTMPSIoFilter());
        RTMPMinaConnection conn = this.createRTMPMinaConnection();
        conn.setIoSession(session);
        conn.setHandler(this.handler);
        session.setAttribute((Object)"rtmp.sessionid", (Object)conn.getSessionId());
        InboundHandshake handshake = new InboundHandshake();
        handshake.setUnvalidatedConnectionAllowed(((RTMPHandler)this.handler).isUnvalidatedConnectionAllowed());
        session.setAttribute((Object)"rtmp.handshake", (Object)handshake);
    }

    public void setKeystorePassword(String password) {
        this.keystorePassword = password;
    }

    public void setTruststorePassword(String password) {
        this.truststorePassword = password;
    }

    public void setKeystoreFile(String path) {
        this.keystoreFile = path;
    }

    public void setTruststoreFile(String path) {
        this.truststoreFile = path;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String[] protocols) {
        this.protocols = protocols;
    }

    public void setUseClientMode(boolean useClientMode) {
        this.useClientMode = useClientMode;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (log.isTraceEnabled()) {
            Provider[] providers;
            for (Provider provider : providers = Security.getProviders()) {
                log.trace("Provider: {} = {}", (Object)provider.getName(), (Object)provider.getInfo());
            }
        }
    }
}

