/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.session;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.session.ISession;
import org.red5.server.session.Session;
import org.red5.server.util.PropertyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private static ConcurrentMap<String, ISession> sessions = new ConcurrentHashMap<String, ISession>();
    private static String destinationDirectory;
    private static Long maxLifetime;
    private static ISchedulingService schedulingService;
    public static final Random rnd;

    public void init() {
        if (schedulingService != null) {
            schedulingService.addScheduledJob(3600000, (IScheduledJob)new ReaperJob());
        } else {
            log.warn("Session reaper job was not scheduled");
        }
    }

    public static String getSessionId() {
        int part1 = rnd.nextInt(99999) + 1;
        long part2 = ThreadLocalRandom.current().nextLong();
        long part3 = System.currentTimeMillis();
        String sessionId = SessionManager.createHash(part1 + "-" + part2 + "-" + part3);
        log.debug("Session id created: {}", (Object)sessionId);
        return sessionId;
    }

    public static ISession createSession() {
        return SessionManager.createSession(SessionManager.getSessionId());
    }

    public static ISession createSession(String sessionId) {
        Session session = new Session(sessionId);
        session.setDestinationDirectory(destinationDirectory);
        sessions.put(sessionId, session);
        return session;
    }

    public static ISession getSession(String sessionId) {
        return (ISession)sessions.get(sessionId);
    }

    public static ISession removeSession(String sessionId) {
        return (ISession)sessions.remove(sessionId);
    }

    public String getDestinationDirectory() {
        return destinationDirectory;
    }

    public void setDestinationDirectory(String destinationDir) {
        log.debug("Setting session destination directory {}", (Object)destinationDir);
        destinationDirectory = destinationDir;
    }

    public void setMaxLifetime(String maxLifetime) {
        SessionManager.maxLifetime = StringUtils.isNumeric((CharSequence)maxLifetime) ? Long.valueOf(maxLifetime) : Long.valueOf(PropertyConverter.convertStringToTimeMillis((String)maxLifetime));
        log.debug("Max lifetime set to {} ms", (Object)SessionManager.maxLifetime);
    }

    public void setSchedulingService(ISchedulingService schedulingService) {
        SessionManager.schedulingService = schedulingService;
    }

    public static String createHash(String str) {
        return DigestUtils.md5Hex((byte[])str.getBytes());
    }

    static {
        rnd = new Random();
    }

    private static final class ReaperJob
    implements IScheduledJob {
        public ReaperJob() {
            log.debug("Creating job to remove stale sessions");
        }

        public void execute(ISchedulingService service) {
            log.debug("Reaper running...");
            if (sessions != null && !sessions.isEmpty()) {
                long now = System.currentTimeMillis();
                for (Map.Entry entry : sessions.entrySet()) {
                    ISession session = (ISession)entry.getValue();
                    long creationTime = session.getCreated();
                    if (now - creationTime <= maxLifetime) continue;
                    String key = session.getSessionId();
                    log.info("Reaper killing stale session: {}", (Object)key);
                    sessions.remove(key);
                    session.reset();
                    session = null;
                }
            }
        }
    }
}

