/*
 * Decompiled with CFR 0.152.
 */
package com.antstreaming.rtsp;

import com.antstreaming.rtsp.protocol.RtspCode;
import com.antstreaming.rtsp.protocol.RtspHeaderCode;
import com.antstreaming.rtsp.protocol.RtspResponse;
import com.antstreaming.rtsp.session.DateUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Date;
import org.apache.mina.core.session.IoSession;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.avcodec;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class PacketReceiverRunnable
implements Runnable {
    private avformat.AVFormatContext inputFormatCtx;
    private long[] lastDTS;
    private avformat.AVFormatContext outputRTMPFormatContext;
    private boolean closeRequest = false;
    private File sdpFile;
    private Logger logger = LoggerFactory.getLogger(PacketReceiverRunnable.class);
    private String url;
    private StringBuilder liveStreamSdpDef;
    private String announcedStreamName;
    private IoSession session;
    private String sessionKey;
    private String cseq;
    private ThreadPoolTaskScheduler mTaskScheduler;

    public PacketReceiverRunnable(ThreadPoolTaskScheduler mTaskScheduler, String cseq, String sessionKey, IoSession session, String announcedStreamName, StringBuilder liveStreamSdpDef, String url) {
        this.mTaskScheduler = mTaskScheduler;
        this.cseq = cseq;
        this.sessionKey = sessionKey;
        this.session = session;
        this.announcedStreamName = announcedStreamName;
        this.liveStreamSdpDef = liveStreamSdpDef;
        this.url = url;
    }

    public boolean prepare_input_context(ThreadPoolTaskScheduler mTaskScheduler, final String cseq, final String sessionKey, final IoSession session, String announcedStreamName, StringBuilder liveStreamSdpDef, String streamUrl) {
        try {
            this.sdpFile = new File(announcedStreamName + ".sdp");
            try (FileOutputStream fos = new FileOutputStream(this.sdpFile);){
                ((OutputStream)fos).write(liveStreamSdpDef.toString().getBytes());
            }
            this.inputFormatCtx = new avformat.AVFormatContext(null);
            avutil.AVDictionary options = new avutil.AVDictionary();
            int ret = avutil.av_dict_set((avutil.AVDictionary)options, (String)"protocol_whitelist", (String)"file,crypto,udp,rtp", (int)0);
            if (ret < 0) {
                this.logger.debug("cannot set protocol_whitelist");
                return false;
            }
            avformat.AVInputFormat sdpFormat = avformat.av_find_input_format((String)"sdp");
            if (avformat.avformat_open_input((avformat.AVFormatContext)this.inputFormatCtx, (String)this.sdpFile.getAbsolutePath(), (avformat.AVInputFormat)sdpFormat, (avutil.AVDictionary)options) != 0) {
                this.logger.debug("Could not open rtp for demuxing");
                return false;
            }
            mTaskScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    RtspResponse response = new RtspResponse();
                    response.setCode(RtspCode.OK);
                    response.setHeader(RtspHeaderCode.CSeq, cseq);
                    response.setHeader(RtspHeaderCode.Date, DateUtil.getGmtDate());
                    response.setHeader(RtspHeaderCode.Session, sessionKey);
                    session.write((Object)response);
                }
            }, new Date());
            if (avformat.avformat_find_stream_info((avformat.AVFormatContext)this.inputFormatCtx, (PointerPointer)null) < 0) {
                this.logger.debug("Could not get stream info");
                return false;
            }
            this.outputRTMPFormatContext = new avformat.AVFormatContext(null);
            ret = avformat.avformat_alloc_output_context2((avformat.AVFormatContext)this.outputRTMPFormatContext, null, (String)"flv", null);
            this.lastDTS = new long[this.inputFormatCtx.nb_streams()];
            for (int i = 0; i < this.inputFormatCtx.nb_streams(); ++i) {
                avformat.AVStream inStream = this.inputFormatCtx.streams(i);
                avformat.AVStream outStream = avformat.avformat_new_stream((avformat.AVFormatContext)this.outputRTMPFormatContext, (avcodec.AVCodec)inStream.codec().codec());
                ret = avcodec.avcodec_parameters_copy((avcodec.AVCodecParameters)outStream.codecpar(), (avcodec.AVCodecParameters)inStream.codecpar());
                if (ret < 0) {
                    this.logger.debug("Cannot get codec parameters\n");
                    return false;
                }
                outStream.codec().codec_tag(0);
                if ((this.outputRTMPFormatContext.oformat().flags() & 0x40) != 0) {
                    outStream.codec().flags(outStream.codec().flags() | 0x400000);
                }
                this.lastDTS[i] = -1L;
            }
            if ((this.outputRTMPFormatContext.flags() & 1) == 0) {
                avformat.AVIOContext pb = new avformat.AVIOContext(null);
                URI url = new URI(streamUrl);
                String urlStr = "rtmp://" + url.getHost() + "/" + url.getPath();
                ret = avformat.avio_open((avformat.AVIOContext)pb, (String)urlStr, (int)2);
                this.outputRTMPFormatContext.pb(pb);
                ret = avformat.avformat_write_header((avformat.AVFormatContext)this.outputRTMPFormatContext, (avutil.AVDictionary)null);
                if (ret < 0) {
                    this.logger.debug("Cannot write header to rtmp\n");
                    return false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void run() {
        block6: {
            if (!this.prepare_input_context(this.mTaskScheduler, this.cseq, this.sessionKey, this.session, this.announcedStreamName, this.liveStreamSdpDef, this.url)) {
                this.closeInternal();
                return;
            }
            while (true) {
                avcodec.AVPacket pkt;
                int ret;
                if ((ret = avformat.av_read_frame((avformat.AVFormatContext)this.inputFormatCtx, (avcodec.AVPacket)(pkt = new avcodec.AVPacket()))) < 0) {
                    this.closeInternal();
                    break block6;
                }
                int packetIndex = pkt.stream_index();
                avformat.AVStream in_stream = this.inputFormatCtx.streams(packetIndex);
                avformat.AVStream out_stream2 = this.outputRTMPFormatContext.streams(packetIndex);
                if (pkt.dts() < 0L) continue;
                if (this.lastDTS[packetIndex] >= pkt.dts()) {
                    this.logger.warn("dts timestamps are not in correct order last dts:" + this.lastDTS[packetIndex] + " current dts:" + pkt.dts() + " fixing problem by adding offset");
                    pkt.dts(this.lastDTS[packetIndex] + 1L);
                }
                this.lastDTS[packetIndex] = pkt.dts();
                if (pkt.dts() > pkt.pts()) {
                    pkt.pts(pkt.dts());
                }
                pkt.pts(avutil.av_rescale_q_rnd((long)pkt.pts(), (avutil.AVRational)in_stream.time_base(), (avutil.AVRational)out_stream2.time_base(), (int)8197));
                pkt.dts(avutil.av_rescale_q_rnd((long)pkt.dts(), (avutil.AVRational)in_stream.time_base(), (avutil.AVRational)out_stream2.time_base(), (int)8197));
                pkt.duration(avutil.av_rescale_q((long)pkt.duration(), (avutil.AVRational)in_stream.time_base(), (avutil.AVRational)out_stream2.time_base()));
                pkt.pos(-1L);
                ret = avformat.av_interleaved_write_frame((avformat.AVFormatContext)this.outputRTMPFormatContext, (avcodec.AVPacket)pkt);
                if (ret < 0) {
                    this.logger.debug("Error muxing rtmp packet\n");
                }
                avcodec.av_packet_unref((avcodec.AVPacket)pkt);
                if (this.closeRequest) break;
            }
            this.closeInternal();
        }
    }

    public void closeInternal() {
        this.logger.warn("closing rtmp format context");
        avformat.av_write_trailer((avformat.AVFormatContext)this.outputRTMPFormatContext);
        this.logger.warn("closing rtsp input format context");
        if (this.inputFormatCtx != null) {
            avformat.avformat_close_input((avformat.AVFormatContext)this.inputFormatCtx);
        }
        if (this.outputRTMPFormatContext != null && (this.outputRTMPFormatContext.oformat().flags() & 1) == 0) {
            this.logger.warn("closing rtmp format context pb");
            avformat.avio_closep((avformat.AVIOContext)this.outputRTMPFormatContext.pb());
        }
        avformat.avformat_free_context((avformat.AVFormatContext)this.outputRTMPFormatContext);
        this.logger.debug("deleting sdpfile");
        if (this.sdpFile != null && this.sdpFile.exists()) {
            this.sdpFile.delete();
            this.sdpFile = null;
        }
    }

    public synchronized void closeMuxer() {
        this.closeRequest = true;
    }
}

