/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.Vod;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDataStore
implements IDataStore {
    protected static Logger logger = LoggerFactory.getLogger(InMemoryDataStore.class);
    public LinkedHashMap<String, Broadcast> broadcastMap = new LinkedHashMap();
    public LinkedHashMap<String, Vod> vodMap = new LinkedHashMap();
    public LinkedHashMap<String, SocialEndpointCredentials> socialEndpointCredentialsMap = new LinkedHashMap();

    public InMemoryDataStore(String dbName) {
    }

    public String save(Broadcast broadcast) {
        String streamId = null;
        if (broadcast != null) {
            try {
                if (broadcast.getStreamId() == null) {
                    streamId = RandomStringUtils.randomNumeric((int)24);
                    broadcast.setStreamId(streamId);
                }
                streamId = broadcast.getStreamId();
                String rtmpURL = broadcast.getRtmpURL();
                if (rtmpURL != null) {
                    rtmpURL = rtmpURL + streamId;
                }
                broadcast.setRtmpURL(rtmpURL);
                this.broadcastMap.put(streamId, broadcast);
            }
            catch (Exception e) {
                e.printStackTrace();
                streamId = null;
            }
        }
        return streamId;
    }

    public Broadcast get(String id) {
        return this.broadcastMap.get(id);
    }

    public boolean updateName(String id, String name, String description) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setName(name);
            broadcast.setDescription(description);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean updateStatus(String id, String status) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setStatus(status);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean updateDuration(String id, long duration) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setDuration(Long.valueOf(duration));
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean updatePublish(String id, boolean publish) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setPublish(publish);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean addEndpoint(String id, Endpoint endpoint) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null && endpoint != null) {
            ArrayList<Endpoint> endPointList = broadcast.getEndPointList();
            if (endPointList == null) {
                endPointList = new ArrayList<Endpoint>();
            }
            endPointList.add(endpoint);
            broadcast.setEndPointList(endPointList);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean removeEndpoint(String id, Endpoint endpoint) {
        List endPointList;
        boolean result = false;
        Broadcast broadcast = this.broadcastMap.get(id);
        if (broadcast != null && endpoint != null && (endPointList = broadcast.getEndPointList()) != null) {
            Iterator iterator = endPointList.iterator();
            while (iterator.hasNext()) {
                Endpoint endpointItem = (Endpoint)iterator.next();
                if (!endpointItem.rtmpUrl.equals(endpoint.rtmpUrl)) continue;
                iterator.remove();
                result = true;
                break;
            }
        }
        return result;
    }

    public long getBroadcastCount() {
        return this.broadcastMap.size();
    }

    public boolean delete(String id) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            this.broadcastMap.remove(id);
            result = true;
        }
        return result;
    }

    public List<Broadcast> getBroadcastList(int offset, int size) {
        Collection<Broadcast> values = this.broadcastMap.values();
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        for (Broadcast broadcast : values) {
            if (t < offset) {
                ++t;
                continue;
            }
            list.add(broadcast);
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }

    public boolean editCameraInfo(Broadcast camera) {
        boolean result = false;
        try {
            logger.warn("inside of editCameraInfo");
            Broadcast oldCam = this.get(camera.getStreamId());
            oldCam.setName(camera.getName());
            oldCam.setUsername(camera.getUsername());
            oldCam.setPassword(camera.getPassword());
            oldCam.setIpAddr(camera.getIpAddr());
            this.broadcastMap.replace(oldCam.getStreamId(), oldCam);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean deleteStream(String id) {
        boolean result = false;
        try {
            if (this.broadcastMap.containsKey(id)) {
                logger.warn("inside of deleteStream");
                this.broadcastMap.remove(id);
                result = true;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public List<Broadcast> getExternalStreamsList() {
        Collection<Broadcast> values = this.broadcastMap.values();
        ArrayList<Broadcast> streamsList = new ArrayList<Broadcast>();
        for (Broadcast broadcast : values) {
            String type = broadcast.getType();
            if (!type.equals("ipCamera") && !type.equals("streamSource")) continue;
            streamsList.add(broadcast);
        }
        return streamsList;
    }

    public void close() {
    }

    public List<Broadcast> filterBroadcastList(int offset, int size, String type) {
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        Collection<Broadcast> values = this.broadcastMap.values();
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        for (Broadcast broadcast : values) {
            if (!broadcast.getType().equals("ipCamera")) continue;
            if (t < offset) {
                ++t;
                continue;
            }
            list.add(broadcast);
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }

    public boolean addVod(Vod vod) {
        String vodId = null;
        boolean result = false;
        if (vod != null) {
            try {
                vodId = RandomStringUtils.randomNumeric((int)24);
                vod.setVodId(vodId);
                this.vodMap.put(vodId, vod);
                result = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<Vod> getVodList(int offset, int size) {
        Collection<Vod> values = this.vodMap.values();
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        ArrayList<Vod> list = new ArrayList<Vod>();
        for (Vod vodString : values) {
            if (t < offset) {
                ++t;
                continue;
            }
            list.add(vodString);
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }

    public boolean deleteVod(String id) {
        boolean result = this.vodMap.remove(id) != null;
        return result;
    }

    public boolean removeAllEndpoints(String id) {
        boolean result = false;
        Broadcast broadcast = this.broadcastMap.get(id);
        if (broadcast != null) {
            broadcast.setEndPointList(null);
            this.broadcastMap.replace(id, broadcast);
            result = true;
        }
        return result;
    }

    public long getTotalVodNumber() {
        return this.vodMap.size();
    }

    public int fetchUserVodList(File userfile) {
        if (userfile == null) {
            return 0;
        }
        int numberOfSavedFiles = 0;
        Collection<Vod> vodCollection = this.vodMap.values();
        Iterator<Vod> iterator = vodCollection.iterator();
        while (iterator.hasNext()) {
            Vod vod = iterator.next();
            if (!vod.getType().equals("userVod")) continue;
            iterator.remove();
        }
        File[] listOfFiles = userfile.listFiles();
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                String fileExtension = FilenameUtils.getExtension((String)file.getName());
                if (!file.isFile() || !fileExtension.equals("mp4") && !fileExtension.equals("flv") && !fileExtension.equals("mkv")) continue;
                long fileSize = file.length();
                long unixTime = System.currentTimeMillis();
                String filePath = file.getPath();
                String[] subDirs = filePath.split(Pattern.quote(File.separator));
                int pathLength = subDirs.length;
                String relativePath = subDirs[pathLength - 3] + '/' + subDirs[pathLength - 2] + '/' + subDirs[pathLength - 1];
                Vod newVod = new Vod("vodFile", "vodFile", relativePath, file.getName(), unixTime, 0L, fileSize, "userVod");
                this.addUserVod(newVod);
                ++numberOfSavedFiles;
            }
        }
        return numberOfSavedFiles;
    }

    public boolean addUserVod(Vod vod) {
        String vodId = null;
        boolean result = false;
        if (vod != null) {
            try {
                vodId = RandomStringUtils.randomNumeric((int)24);
                vod.setVodId(vodId);
                this.vodMap.put(vodId, vod);
                result = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean updateSourceQuality(String id, String quality) {
        Broadcast broadcast;
        boolean result = false;
        if (id != null && (broadcast = this.broadcastMap.get(id)) != null) {
            broadcast.setQuality(quality);
            this.broadcastMap.replace(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean updateSourceSpeed(String id, double speed) {
        Broadcast broadcast;
        boolean result = false;
        if (id != null && (broadcast = this.broadcastMap.get(id)) != null) {
            broadcast.setSpeed(speed);
            this.broadcastMap.replace(id, broadcast);
            result = true;
        }
        return result;
    }

    public SocialEndpointCredentials addSocialEndpointCredentials(SocialEndpointCredentials credentials) {
        SocialEndpointCredentials addedCredential = null;
        if (credentials != null && credentials.getAccountName() != null && credentials.getAccessToken() != null && credentials.getServiceName() != null) {
            if (credentials.getId() == null) {
                String id = RandomStringUtils.randomAlphanumeric((int)6);
                credentials.setId(id);
                this.socialEndpointCredentialsMap.put(id, credentials);
                addedCredential = credentials;
            } else if (this.socialEndpointCredentialsMap.get(credentials.getId()) != null) {
                this.socialEndpointCredentialsMap.put(credentials.getId(), credentials);
                addedCredential = credentials;
            }
        }
        return addedCredential;
    }

    public List<SocialEndpointCredentials> getSocialEndpoints(int offset, int size) {
        Collection<SocialEndpointCredentials> values = this.socialEndpointCredentialsMap.values();
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        ArrayList<SocialEndpointCredentials> list = new ArrayList<SocialEndpointCredentials>();
        for (SocialEndpointCredentials credential : values) {
            if (t < offset) {
                ++t;
                continue;
            }
            list.add(credential);
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }

    public boolean removeSocialEndpointCredentials(String id) {
        return this.socialEndpointCredentialsMap.remove(id) != null;
    }

    public SocialEndpointCredentials getSocialEndpointCredentials(String id) {
        SocialEndpointCredentials credential = null;
        if (id != null) {
            credential = this.socialEndpointCredentialsMap.get(id);
        }
        return credential;
    }

    public long getTotalBroadcastNumber() {
        return this.broadcastMap.size();
    }
}

