/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.Vod;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.query.FindOptions;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStore
implements IDataStore {
    private Morphia morphia = new Morphia();
    private Datastore datastore;
    private Datastore vodDatastore;
    private Datastore endpointCredentialsDS;
    protected static Logger logger = LoggerFactory.getLogger(MongoStore.class);

    public MongoStore(String dbName) {
        this.morphia.mapPackage("io.antmedia.datastore.db.types");
        this.datastore = this.morphia.createDatastore(new MongoClient(), dbName);
        this.vodDatastore = this.morphia.createDatastore(new MongoClient(), dbName + "Vod");
        this.endpointCredentialsDS = this.morphia.createDatastore(new MongoClient(), dbName + "_endpointCredentials");
        this.datastore.ensureIndexes();
        this.vodDatastore.ensureIndexes();
        this.endpointCredentialsDS.ensureIndexes();
    }

    public MongoStore(String host, String username, String password, String dbName) {
        this.morphia.mapPackage("io.antmedia.datastore.db.types");
        ArrayList<MongoCredential> credentialList = new ArrayList<MongoCredential>();
        credentialList.add(MongoCredential.createCredential((String)username, (String)dbName, (char[])password.toCharArray()));
        this.datastore = this.morphia.createDatastore(new MongoClient(new ServerAddress(host), credentialList), dbName);
        this.vodDatastore = this.morphia.createDatastore(new MongoClient(new ServerAddress(host), credentialList), dbName + "Vod");
        this.endpointCredentialsDS = this.morphia.createDatastore(new MongoClient(new ServerAddress(host), credentialList), dbName + "_endpointCredentials");
        this.datastore.ensureIndexes();
        this.vodDatastore.ensureIndexes();
        this.endpointCredentialsDS.ensureIndexes();
    }

    public String save(Broadcast broadcast) {
        if (broadcast == null) {
            return null;
        }
        try {
            String streamId = null;
            if (broadcast.getStreamId() == null) {
                streamId = RandomStringUtils.randomAlphanumeric((int)12) + System.currentTimeMillis();
                broadcast.setStreamId(streamId);
            }
            streamId = broadcast.getStreamId();
            String rtmpURL = broadcast.getRtmpURL();
            if (rtmpURL != null) {
                rtmpURL = rtmpURL + streamId;
            }
            broadcast.setRtmpURL(rtmpURL);
            Key key = this.datastore.save((Object)broadcast);
            return streamId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Broadcast get(String id) {
        try {
            return (Broadcast)((Query)this.datastore.find(Broadcast.class).field("streamId").equal((Object)id)).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean updateName(String id, String name, String description) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set("name", (Object)name).set("description", (Object)description);
            UpdateResults update = this.datastore.update(query, ops);
            return update.getUpdatedCount() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateStatus(String id, String status) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set("status", (Object)status);
            UpdateResults update = this.datastore.update(query, ops);
            return update.getUpdatedCount() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateDuration(String id, long duration) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set("duration", (Object)duration);
            UpdateResults update = this.datastore.update(query, ops);
            return update.getUpdatedCount() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updatePublish(String id, boolean publish) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("dbId").equal((Object)new ObjectId(id));
            UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set("publish", (Object)publish);
            UpdateResults update = this.datastore.update(query, ops);
            return update.getUpdatedCount() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean addEndpoint(String id, Endpoint endpoint) {
        if (id != null && endpoint != null) {
            try {
                Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
                UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).push("endPointList", (Object)endpoint);
                UpdateResults update = this.datastore.update(query, ops);
                return update.getUpdatedCount() == 1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean removeEndpoint(String id, Endpoint endpoint) {
        boolean result = false;
        if (id != null && endpoint != null) {
            UpdateOperations ops;
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            UpdateResults update = this.datastore.update(query, ops = this.datastore.createUpdateOperations(Broadcast.class).removeAll("endPointList", (Object)endpoint));
            return update.getUpdatedCount() == 1;
        }
        return result;
    }

    public boolean removeAllEndpoints(String id) {
        boolean result = false;
        if (id != null) {
            UpdateOperations ops;
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            UpdateResults update = this.datastore.update(query, ops = this.datastore.createUpdateOperations(Broadcast.class).unset("endPointList"));
            return update.getUpdatedCount() == 1;
        }
        return result;
    }

    public long getBroadcastCount() {
        return this.datastore.getCount(Broadcast.class);
    }

    public boolean delete(String id) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            WriteResult delete = this.datastore.delete(query);
            return delete.getN() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<Broadcast> getBroadcastList(int offset, int size) {
        return this.datastore.find(Broadcast.class).asList(new FindOptions().skip(offset).limit(size));
    }

    public Datastore getDataStore() {
        return this.datastore;
    }

    public boolean editCameraInfo(Broadcast camera) {
        boolean result = false;
        try {
            logger.warn("result inside edit camera: " + result);
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)camera.getStreamId());
            UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set("name", (Object)camera.getName()).set("username", (Object)camera.getUsername()).set("password", (Object)camera.getPassword()).set("ipAddr", (Object)camera.getIpAddr());
            UpdateResults update = this.datastore.update(query, ops);
            return update.getUpdatedCount() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteStream(String id) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            WriteResult delete = this.datastore.delete(query);
            return delete.getN() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<Broadcast> getExternalStreamsList() {
        try {
            List ipCameraList = ((Query)this.datastore.find(Broadcast.class).field("type").equal((Object)"ipCamera")).asList();
            List streamSourceList = ((Query)this.datastore.find(Broadcast.class).field("type").equal((Object)"streamSource")).asList();
            ArrayList<Broadcast> newList = new ArrayList<Broadcast>(ipCameraList);
            newList.addAll(streamSourceList);
            return newList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close() {
        this.datastore.getMongo().close();
    }

    public List<Broadcast> filterBroadcastList(int offset, int size, String type) {
        try {
            return ((Query)this.datastore.find(Broadcast.class).field("type").equal((Object)type)).asList(new FindOptions().skip(offset).limit(size));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean addVod(Vod vod) {
        String vodId = null;
        boolean result = false;
        try {
            if (vod.getStreamId() == null) {
                vodId = RandomStringUtils.randomAlphanumeric((int)12) + System.currentTimeMillis();
                vod.setStreamId(vodId);
            }
            vodId = vod.getStreamId();
            vod.setVodId(vodId);
            Key key = this.vodDatastore.save((Object)vod);
            result = true;
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public List<Vod> getVodList(int offset, int size) {
        return this.vodDatastore.find(Vod.class).asList(new FindOptions().skip(offset).limit(size));
    }

    public boolean deleteVod(String id) {
        try {
            Query query = (Query)this.vodDatastore.createQuery(Vod.class).field("vodId").equal((Object)id);
            WriteResult delete = this.vodDatastore.delete(query);
            return delete.getN() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long getTotalVodNumber() {
        return this.vodDatastore.getCount(Vod.class);
    }

    public int fetchUserVodList(File userfile) {
        if (userfile == null) {
            return 0;
        }
        int numberOfSavedFiles = 0;
        try {
            Query query = (Query)this.vodDatastore.createQuery(Vod.class).field("type").equal((Object)"userVod");
            WriteResult writeResult = this.vodDatastore.delete(query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WriteResult listOfFiles = userfile.listFiles();
        if (listOfFiles != null) {
            for (WriteResult file : listOfFiles) {
                String fileExtension = FilenameUtils.getExtension((String)file.getName());
                if (!file.isFile() || !fileExtension.equals("mp4") && !fileExtension.equals("flv") && !fileExtension.equals("mkv")) continue;
                long fileSize = file.length();
                long unixTime = System.currentTimeMillis();
                String filePath = file.getPath();
                String[] subDirs = filePath.split(Pattern.quote(File.separator));
                int pathLength = subDirs.length;
                String relativePath = subDirs[pathLength - 3] + '/' + subDirs[pathLength - 2] + '/' + subDirs[pathLength - 1];
                Vod newVod = new Vod("vodFile", "vodFile", relativePath, file.getName(), unixTime, 0L, fileSize, "userVod");
                this.addUserVod(newVod);
                ++numberOfSavedFiles;
            }
        }
        return numberOfSavedFiles;
    }

    public boolean addUserVod(Vod vod) {
        try {
            String vodId = null;
            if (vod.getVodId() == null) {
                vodId = RandomStringUtils.randomAlphanumeric((int)12) + System.currentTimeMillis();
                vod.setVodId(vodId);
            }
            vodId = vod.getStreamId();
            Key key = this.vodDatastore.save((Object)vod);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateSourceQuality(String id, String quality) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set("quality", (Object)quality);
            UpdateResults update = this.datastore.update(query, ops);
            return update.getUpdatedCount() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateSourceSpeed(String id, double speed) {
        try {
            Query query = (Query)this.datastore.createQuery(Broadcast.class).field("streamId").equal((Object)id);
            UpdateOperations ops = this.datastore.createUpdateOperations(Broadcast.class).set("speed", (Object)speed);
            UpdateResults update = this.datastore.update(query, ops);
            return update.getUpdatedCount() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public SocialEndpointCredentials addSocialEndpointCredentials(SocialEndpointCredentials credentials) {
        SocialEndpointCredentials addedCredential = null;
        if (credentials != null && credentials.getAccountName() != null && credentials.getAccessToken() != null && credentials.getServiceName() != null) {
            if (credentials.getId() == null) {
                this.endpointCredentialsDS.save((Object)credentials);
                addedCredential = credentials;
            } else {
                SocialEndpointCredentials endpointCredentials = this.getSocialEndpointCredentials(credentials.getId());
                if (endpointCredentials != null) {
                    UpdateOperations ops = this.endpointCredentialsDS.createUpdateOperations(SocialEndpointCredentials.class).set("accessToken", (Object)credentials.getAccessToken());
                    if (credentials.getAccountId() != null) {
                        ops.set("accountId", (Object)credentials.getAccountId());
                    }
                    if (credentials.getAccountName() != null) {
                        ops.set("accountName", (Object)credentials.getAccountName());
                    }
                    if (credentials.getAccountType() != null) {
                        ops.set("accountType", (Object)credentials.getAccountType());
                    }
                    if (credentials.getAuthTimeInMilliseconds() != null) {
                        ops.set("authTimeInMilliseconds", (Object)credentials.getAuthTimeInMilliseconds());
                    }
                    if (credentials.getExpireTimeInSeconds() != null) {
                        ops.set("expireTimeInSeconds", (Object)credentials.getExpireTimeInSeconds());
                    }
                    if (credentials.getRefreshToken() != null) {
                        ops.set("refreshToken", (Object)credentials.getRefreshToken());
                    }
                    if (credentials.getTokenType() != null) {
                        ops.set("tokenType", (Object)credentials.getTokenType());
                    }
                    UpdateResults update = this.endpointCredentialsDS.update((Object)endpointCredentials, ops);
                    addedCredential = credentials;
                }
            }
        }
        return addedCredential;
    }

    public List<SocialEndpointCredentials> getSocialEndpoints(int offset, int size) {
        return this.endpointCredentialsDS.find(SocialEndpointCredentials.class).asList(new FindOptions().skip(offset).limit(size));
    }

    public boolean removeSocialEndpointCredentials(String id) {
        try {
            Query query = (Query)this.endpointCredentialsDS.createQuery(SocialEndpointCredentials.class).field("id").equal((Object)new ObjectId(id));
            WriteResult delete = this.endpointCredentialsDS.delete(query);
            return delete.getN() == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public SocialEndpointCredentials getSocialEndpointCredentials(String id) {
        try {
            return (SocialEndpointCredentials)this.endpointCredentialsDS.get(SocialEndpointCredentials.class, (Object)new ObjectId(id));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Datastore getEndpointCredentialsDS() {
        return this.endpointCredentialsDS;
    }

    public void setEndpointCredentialsDS(Datastore endpointCredentialsDS) {
        this.endpointCredentialsDS = endpointCredentialsDS;
    }

    public long getTotalBroadcastNumber() {
        return this.datastore.getCount(Broadcast.class);
    }

    public Datastore getVodDatastore() {
        return this.vodDatastore;
    }

    public void setVodDatastore(Datastore vodDatastore) {
        this.vodDatastore = vodDatastore;
    }
}

