/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.streamsource;

import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.rest.model.Result;
import io.antmedia.streamsource.StreamFetcher;
import java.util.ArrayList;
import java.util.List;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFetcherManager {
    protected static Logger logger = LoggerFactory.getLogger(StreamFetcherManager.class);
    private int streamCheckerCount = 0;
    private List<StreamFetcher> streamFetcherList = new ArrayList<StreamFetcher>();
    private int streamCheckerInterval = 10000;
    private ISchedulingService schedulingService;
    private IDataStore datastore;
    private String streamFetcherScheduleJobName;

    public StreamFetcherManager(ISchedulingService schedulingService, IDataStore datastore) {
        this.schedulingService = schedulingService;
        this.datastore = datastore;
    }

    public int getStreamCheckerInterval() {
        return this.streamCheckerInterval;
    }

    public void setStreamCheckerInterval(int streamCheckerInterval) {
        this.streamCheckerInterval = streamCheckerInterval;
    }

    public Result startStreaming(Broadcast broadcast) {
        Result result = new Result(true);
        StreamFetcher streamScheduler = new StreamFetcher(broadcast);
        this.streamFetcherList.add(streamScheduler);
        streamScheduler.startStream();
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (!streamScheduler.getCameraError().isSuccess()) {
            result = streamScheduler.getCameraError();
        }
        return result;
    }

    public void stopStreaming(Broadcast stream) {
        logger.warn("inside of stopStreaming");
        for (StreamFetcher streamScheduler : this.streamFetcherList) {
            if (!streamScheduler.getStream().getStreamId().equals(stream.getStreamId())) continue;
            streamScheduler.stopStream();
            this.streamFetcherList.remove(streamScheduler);
            break;
        }
    }

    public void startStreams(List<Broadcast> streams) {
        for (int i = 0; i < streams.size(); ++i) {
            this.startStreaming(streams.get(i));
        }
        if (this.streamFetcherScheduleJobName != null) {
            this.schedulingService.removeScheduledJob(this.streamFetcherScheduleJobName);
        }
        this.streamFetcherScheduleJobName = this.schedulingService.addScheduledJobAfterDelay(this.streamCheckerInterval, new IScheduledJob(){

            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                block6: {
                    if (StreamFetcherManager.this.streamFetcherList.size() <= 0) break block6;
                    StreamFetcherManager.this.streamCheckerCount++;
                    logger.warn("StreamFetcher Check Count  :" + StreamFetcherManager.this.streamCheckerCount);
                    if (StreamFetcherManager.this.streamCheckerCount % 180 == 0) {
                        for (StreamFetcher streamScheduler : StreamFetcherManager.this.streamFetcherList) {
                            if (streamScheduler.isStreamAlive()) {
                                streamScheduler.stopStream();
                            }
                            streamScheduler.startStream();
                        }
                    } else {
                        for (StreamFetcher streamScheduler : StreamFetcherManager.this.streamFetcherList) {
                            if (streamScheduler.isStreamAlive()) continue;
                            Broadcast stream = streamScheduler.getStream();
                            if (StreamFetcherManager.this.datastore != null && stream.getStreamId() != null) {
                                logger.info("Updating stream status to finished, updating status of stream {}", (Object)stream.getStreamId());
                                StreamFetcherManager.this.datastore.updateStatus(stream.getStreamId(), "finished");
                            }
                            streamScheduler.startStream();
                        }
                    }
                }
            }
        }, 5000);
    }

    public IDataStore getDatastore() {
        return this.datastore;
    }

    public void setDatastore(IDataStore datastore) {
        this.datastore = datastore;
    }

    public List<StreamFetcher> getStreamFetcherList() {
        return this.streamFetcherList;
    }

    public void setStreamFetcherList(List<StreamFetcher> streamFetcherList) {
        this.streamFetcherList = streamFetcherList;
    }
}

