/*
 * Decompiled with CFR 0.152.
 */
package com.antstreaming.rtsp;

import com.antstreaming.rtsp.RtspConnection;
import com.antstreaming.rtsp.RtspConnectionManager;
import com.antstreaming.rtsp.protocol.RtspCode;
import com.antstreaming.rtsp.protocol.RtspHeaderCode;
import com.antstreaming.rtsp.protocol.RtspResponse;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.red5.server.api.IServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RtspMinaIoHandler
extends IoHandlerAdapter {
    private Logger logger = LoggerFactory.getLogger(RtspMinaIoHandler.class);
    private String serverAddr;
    private int serverPort;
    protected IServer server;

    public void setServer(IServer server) {
        this.server = server;
        this.logger.debug("Server is set");
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        super.messageSent(session, message);
        this.logger.debug("sent message: " + message.toString());
    }

    public void sessionCreated(IoSession session) throws Exception {
        Object conn = RtspConnectionManager.getInstance().createConnection((Class)RtspConnection.class);
        conn.setIoSession(session);
        ((RtspConnection)conn).setSession(session);
        ((RtspConnection)conn).setServer(this.server);
        session.setAttribute((Object)"rtmp.sessionid", (Object)conn.getSessionId());
        this.logger.debug("connection session id:" + conn.getSessionId());
    }

    public void sessionOpened(IoSession session) throws Exception {
        super.sessionOpened(session);
        this.logger.debug("session opened with id " + session.getId());
    }

    public void sessionClosed(IoSession session) throws Exception {
        super.sessionClosed(session);
        this.logger.debug("session closed " + session);
        String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        RtspConnection rtspConnection = RtspConnectionManager.getInstance().removeConnection(sessionId);
        session.closeNow();
        rtspConnection.close();
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        this.logger.error(cause.getMessage(), cause);
        this.handleError(session, "0", RtspCode.InternalServerError);
    }

    private void handleError(IoSession session, String cseq, RtspCode code) {
        RtspResponse response = new RtspResponse();
        response.setCode(code);
        response.setHeader(RtspHeaderCode.CSEQ, cseq);
        session.write((Object)response);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        this.logger.debug("message received from sessiong with id " + session.getId());
        String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
        this.logger.debug("connection session id: " + sessionId);
        this.logger.debug("RTSP Server Receive Message: \n{}", message);
        RtspConnection rtspConnection = RtspConnectionManager.getInstance().getConnectionBySessionId(sessionId);
        if (rtspConnection != null) {
            rtspConnection.handleMessage(session, message);
        }
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }
}

