/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import com.drew.lang.annotations.Nullable;
import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointChannel;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.VoD;
import io.antmedia.muxer.Muxer;
import io.antmedia.rest.WebRTCClientStats;
import io.antmedia.rest.model.Result;
import io.antmedia.rest.model.Version;
import io.antmedia.social.endpoint.PeriscopeEndpoint;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import io.antmedia.storage.StorageClient;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
@Path(value="/")
public class BroadcastRestService {
    public static final int ERROR_SOCIAL_ENDPOINT_UNDEFINED_CLIENT_ID = -1;
    public static final int ERROR_SOCIAL_ENDPOINT_UNDEFINED_ENDPOINT = -2;
    public static final int ERROR_SOCIAL_ENDPOINT_EXCEPTION_IN_ASKING_AUTHPARAMS = -3;
    public static final String ENTERPRISE_EDITION = "Enterprise Edition";
    public static final String COMMUNITY_EDITION = "Community Edition";
    @Context
    private ServletContext servletContext;
    private IScope scope;
    private ApplicationContext appCtx;
    private AntMediaApplicationAdapter app;
    private IDataStore dataStore;
    private AppSettings appSettings;
    private ProcessBuilderFactory processBuilderFactory = null;
    protected static Logger logger = LoggerFactory.getLogger(BroadcastRestService.class);

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/create")
    @Produces(value={"application/json"})
    public Broadcast createBroadcast(Broadcast broadcast) {
        if (broadcast != null) {
            broadcast.resetStreamId();
        }
        String settingsListenerHookURL = null;
        String fqdn = null;
        AppSettings appSettingsLocal = this.getAppSettings();
        if (appSettingsLocal != null) {
            settingsListenerHookURL = appSettingsLocal.getListenerHookURL();
            fqdn = appSettingsLocal.getServerName();
        }
        return BroadcastRestService.saveBroadcast(broadcast, "created", this.getScope().getName(), this.getDataStore(), settingsListenerHookURL, fqdn);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/broadcast/createPortalBroadcast")
    @Produces(value={"application/json"})
    public Broadcast createPortalBroadcast(@FormParam(value="name") String name, @FormParam(value="listenerHookURL") String listenerHookURL) {
        Broadcast broadcast = new Broadcast();
        broadcast.setName(name);
        broadcast.setListenerHookURL(listenerHookURL);
        String settingsListenerHookURL = null;
        String fqdn = null;
        AppSettings appSettingsLocal = this.getAppSettings();
        if (appSettingsLocal != null) {
            settingsListenerHookURL = appSettingsLocal.getListenerHookURL();
            fqdn = appSettingsLocal.getServerName();
        }
        return BroadcastRestService.saveBroadcast(broadcast, "created", this.getScope().getName(), this.getDataStore(), settingsListenerHookURL, fqdn);
    }

    public static Broadcast saveBroadcast(Broadcast broadcast, String status, String scopeName, IDataStore dataStore, String settingsListenerHookURL, String fqdn) {
        if (broadcast == null) {
            broadcast = new Broadcast();
        }
        broadcast.setStatus(status);
        broadcast.setDate(Long.valueOf(System.currentTimeMillis()));
        String listenerHookURL = broadcast.getListenerHookURL();
        if ((listenerHookURL == null || listenerHookURL.isEmpty()) && settingsListenerHookURL != null && !settingsListenerHookURL.isEmpty()) {
            broadcast.setListenerHookURL(settingsListenerHookURL);
        }
        if (fqdn == null || fqdn.length() == 0) {
            try {
                fqdn = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (fqdn != null && fqdn.length() >= 0) {
            broadcast.setRtmpURL("rtmp://" + fqdn + "/" + scopeName + "/");
        }
        dataStore.save(broadcast);
        return broadcast;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/createWithSocial")
    @Produces(value={"application/json"})
    public Broadcast createWithSocial(Broadcast broadcast, @QueryParam(value="socialNetworks") String socialEndpointIds) {
        if ((broadcast = this.createBroadcast(broadcast)).getStreamId() != null && socialEndpointIds != null) {
            String[] endpointIds;
            for (String endpointId : endpointIds = socialEndpointIds.split(",")) {
                this.addSocialEndpoint(broadcast.getStreamId(), endpointId);
            }
        }
        return this.getBroadcast(broadcast.getStreamId());
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/stop/{streamId}")
    @Produces(value={"application/json"})
    public Result stopBroadcast(@PathParam(value="streamId") String streamId) {
        boolean result = false;
        String message = "";
        IBroadcastStream broadcastStream = this.getApplication().getBroadcastStream(this.getScope(), streamId);
        if (broadcastStream != null) {
            ((IClientBroadcastStream)broadcastStream).getConnection().close();
            result = true;
        } else {
            message = "No active broadcast found with id " + streamId;
            logger.warn("No active broadcast found with id {}", (Object)streamId);
        }
        return new Result(result, message);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/update")
    @Produces(value={"application/json"})
    public Result updateBroadcast(Broadcast broadcast, @QueryParam(value="socialNetworks") String socialNetworksToPublish) {
        boolean result = this.getDataStore().updateName(broadcast.getStreamId(), broadcast.getName(), broadcast.getDescription());
        String message = "";
        int errorId = 0;
        if (result) {
            Broadcast fetchedBroadcast = this.getDataStore().get(broadcast.getStreamId());
            this.getDataStore().removeAllEndpoints(fetchedBroadcast.getStreamId());
            if (socialNetworksToPublish != null && socialNetworksToPublish.length() > 0) {
                String[] socialNetworks;
                for (String networkName : socialNetworks = socialNetworksToPublish.split(",")) {
                    Result addSocialEndpoint = this.addSocialEndpoint(broadcast.getStreamId(), networkName);
                    if (addSocialEndpoint.isSuccess()) continue;
                    result = false;
                    message = message + networkName + " ";
                    errorId = -1;
                    break;
                }
            }
        }
        if (message.length() > 0) {
            message = message + " endpoint cannot be added";
        }
        return new Result(result, message, errorId);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/revokeSocialNetwork/{endpointId}")
    @Produces(value={"application/json"})
    public Result revokeSocialNetwork(@PathParam(value="endpointId") String endpointId) {
        List<VideoServiceEndpoint> endPoint = this.getEndpointList();
        String message = null;
        boolean serviceFound = false;
        boolean result = false;
        if (endPoint != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                SocialEndpointCredentials credentials = videoServiceEndpoint.getCredentials();
                if (!credentials.getId().equals(endpointId)) continue;
                serviceFound = true;
                videoServiceEndpoint.resetCredentials();
                endPoint.remove(videoServiceEndpoint);
                result = true;
                break;
            }
            if (!serviceFound) {
                message = "Service with the name specified is not found in this app";
            }
        } else {
            message = "No endpoint is defined for this app";
        }
        return new Result(result, message);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/broadcast/addSocialEndpoint")
    @Produces(value={"application/json"})
    public Result addSocialEndpoint(@FormParam(value="id") String id, @FormParam(value="serviceName") String endpointServiceId) {
        boolean success = false;
        String message = null;
        Broadcast broadcast = this.lookupBroadcast(id);
        if (broadcast != null) {
            List<VideoServiceEndpoint> endPointServiceList = this.getEndpointList();
            if (endPointServiceList != null) {
                boolean serviceFound = false;
                for (VideoServiceEndpoint videoServiceEndpoint : endPointServiceList) {
                    SocialEndpointCredentials credentials = videoServiceEndpoint.getCredentials();
                    if (credentials == null || !credentials.getId().equals(endpointServiceId)) continue;
                    serviceFound = true;
                    try {
                        Endpoint endpoint = videoServiceEndpoint.createBroadcast(broadcast.getName(), broadcast.getDescription(), broadcast.isIs360(), broadcast.isPublicStream(), 720, true);
                        success = this.getDataStore().addEndpoint(id, endpoint);
                    }
                    catch (Exception e) {
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                        message = e.getMessage();
                    }
                }
                if (!serviceFound) {
                    message = endpointServiceId + " endpoint does not exist in this app.";
                }
            } else {
                message = "No social endpoint is defined for this app. Consult your app developer";
            }
        } else {
            message = "No broadcast exist with the id specified";
        }
        return new Result(success, message);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/broadcast/addEndpoint")
    @Produces(value={"application/json"})
    public Result addEndpoint(@FormParam(value="id") String id, @FormParam(value="rtmpUrl") String rtmpUrl) {
        boolean success = false;
        String message = null;
        try {
            Broadcast broadcast = this.lookupBroadcast(id);
            Endpoint endpoint = new Endpoint();
            endpoint.rtmpUrl = rtmpUrl;
            endpoint.type = "generic";
            success = this.getDataStore().addEndpoint(id, endpoint);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return new Result(success, message);
    }

    protected Broadcast lookupBroadcast(String id) {
        Broadcast broadcast = null;
        try {
            broadcast = this.getDataStore().get(id);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return broadcast;
    }

    @GET
    @Path(value="/broadcast/get")
    @Produces(value={"application/json"})
    public Broadcast getBroadcast(@QueryParam(value="id") String id) {
        Broadcast broadcast = null;
        if (id != null) {
            broadcast = this.lookupBroadcast(id);
        }
        if (broadcast == null) {
            broadcast = new Broadcast(null, null);
        }
        return broadcast;
    }

    @GET
    @Path(value="/broadcast/getVoD")
    @Produces(value={"application/json"})
    public VoD getVoD(@QueryParam(value="id") String id) {
        VoD vod = null;
        if (id != null) {
            vod = this.getDataStore().getVoD(id);
        }
        if (vod == null) {
            vod = new VoD();
        }
        return vod;
    }

    @GET
    @Path(value="/detection/get")
    @Produces(value={"application/json"})
    public List<TensorFlowObject> getDetectedObjects(@QueryParam(value="id") String id) {
        ArrayList list = null;
        if (id != null) {
            list = this.getDataStore().getDetection(id);
        }
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    @GET
    @Path(value="/detection/getList/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<TensorFlowObject> getDetectionList(@QueryParam(value="id") String id, @PathParam(value="offset") int offset, @PathParam(value="size") int size) {
        List list = null;
        if (id != null) {
            list = this.getDataStore().getDetectionList(id, offset, size);
        }
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    @GET
    @Path(value="/broadcast/getList/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<Broadcast> getBroadcastList(@PathParam(value="offset") int offset, @PathParam(value="size") int size) {
        return this.getDataStore().getBroadcastList(offset, size);
    }

    @GET
    @Path(value="/detection/getObjectDetectedTotal")
    @Produces(value={"application/json"})
    public long getObjectDetectedTotal(@QueryParam(value="id") String id) {
        return this.getDataStore().getObjectDetectedTotal(id);
    }

    @POST
    @Path(value="/importLiveStreamsToStalker")
    @Produces(value={"application/json"})
    public Result importLiveStreams2Stalker() {
        String stalkerDBServer = this.getAppSettings().getStalkerDBServer();
        String stalkerDBUsername = this.getAppSettings().getStalkerDBUsername();
        String stalkerDBPassword = this.getAppSettings().getStalkerDBPassword();
        boolean result = false;
        String message = "";
        int errorId = -1;
        if (stalkerDBServer != null && stalkerDBServer.length() > 0 && stalkerDBUsername != null && stalkerDBUsername.length() > 0 && stalkerDBPassword != null && stalkerDBPassword.length() > 0) {
            long broadcastCount = this.getDataStore().getBroadcastCount();
            int pageCount = (int)broadcastCount / 50 + (broadcastCount % 50L != 0L ? 1 : 0);
            ArrayList broadcastList = new ArrayList();
            for (int i = 0; i < pageCount; ++i) {
                broadcastList.addAll(this.getDataStore().getBroadcastList(i * 50, 50));
            }
            StringBuilder insertQueryString = new StringBuilder();
            insertQueryString.append("DELETE FROM stalker_db.ch_links;");
            insertQueryString.append("DELETE FROM stalker_db.itv;");
            String fqdn = this.getAppSettings().getServerName();
            if (fqdn == null || fqdn.length() == 0) {
                try {
                    fqdn = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            int number = 1;
            for (Broadcast broadcast : broadcastList) {
                String cmd = "ffmpeg http://" + fqdn + ":5080/" + this.getScope().getName() + "/streams/" + broadcast.getStreamId() + ".m3u8";
                insertQueryString.append("INSERT INTO stalker_db.itv(name, number, tv_genre_id, base_ch, cmd, languages) VALUES ('" + broadcast.getName() + "' , " + number + ", 2, 1, '" + cmd + "', '');");
                insertQueryString.append("SET @last_id=LAST_INSERT_ID();INSERT INTO stalker_db.ch_links(ch_id, url) VALUES(@last_id, '" + cmd + "');");
                ++number;
            }
            result = this.runStalkerImportQuery(insertQueryString.toString(), stalkerDBServer, stalkerDBUsername, stalkerDBPassword);
        } else {
            message = "Portal DB info is missing";
            errorId = 404;
        }
        return new Result(result, message, errorId);
    }

    private boolean runStalkerImportQuery(String query, String stalkerDBServer, String stalkerDBUsername, String stalkerDBPassword) {
        boolean result = false;
        try {
            Process p = this.getProcess(query, stalkerDBServer, stalkerDBUsername, stalkerDBPassword);
            if (p != null) {
                int exitWith;
                InputStream is = p.getInputStream();
                if (is != null) {
                    int length;
                    byte[] data = new byte[1024];
                    while ((length = is.read(data, 0, data.length)) != -1) {
                        if (!logger.isInfoEnabled()) continue;
                        logger.info(new String(data, 0, length));
                    }
                }
                if ((exitWith = p.waitFor()) == 0) {
                    result = true;
                }
            }
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InterruptedException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
        return result;
    }

    private Process getProcess(String query, String stalkerDBServer, String stalkerDBUsername, String stalkerDBPassword) {
        Process process = null;
        String mysqlClientPath = this.getAppSettings().getMySqlClientPath();
        if (this.processBuilderFactory != null) {
            process = this.processBuilderFactory.make(mysqlClientPath, "-h", stalkerDBServer, "-u", stalkerDBUsername, "-p" + stalkerDBPassword, "-e", query);
        } else {
            try {
                process = new ProcessBuilder(mysqlClientPath, "-h", stalkerDBServer, "-u", stalkerDBUsername, "-p" + stalkerDBPassword, "-e", query).redirectErrorStream(true).start();
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return process;
    }

    @POST
    @Path(value="/importVoDsToStalker")
    @Produces(value={"application/json"})
    public Result importVoDsToStalker() {
        String stalkerDBServer = this.getAppSettings().getStalkerDBServer();
        String stalkerDBUsername = this.getAppSettings().getStalkerDBUsername();
        String stalkerDBPassword = this.getAppSettings().getStalkerDBPassword();
        boolean result = false;
        String message = "";
        int errorId = -1;
        if (stalkerDBServer != null && stalkerDBUsername != null && stalkerDBPassword != null) {
            String vodFolderPath = this.getAppSettings().getVodFolder();
            if (vodFolderPath != null && !vodFolderPath.isEmpty()) {
                long totalVodNumber = this.getDataStore().getTotalVodNumber();
                int pageCount = (int)totalVodNumber / 50 + (totalVodNumber % 50L != 0L ? 1 : 0);
                ArrayList vodList = new ArrayList();
                for (int i = 0; i < pageCount; ++i) {
                    vodList.addAll(this.getDataStore().getVodList(i * 50, 50));
                }
                String fqdn = this.getAppSettings().getServerName();
                if (fqdn == null || fqdn.length() == 0) {
                    try {
                        fqdn = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
                StringBuilder insertQueryString = new StringBuilder();
                insertQueryString.append("DELETE FROM stalker_db.video_series_files;");
                insertQueryString.append("DELETE FROM stalker_db.video;");
                for (VoD vod : vodList) {
                    if (!vod.getType().equals("userVod")) continue;
                    insertQueryString.append("INSERT INTO stalker_db.video(name, o_name, protocol, category_id, cat_genre_id_1, status, cost, path, accessed) values('" + vod.getVodName() + "', '" + vod.getVodName() + "', '', 1, 1, 1, 0, '" + vod.getVodName() + "', 1);");
                    File vodFolder = new File(vodFolderPath);
                    int lastIndexOf = vod.getFilePath().lastIndexOf(vodFolder.getName());
                    String filePath = vod.getFilePath().substring(lastIndexOf);
                    String cmd = "ffmpeg http://" + fqdn + ":5080/" + this.getScope().getName() + "/streams/" + filePath;
                    insertQueryString.append("SET @last_id=LAST_INSERT_ID();");
                    insertQueryString.append("INSERT INTO stalker_db.video_series_files(video_id, file_type, protocol, url, languages, quality, date_add, date_modify, status, accessed)VALUES(@last_id, 'video', 'custom', '" + cmd + "', 'a:1:{i:0;s:2:\"en\";}', 5, NOW(), NOW(), 1, 1);");
                }
                result = this.runStalkerImportQuery(insertQueryString.toString(), stalkerDBServer, stalkerDBUsername, stalkerDBPassword);
            } else {
                message = "No VoD folder specified";
                errorId = 500;
            }
        } else {
            message = "Portal DB info is missing";
            errorId = 404;
        }
        return new Result(result, message, errorId);
    }

    @GET
    @Path(value="/broadcast/getVodList/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<VoD> getVodList(@PathParam(value="offset") int offset, @PathParam(value="size") int size) {
        return this.getDataStore().getVodList(offset, size);
    }

    @GET
    @Path(value="/broadcast/getTotalVodNumber")
    @Produces(value={"application/json"})
    public long getTotalVodNumber() {
        return this.getDataStore().getTotalVodNumber();
    }

    @GET
    @Path(value="/broadcast/getVersion")
    @Produces(value={"application/json"})
    public Version getVersion() {
        Version versionList = new Version();
        versionList.setVersionName(AntMediaApplicationAdapter.class.getPackage().getImplementationVersion());
        versionList.setVersionType(BroadcastRestService.isEnterprise() ? ENTERPRISE_EDITION : COMMUNITY_EDITION);
        logger.debug("Version Name {} Version Type {}", (Object)versionList.getVersionName(), (Object)versionList.getVersionType());
        return versionList;
    }

    @GET
    @Path(value="/broadcast/getTotalBroadcastNumber")
    @Produces(value={"application/json"})
    public long getTotalBroadcastNumber() {
        return this.getDataStore().getTotalBroadcastNumber();
    }

    @GET
    @Path(value="/broadcast/getAppLiveStatistics")
    @Produces(value={"application/json"})
    public LiveStatistics getAppLiveStatistics() {
        long activeBroadcastCount = this.getDataStore().getActiveBroadcastCount();
        return new LiveStatistics(activeBroadcastCount);
    }

    @GET
    @Path(value="/broadcast/getBroadcastLiveStatistics")
    @Produces(value={"application/json"})
    public BroadcastStatistics getBroadcastStatistics(@QueryParam(value="id") String id) {
        int totalRTMPViewer = -1;
        int totalWebRTCViewer = -1;
        int totalHLSViewer = -1;
        if (id != null) {
            IWebRTCAdaptor webRTCAdaptor;
            Broadcast broadcast;
            IBroadcastScope broadcastScope = this.getScope().getBroadcastScope(id);
            if (broadcastScope != null) {
                totalRTMPViewer = broadcastScope.getConsumers().size();
            }
            if ((broadcast = this.getDataStore().get(id)) != null) {
                totalHLSViewer = broadcast.getHlsViewerCount();
            }
            if ((webRTCAdaptor = this.getWebRTCAdaptor()) != null) {
                totalWebRTCViewer = webRTCAdaptor.getNumberOfViewers(id);
            }
        }
        return new BroadcastStatistics(totalRTMPViewer, totalHLSViewer, totalWebRTCViewer);
    }

    @GET
    @Path(value="/broadcast/getWebRTCClientStats/{stream_id}")
    @Produces(value={"application/json"})
    public List<WebRTCClientStats> getWebRTCClientStats(@PathParam(value="stream_id") String streamId) {
        IWebRTCAdaptor webRTCAdaptor = this.getWebRTCAdaptor();
        if (webRTCAdaptor != null) {
            return webRTCAdaptor.getWebRTCClientStats(streamId);
        }
        return new ArrayList<WebRTCClientStats>();
    }

    private IWebRTCAdaptor getWebRTCAdaptor() {
        IWebRTCAdaptor adaptor = null;
        ApplicationContext appContext = this.getAppContext();
        if (appContext != null && appContext.containsBean("webrtc.adaptor")) {
            adaptor = (IWebRTCAdaptor)appContext.getBean("webrtc.adaptor");
        }
        return adaptor;
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/filterList/{offset}/{size}/{type}")
    @Produces(value={"application/json"})
    public List<Broadcast> filterBroadcastList(@PathParam(value="offset") int offset, @PathParam(value="size") int size, @PathParam(value="type") String type) {
        return this.getDataStore().filterBroadcastList(offset, size, type);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/deleteVoDFile/{name}/{id}/{type}")
    @Produces(value={"application/json"})
    public Result deleteVoDFile(@PathParam(value="name") String fleName, @PathParam(value="id") String id, @PathParam(value="type") String type) {
        return this.deleteVoD(id);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/deleteVoD/{id}")
    @Produces(value={"application/json"})
    public Result deleteVoD(@PathParam(value="id") String id) {
        boolean success = false;
        String message = "";
        ApplicationContext appContext = this.getAppContext();
        if (appContext != null) {
            File videoFile = null;
            VoD voD = this.getDataStore().getVoD(id);
            if (voD != null) {
                try {
                    String filePath = String.format("webapps/%s/%s", this.getScope().getName(), voD.getFilePath());
                    videoFile = new File(filePath);
                    boolean result = Files.deleteIfExists(videoFile.toPath());
                    if (!result) {
                        logger.warn("File is not deleted because it does not exist {}", (Object)videoFile.getAbsolutePath());
                    }
                    if (success = this.getDataStore().deleteVod(id)) {
                        message = "vod deleted";
                    }
                    String fileName = videoFile.getName();
                    String[] splitFileName = StringUtils.split((String)fileName, (String)".");
                    File previewFile = Muxer.getPreviewFile((IScope)this.getScope(), (String)splitFileName[0], (String)".png");
                    Files.deleteIfExists(previewFile.toPath());
                    if (appContext.containsBean("app.storageClient")) {
                        StorageClient storageClient = (StorageClient)appContext.getBean("app.storageClient");
                        storageClient.delete(splitFileName[0] + ".mp4", StorageClient.FileType.TYPE_STREAM);
                        storageClient.delete(splitFileName[0] + ".png", StorageClient.FileType.TYPE_PREVIEW);
                    }
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return new Result(success, message);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/broadcast/uploadVoDFile/{name}")
    @Produces(value={"application/json"})
    public Result uploadVoDFile(@PathParam(value="name") String fileName, @FormDataParam(value="file") InputStream inputStream) {
        String id;
        String message;
        boolean success;
        block18: {
            success = false;
            message = "";
            id = null;
            String appScopeName = ScopeUtils.findApplication((IScope)this.getScope()).getName();
            String fileExtension = FilenameUtils.getExtension((String)fileName);
            try {
                if (fileExtension.equals("mp4")) {
                    File streamsDirectory = new File(this.getStreamsDirectory(appScopeName));
                    if (!streamsDirectory.exists()) {
                        streamsDirectory.mkdir();
                    }
                    String vodId = RandomStringUtils.randomNumeric((int)24);
                    File savedFile = new File(String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, "streams/" + vodId + ".mp4"));
                    int read = 0;
                    byte[] bytes = new byte[2048];
                    try (FileOutputStream outpuStream = new FileOutputStream(savedFile);){
                        while ((read = inputStream.read(bytes)) != -1) {
                            ((OutputStream)outpuStream).write(bytes, 0, read);
                        }
                        outpuStream.flush();
                        long fileSize = savedFile.length();
                        long unixTime = System.currentTimeMillis();
                        String path = savedFile.getPath();
                        String[] subDirs = path.split(Pattern.quote(File.separator));
                        Integer pathLength = subDirs.length;
                        String relativePath = subDirs[pathLength - 2] + File.separator + subDirs[pathLength - 1];
                        VoD newVod = new VoD(fileName, "file", relativePath, fileName, unixTime, 0L, fileSize, "uploadedVod", vodId);
                        id = this.getDataStore().addVod(newVod);
                        if (id != null) {
                            success = true;
                            message = id;
                        }
                        break block18;
                    }
                }
                message = "notMp4File";
            }
            catch (IOException iox) {
                logger.error(iox.getMessage());
            }
        }
        return new Result(success, id, message);
    }

    public String getStreamsDirectory(String appScopeName) {
        return String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, "streams");
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/delete/{id}")
    @Produces(value={"application/json"})
    public Result deleteBroadcast(@PathParam(value="id") String id) {
        Broadcast broacast;
        Result result = new Result(false);
        if (id != null && (broacast = this.getDataStore().get(id)) != null) {
            if (broacast.getType().equals("ipCamera") || broacast.getType().equals("streamSource")) {
                this.getApplication().stopStreaming(broacast);
            }
            result.setSuccess(this.getDataStore().delete(id));
            boolean stopResult = this.stopBroadcast(id).isSuccess();
            if (result.isSuccess() && stopResult) {
                result.setMessage("brodcast is deleted and stopped successfully");
                logger.info("brodcast {} is deleted and stopped successfully", (Object)id);
            } else if (result.isSuccess() && !stopResult) {
                result.setMessage("brodcast is deleted but could not stopped ");
                logger.info("brodcast {} is deleted but could not stopped", (Object)id);
            }
        }
        return result;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/getDeviceAuthParameters/{serviceName}")
    @Produces(value={"application/json"})
    public Object getDeviceAuthParameters(@PathParam(value="serviceName") String serviceName) {
        int errorId;
        String message;
        block13: {
            String clientId;
            message = null;
            boolean missingClientIdAndSecret = false;
            errorId = -1;
            VideoServiceEndpoint videoServiceEndpoint = null;
            if (serviceName.equals("facebook")) {
                clientId = this.getAppSettings().getFacebookClientId();
                String clientSecret = this.getAppSettings().getFacebookClientSecret();
                videoServiceEndpoint = this.getApplication().getEndpointService("io.antmedia.enterprise.social.endpoint.FacebookEndpoint", null, clientId, clientSecret);
                if (videoServiceEndpoint != null && (clientId == null || clientSecret == null || clientId.length() == 0 || clientSecret.length() == 0)) {
                    missingClientIdAndSecret = true;
                }
            } else if (serviceName.equals("youtube")) {
                clientId = this.getAppSettings().getYoutubeClientId();
                String clientSecret = this.getAppSettings().getYoutubeClientSecret();
                videoServiceEndpoint = this.getApplication().getEndpointService("io.antmedia.enterprise.social.endpoint.YoutubeEndpoint", null, clientId, clientSecret);
                if (videoServiceEndpoint != null && (clientId == null || clientSecret == null || clientId.length() == 0 || clientSecret.length() == 0)) {
                    missingClientIdAndSecret = true;
                }
            } else if (serviceName.equals("periscope")) {
                clientId = this.getAppSettings().getPeriscopeClientId();
                String clientSecret = this.getAppSettings().getPeriscopeClientSecret();
                if (clientId != null && clientSecret != null && clientId.length() > 0 && clientSecret.length() > 0) {
                    videoServiceEndpoint = new PeriscopeEndpoint(clientId, clientSecret, this.getDataStore(), null);
                } else {
                    missingClientIdAndSecret = true;
                }
            }
            try {
                if (missingClientIdAndSecret) {
                    errorId = -1;
                    message = "Please enter service client id and client secret in app configuration";
                    break block13;
                }
                if (videoServiceEndpoint == null) {
                    errorId = -2;
                    message = "Service with the name specified is not found in this app";
                    break block13;
                }
                VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters = videoServiceEndpoint.askDeviceAuthParameters();
                this.getApplication().startDeviceAuthStatusPolling(videoServiceEndpoint, askDeviceAuthParameters);
                return askDeviceAuthParameters;
            }
            catch (Exception e) {
                errorId = -3;
                message = "Exception in asking parameters";
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return new Result(false, message, errorId);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/checkDeviceAuthStatus/{userCode}")
    @Produces(value={"application/json"})
    public Result checkDeviceAuthStatus(@PathParam(value="userCode") String userCode) {
        VideoServiceEndpoint.DeviceAuthParameters authParameters;
        List<VideoServiceEndpoint> endPoint = this.getEndpointList();
        String message = null;
        boolean authenticated = false;
        String endpointId = null;
        if (endPoint != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                authParameters = videoServiceEndpoint.getAuthParameters();
                if (authParameters == null || !authParameters.user_code.equals(userCode)) continue;
                authenticated = true;
                endpointId = videoServiceEndpoint.getCredentials().getId();
                break;
            }
        }
        if (!authenticated) {
            endPoint = this.getEndpointsHavingErrorList();
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                authParameters = videoServiceEndpoint.getAuthParameters();
                if (authParameters == null || !authParameters.user_code.equals(userCode)) continue;
                authenticated = false;
                message = videoServiceEndpoint.getError();
                endPoint.remove(videoServiceEndpoint);
                break;
            }
        }
        return new Result(authenticated, endpointId, message);
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/getSocialEndpoints/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<SocialEndpointCredentials> getSocialEndpoints(@PathParam(value="offset") int offset, @PathParam(value="size") int size) {
        List<VideoServiceEndpoint> endPoint = this.getEndpointList();
        ArrayList<SocialEndpointCredentials> endPointCredentials = new ArrayList<SocialEndpointCredentials>();
        if (endPoint != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                endPointCredentials.add(videoServiceEndpoint.getCredentials());
            }
        }
        return endPointCredentials;
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/getSocialNetworkChannel/{endpointId}")
    @Produces(value={"application/json"})
    public SocialEndpointChannel getSocialNetworkChannel(@PathParam(value="endpointId") String endpointId) {
        List<VideoServiceEndpoint> endPoint = this.getEndpointList();
        SocialEndpointChannel channel = null;
        if (endPoint != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                SocialEndpointCredentials credentials = videoServiceEndpoint.getCredentials();
                if (credentials == null || !credentials.getId().equals(endpointId)) continue;
                channel = videoServiceEndpoint.getChannel();
                break;
            }
        }
        return channel;
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/getSocialNetworkChannelList/{endpointId}/{type}")
    @Produces(value={"application/json"})
    public List<SocialEndpointChannel> getSocialNetworkChannelList(@PathParam(value="endpointId") String endpointId, @PathParam(value="type") String type) {
        List<VideoServiceEndpoint> endPoint = this.getEndpointList();
        List<SocialEndpointChannel> channelList = null;
        if (endPoint != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                SocialEndpointCredentials credentials = videoServiceEndpoint.getCredentials();
                if (credentials == null || !credentials.getId().equals(endpointId)) continue;
                channelList = videoServiceEndpoint.getChannelList();
                break;
            }
        }
        return channelList;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/broadcast/setSocialNetworkChannel/{endpointId}/{type}/{id}")
    @Produces(value={"application/json"})
    public Result setSocialNetworkChannelList(@PathParam(value="endpointId") String endpointId, @PathParam(value="type") String type, @PathParam(value="id") String id) {
        boolean result = false;
        List<VideoServiceEndpoint> endPoint = this.getEndpointList();
        if (endPoint != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPoint) {
                SocialEndpointCredentials credentials = videoServiceEndpoint.getCredentials();
                if (credentials == null || !credentials.getId().equals(endpointId)) continue;
                result = videoServiceEndpoint.setActiveChannel(type, id);
                break;
            }
        }
        return new Result(result, null);
    }

    public static boolean isEnterprise() {
        try {
            Class.forName("io.antmedia.enterprise.adaptive.EncoderAdaptor");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public long getRecordCount() {
        return this.getDataStore().getBroadcastCount();
    }

    protected List<VideoServiceEndpoint> getEndpointList() {
        return this.getApplication().getVideoServiceEndpoints();
    }

    protected List<VideoServiceEndpoint> getEndpointsHavingErrorList() {
        return this.getApplication().getVideoServiceEndpointsHavingError();
    }

    @Nullable
    private ApplicationContext getAppContext() {
        if (this.appCtx == null && this.servletContext != null) {
            this.appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        return this.appCtx;
    }

    public IDataStore getDataStore() {
        ApplicationContext appContext;
        if (this.dataStore == null && (appContext = this.getAppContext()) != null) {
            this.dataStore = (IDataStore)appContext.getBean("db.datastore");
        }
        return this.dataStore;
    }

    public void setDataStore(IDataStore dataStore) {
        this.dataStore = dataStore;
    }

    protected AntMediaApplicationAdapter getApplication() {
        ApplicationContext appContext;
        if (this.app == null && (appContext = this.getAppContext()) != null) {
            this.app = (AntMediaApplicationAdapter)appContext.getBean("web.handler");
        }
        return this.app;
    }

    public void setApplication(AntMediaApplicationAdapter app) {
        this.app = app;
    }

    private AppSettings getAppSettings() {
        ApplicationContext appContext;
        if (this.appSettings == null && (appContext = this.getAppContext()) != null) {
            this.appSettings = (AppSettings)appContext.getBean("app.settings");
        }
        return this.appSettings;
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = this.getApplication().getScope();
        }
        return this.scope;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public void setAppCtx(ApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public ProcessBuilderFactory getProcessBuilderFactory() {
        return this.processBuilderFactory;
    }

    public void setProcessBuilderFactory(ProcessBuilderFactory processBuilderFactory) {
        this.processBuilderFactory = processBuilderFactory;
    }

    public static interface ProcessBuilderFactory {
        public Process make(String ... var1);
    }

    public static class LiveStatistics {
        public final long totalLiveStreamCount;

        public LiveStatistics(long totalLiveStreamCount) {
            this.totalLiveStreamCount = totalLiveStreamCount;
        }
    }

    public static class BroadcastStatistics {
        public final int totalRTMPWatchersCount;
        public final int totalHLSWatchersCount;
        public final int totalWebRTCWatchersCount;

        public BroadcastStatistics(int totalRTMPWatchersCount, int totalHLSWatchersCount, int totalWebRTCWatchersCount) {
            this.totalRTMPWatchersCount = totalRTMPWatchersCount;
            this.totalHLSWatchersCount = totalHLSWatchersCount;
            this.totalWebRTCWatchersCount = totalWebRTCWatchersCount;
        }
    }
}

