/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.security;

import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptOnlyStreamsInDataStore
implements IStreamPublishSecurity {
    private IDataStore dataStore;
    private boolean enabled = true;
    public static final String BEAN_NAME = "acceptOnlyStreamsInDataStore";
    protected static Logger logger = LoggerFactory.getLogger(AcceptOnlyStreamsInDataStore.class);

    public boolean isPublishAllowed(IScope scope, String name, String mode) {
        boolean result = false;
        if (this.enabled) {
            Broadcast broadcast = this.dataStore.get(name);
            if (broadcast != null) {
                result = true;
            } else {
                logger.info("No stream in data store not allowing the stream {}", (Object)name);
                Red5.getConnectionLocal().close();
            }
        } else {
            logger.info("AcceptOnlyStreamsInDataStore is not activated. Accepting all streams {}", (Object)name);
            result = true;
        }
        return result;
    }

    public IDataStore getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(IDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

