/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.social.endpoint;

import io.antmedia.api.periscope.AuthorizationEndpoints;
import io.antmedia.api.periscope.BroadcastEndpoints;
import io.antmedia.api.periscope.PeriscopeEndpointFactory;
import io.antmedia.api.periscope.RegionEndpoints;
import io.antmedia.api.periscope.UserEndpoints;
import io.antmedia.api.periscope.response.AuthorizationResponse;
import io.antmedia.api.periscope.response.CheckDeviceCodeResponse;
import io.antmedia.api.periscope.response.CreateBroadcastResponse;
import io.antmedia.api.periscope.response.CreateDeviceCodeResponse;
import io.antmedia.api.periscope.type.Broadcast;
import io.antmedia.api.periscope.type.User;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriscopeEndpoint
extends VideoServiceEndpoint {
    private AuthorizationEndpoints authorizationEndpoint;
    private String device_code;
    private PeriscopeEndpointFactory periscopeEndpointFactory;
    private BroadcastEndpoints broadcastEndpoint;
    private RegionEndpoints regionEndpoint;
    private String accessToken;
    private String region;
    private long expireTimeMS;
    private UserEndpoints userEndpoint;
    private String refresh_token;
    protected static Logger logger = LoggerFactory.getLogger(PeriscopeEndpoint.class);

    public PeriscopeEndpoint(String clientId, String clientSecret, IDataStore dataStore, SocialEndpointCredentials endpointCredentials) {
        super(clientId, clientSecret, dataStore, endpointCredentials);
    }

    @Override
    public String getName() {
        return "periscope";
    }

    @Override
    public VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters() throws Exception {
        AuthorizationEndpoints authorizationEndpoint = this.getAuthorizationEndpoint();
        CreateDeviceCodeResponse response = authorizationEndpoint.createDeviceCode(this.getClientId());
        if (response != null) {
            this.authParameters = new VideoServiceEndpoint.DeviceAuthParameters();
            this.authParameters.device_code = response.device_code;
            this.device_code = response.device_code;
            this.authParameters.expires_in = response.expires_in;
            this.authParameters.interval = response.interval;
            this.authParameters.user_code = response.user_code;
            this.authParameters.verification_url = response.associate_url;
        }
        return this.getAuthParameters();
    }

    private AuthorizationEndpoints getAuthorizationEndpoint() {
        if (this.authorizationEndpoint == null) {
            this.authorizationEndpoint = new AuthorizationEndpoints();
        }
        return this.authorizationEndpoint;
    }

    @Override
    public boolean askIfDeviceAuthenticated() throws Exception {
        AuthorizationEndpoints authorizationEndpoint = this.getAuthorizationEndpoint();
        CheckDeviceCodeResponse checkDeviceCode = authorizationEndpoint.checkDeviceCode(this.device_code, this.getClientId());
        logger.warn("State: " + checkDeviceCode.state);
        boolean result = false;
        if (checkDeviceCode.state.equals("associated")) {
            this.init("", checkDeviceCode.access_token, checkDeviceCode.refresh_token, checkDeviceCode.expires_in, checkDeviceCode.token_type, System.currentTimeMillis());
            String accountName = "";
            String accountId = "";
            try {
                User userResponse = this.userEndpoint.get();
                accountName = userResponse.username;
                accountId = userResponse.id;
                logger.info("authenticated account name is {}", (Object)accountName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.saveCredentials(accountName, checkDeviceCode.access_token, checkDeviceCode.refresh_token, String.valueOf(checkDeviceCode.expires_in), checkDeviceCode.token_type, accountId);
            result = true;
        }
        return result;
    }

    @Override
    public boolean isAuthenticated() {
        return this.periscopeEndpointFactory != null && this.accessToken != null && this.accessToken.length() > 0;
    }

    @Override
    public void resetCredentials() {
        super.resetCredentials();
        this.accessToken = null;
    }

    @Override
    public Endpoint createBroadcast(String name, String description, boolean is360, boolean isPublic, int videoHeight, boolean is_low_latency) throws Exception {
        if (this.broadcastEndpoint == null) {
            throw new Exception("First authenticated the server");
        }
        this.updateTokenIfRequired();
        CreateBroadcastResponse createBroadcastResponse = this.broadcastEndpoint.createBroadcast(this.getRegion(), is360, is_low_latency);
        String rtmpUrl = createBroadcastResponse.encoder.rtmp_url + "/" + createBroadcastResponse.encoder.stream_key;
        return new Endpoint(createBroadcastResponse.broadcast.id, null, name, rtmpUrl, this.getName(), this.getCredentials().getId());
    }

    private String getRegion() {
        if (this.region != null) {
            try {
                this.region = this.regionEndpoint.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.region;
    }

    @Override
    public void publishBroadcast(Endpoint endpoint) throws Exception {
        if (this.broadcastEndpoint == null) {
            throw new Exception("First authenticated the server");
        }
        if (endpoint.broadcastId == null) {
            throw new Exception("No broadcast is available, call createBroadcast function before calling publish broadcast");
        }
        this.updateTokenIfRequired();
        this.broadcastEndpoint.publishBroadcast(endpoint.broadcastId, endpoint.name, false, "en_US", true);
    }

    @Override
    public void stopBroadcast(Endpoint endpoint) throws Exception {
        if (this.broadcastEndpoint == null) {
            throw new Exception("First authenticated the server");
        }
        if (endpoint.broadcastId == null) {
            throw new Exception("No broadcast is available");
        }
        this.updateTokenIfRequired();
        this.broadcastEndpoint.stopBroadcast(endpoint.broadcastId);
    }

    private void updateTokenIfRequired() throws Exception {
        if (this.expireTimeMS < System.currentTimeMillis() + THREE_DAYS_IN_MS) {
            this.updateToken();
        }
    }

    public void updateToken() throws Exception {
        AuthorizationResponse token = this.periscopeEndpointFactory.refreshToken(this.clientId, this.clientSecret);
        if (token.refresh_token == null || token.refresh_token.length() == 0) {
            token.refresh_token = this.refresh_token;
        }
        this.saveCredentials(this.getCredentials().getAccountName(), token.access_token, token.refresh_token, String.valueOf(token.expires_in), token.token_type, this.getCredentials().getAccountId());
        this.init(this.getCredentials().getAccountName(), token.access_token, token.refresh_token, Long.valueOf(token.expires_in), token.token_type, System.currentTimeMillis());
    }

    @Override
    public void init(String accountName, String accessToken, String refreshToken, long expireTime, String tokenType, long authTimeInMS) {
        this.accessToken = accessToken;
        this.refresh_token = refreshToken;
        this.periscopeEndpointFactory = new PeriscopeEndpointFactory(tokenType, accessToken, refreshToken);
        this.expireTimeMS = authTimeInMS + expireTime * 1000L;
        this.broadcastEndpoint = this.periscopeEndpointFactory.getBroadcastEndpoints();
        this.regionEndpoint = this.periscopeEndpointFactory.getRegionEndpoints();
        this.userEndpoint = this.periscopeEndpointFactory.getUserEndpoints();
    }

    @Override
    public String getBroadcast(Endpoint endpoint) throws Exception {
        Broadcast broadcast = this.broadcastEndpoint.getBroadcast(endpoint.broadcastId);
        return broadcast.state.equals("running") ? "LIVE" : "UNPUBLISHED";
    }

    public String getAccountName() {
        return this.getCredentials().getAccountName();
    }

    public void setAccountName(String accountName) {
        this.getCredentials().setAccountName(accountName);
    }
}

