/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.streamsource;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.rest.model.Result;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bytedeco.javacpp.avcodec;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFetcher {
    protected static Logger logger = LoggerFactory.getLogger(StreamFetcher.class);
    private Broadcast stream;
    private WorkerThread thread;
    private int timeout;
    private boolean exceptionInThread = false;
    private long lastPacketReceivedTime = 0L;
    private boolean threadActive = false;
    private Result cameraError = new Result(false, "");
    private static final int PACKET_RECEIVED_INTERVAL_TIMEOUT = 3000;
    private IScope scope;
    private AntMediaApplicationAdapter appInstance;
    private long[] lastDTS;
    private MuxAdaptor muxAdaptor = null;
    private boolean restartStream = true;
    private int bufferTime = 0;
    private ConcurrentLinkedQueue<avcodec.AVPacket> availableBufferQueue = new ConcurrentLinkedQueue();
    private ISchedulingService scheduler;
    private avutil.AVRational avRationalTimeBaseMS;
    private AppSettings appSettings;

    public StreamFetcher(Broadcast stream, IScope scope, ISchedulingService scheduler) {
        if (stream == null || stream.getStreamId() == null || stream.getStreamUrl() == null) {
            String streamId = null;
            if (stream != null) {
                streamId = stream.getStreamId();
            }
            String streamUrl = null;
            if (stream != null) {
                streamUrl = stream.getStreamUrl();
            }
            throw new NullPointerException("Stream is not initialized properly. Check stream(" + stream + "),  stream id (" + streamId + ") and stream url (" + streamUrl + ") values");
        }
        this.stream = stream;
        this.scope = scope;
        this.scheduler = scheduler;
        if (this.getAppSettings() == null) {
            throw new NullPointerException("App Settings is null in StreamFetcher");
        }
        this.bufferTime = this.getAppSettings().getStreamFetcherBufferTime();
        this.avRationalTimeBaseMS = new avutil.AVRational();
        this.avRationalTimeBaseMS.num(1);
        this.avRationalTimeBaseMS.den(1000);
        logger.debug(":::::::::::scope is {}", (Object)scope.getName());
    }

    public Result prepareInput(avformat.AVFormatContext inputFormatContext) {
        this.setConnectionTimeout(5000);
        Result result = new Result(false);
        if (inputFormatContext == null) {
            logger.info("cannot allocate input context for {}", (Object)this.stream.getStreamId());
            return result;
        }
        avutil.AVDictionary optionsDictionary = new avutil.AVDictionary();
        String streamUrl = this.stream.getStreamUrl();
        if (streamUrl.startsWith("rtsp://")) {
            avutil.av_dict_set((avutil.AVDictionary)optionsDictionary, (String)"rtsp_transport", (String)"tcp", (int)0);
        }
        String timeoutStr = String.valueOf(this.timeout);
        avutil.av_dict_set((avutil.AVDictionary)optionsDictionary, (String)"stimeout", (String)timeoutStr, (int)0);
        logger.debug("stream url: {}  ", (Object)this.stream.getStreamUrl());
        int ret = avformat.avformat_open_input((avformat.AVFormatContext)inputFormatContext, (String)this.stream.getStreamUrl(), null, (avutil.AVDictionary)optionsDictionary);
        if (ret < 0) {
            byte[] data = new byte[1024];
            avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
            String errorStr = new String(data, 0, data.length);
            result.setMessage(errorStr);
            logger.debug("cannot open input context with error:: {}", (Object)result.getMessage());
            return result;
        }
        avutil.av_dict_free((avutil.AVDictionary)optionsDictionary);
        ret = avformat.avformat_find_stream_info((avformat.AVFormatContext)inputFormatContext, (avutil.AVDictionary)null);
        if (ret < 0) {
            result.setMessage("Could not find stream information\n");
            logger.info(result.getMessage());
            return result;
        }
        this.lastDTS = new long[inputFormatContext.nb_streams()];
        for (int i = 0; i < this.lastDTS.length; ++i) {
            this.lastDTS[i] = -1L;
        }
        result.setSuccess(true);
        return result;
    }

    public Result prepare(avformat.AVFormatContext inputFormatContext) {
        Result result = this.prepareInput(inputFormatContext);
        this.setCameraError(result);
        return result;
    }

    public void startStream() {
        new Thread(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (StreamFetcher.this.threadActive) {
                        Thread.sleep(100L);
                        if (i % 50 == 0) {
                            logger.info("waiting for thread to be finished for stream {}", (Object)StreamFetcher.this.stream.getStreamUrl());
                            i = 0;
                        }
                        ++i;
                    }
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                    Thread.currentThread().interrupt();
                }
                StreamFetcher.this.exceptionInThread = false;
                StreamFetcher.this.thread = new WorkerThread();
                StreamFetcher.this.thread.start();
                logger.info("StartStream called, new thread is started for {}", (Object)StreamFetcher.this.stream.getStreamId());
            }
        }.start();
    }

    public avcodec.AVPacket getAVPacket() {
        if (!this.availableBufferQueue.isEmpty()) {
            return this.availableBufferQueue.poll();
        }
        return new avcodec.AVPacket();
    }

    public boolean isStreamAlive() {
        return System.currentTimeMillis() - this.lastPacketReceivedTime < 3000L;
    }

    public boolean isStopped() {
        return this.thread.isInterrupted();
    }

    public void stopStream() {
        if (this.getThread() != null) {
            logger.warn("stop stream called for {}", (Object)this.stream.getStreamId());
            this.getThread().setStopRequestReceived();
        } else {
            logger.warn("stop stream is called and thread is null {}", (Object)this.stream.getStreamId());
        }
    }

    public boolean isStopRequestReceived() {
        return this.getThread().isStopRequestReceived();
    }

    public WorkerThread getThread() {
        return this.thread;
    }

    public void setThread(WorkerThread thread) {
        this.thread = thread;
    }

    public Broadcast getStream() {
        return this.stream;
    }

    public void restart() {
        this.stopStream();
        new Thread(){

            @Override
            public void run() {
                try {
                    while (StreamFetcher.this.threadActive) {
                        Thread.sleep(100L);
                    }
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                    Thread.currentThread().interrupt();
                }
                StreamFetcher.this.startStream();
            }
        }.start();
    }

    public void setConnectionTimeout(int timeout) {
        this.timeout = timeout * 1000;
    }

    public boolean isExceptionInThread() {
        return this.exceptionInThread;
    }

    public void setThreadActive(boolean threadActive) {
        this.threadActive = threadActive;
    }

    public boolean isThreadActive() {
        return this.threadActive;
    }

    public Result getCameraError() {
        return this.cameraError;
    }

    public void setCameraError(Result cameraError) {
        this.cameraError = cameraError;
    }

    public IScope getScope() {
        return this.scope;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public AntMediaApplicationAdapter getInstance() {
        if (this.appInstance == null) {
            this.appInstance = (AntMediaApplicationAdapter)this.scope.getContext().getApplicationContext().getBean("web.handler");
        }
        return this.appInstance;
    }

    public MuxAdaptor getMuxAdaptor() {
        return this.muxAdaptor;
    }

    public void setMuxAdaptor(MuxAdaptor muxAdaptor) {
        this.muxAdaptor = muxAdaptor;
    }

    public boolean isRestartStream() {
        return this.restartStream;
    }

    public void setRestartStream(boolean restartStream) {
        this.restartStream = restartStream;
    }

    public void setStream(Broadcast stream) {
        this.stream = stream;
    }

    public int getBufferTime() {
        return this.bufferTime;
    }

    public void setBufferTime(int bufferTime) {
        this.bufferTime = bufferTime;
    }

    private AppSettings getAppSettings() {
        if (this.appSettings == null) {
            this.appSettings = (AppSettings)this.scope.getContext().getApplicationContext().getBean("app.settings");
        }
        return this.appSettings;
    }

    public class WorkerThread
    extends Thread
    implements IScheduledJob {
        private static final int PACKET_WRITER_PERIOD_IN_MS = 10;
        private volatile boolean stopRequestReceived = false;
        private volatile boolean streamPublished = false;
        protected AtomicBoolean isJobRunning = new AtomicBoolean(false);
        avformat.AVFormatContext inputFormatContext = null;
        private volatile boolean buffering = false;
        private ConcurrentLinkedQueue<avcodec.AVPacket> bufferQueue = new ConcurrentLinkedQueue();

        @Override
        public void run() {
            StreamFetcher.this.setThreadActive(true);
            long lastPacketTime = 0L;
            long firstPacketTime = 0L;
            long bufferDuration = 0L;
            avcodec.AVPacket pkt = null;
            String packetWriterJobName = null;
            try {
                this.inputFormatContext = new avformat.AVFormatContext(null);
                pkt = avcodec.av_packet_alloc();
                Result result = StreamFetcher.this.prepare(this.inputFormatContext);
                if (result.isSuccess()) {
                    StreamFetcher.this.muxAdaptor = MuxAdaptor.initializeMuxAdaptor(null, (boolean)true, (IScope)StreamFetcher.this.scope);
                    StreamFetcher.this.muxAdaptor.init(StreamFetcher.this.scope, StreamFetcher.this.stream.getStreamId(), false);
                    logger.info("{} stream count in stream {} is {}", new Object[]{StreamFetcher.this.stream.getStreamId(), StreamFetcher.this.stream.getStreamUrl(), this.inputFormatContext.nb_streams()});
                    if (StreamFetcher.this.muxAdaptor.prepareInternal(this.inputFormatContext)) {
                        long currentTime = System.currentTimeMillis();
                        StreamFetcher.this.muxAdaptor.setStartTime(currentTime);
                        StreamFetcher.this.getInstance().startPublish(StreamFetcher.this.stream.getStreamId());
                        if (StreamFetcher.this.bufferTime > 0) {
                            packetWriterJobName = StreamFetcher.this.scheduler.addScheduledJob(10, (IScheduledJob)this);
                        }
                        int bufferLogCounter = 0;
                        while (avformat.av_read_frame((avformat.AVFormatContext)this.inputFormatContext, (avcodec.AVPacket)pkt) >= 0) {
                            this.streamPublished = true;
                            StreamFetcher.this.lastPacketReceivedTime = System.currentTimeMillis();
                            int packetIndex = pkt.stream_index();
                            if (StreamFetcher.this.lastDTS[packetIndex] >= pkt.dts()) {
                                pkt.dts(StreamFetcher.this.lastDTS[packetIndex] + 1L);
                            }
                            ((StreamFetcher)StreamFetcher.this).lastDTS[packetIndex] = pkt.dts();
                            if (pkt.dts() > pkt.pts()) {
                                logger.info("dts ({}) is bigger than pts({})", (Object)pkt.dts(), (Object)pkt.pts());
                                pkt.pts(pkt.dts());
                            }
                            if (StreamFetcher.this.bufferTime > 0) {
                                avcodec.AVPacket packet = StreamFetcher.this.getAVPacket();
                                avcodec.av_packet_ref((avcodec.AVPacket)packet, (avcodec.AVPacket)pkt);
                                this.bufferQueue.add(packet);
                                avcodec.AVPacket pktHead = this.bufferQueue.peek();
                                lastPacketTime = avutil.av_rescale_q((long)pkt.pts(), (avutil.AVRational)this.inputFormatContext.streams(pkt.stream_index()).time_base(), (avutil.AVRational)StreamFetcher.this.avRationalTimeBaseMS);
                                firstPacketTime = avutil.av_rescale_q((long)pktHead.pts(), (avutil.AVRational)this.inputFormatContext.streams(pktHead.stream_index()).time_base(), (avutil.AVRational)StreamFetcher.this.avRationalTimeBaseMS);
                                bufferDuration = lastPacketTime - firstPacketTime;
                                if (bufferDuration > (long)StreamFetcher.this.bufferTime) {
                                    this.buffering = false;
                                }
                                if (++bufferLogCounter % 100 == 0) {
                                    logger.info("Buffer status {}, buffer duration {}ms buffer time {}ms", new Object[]{this.buffering, bufferDuration, StreamFetcher.this.bufferTime});
                                    bufferLogCounter = 0;
                                }
                            } else {
                                StreamFetcher.this.muxAdaptor.writePacket(this.inputFormatContext.streams(pkt.stream_index()), pkt);
                            }
                            avcodec.av_packet_unref((avcodec.AVPacket)pkt);
                            if (!this.stopRequestReceived) continue;
                            logger.warn("Stop request received, breaking the loop for {} ", (Object)StreamFetcher.this.stream.getStreamId());
                            break;
                        }
                        logger.info("Leaving the loop for {}", (Object)StreamFetcher.this.stream.getStreamId());
                    }
                } else {
                    logger.debug("Prepare for {} returned false", (Object)StreamFetcher.this.stream.getName());
                }
                StreamFetcher.this.setCameraError(result);
            }
            catch (Exception | OutOfMemoryError e) {
                logger.error(e.getMessage());
                StreamFetcher.this.exceptionInThread = true;
            }
            if (packetWriterJobName != null) {
                logger.info("Removing packet writer job {}", packetWriterJobName);
                StreamFetcher.this.scheduler.removeScheduledJob(packetWriterJobName);
            }
            this.writeAllBufferedPackets();
            if (StreamFetcher.this.muxAdaptor != null) {
                logger.info("Writing trailer in Muxadaptor {}", (Object)StreamFetcher.this.stream.getStreamId());
                StreamFetcher.this.muxAdaptor.writeTrailer(this.inputFormatContext);
                StreamFetcher.this.muxAdaptor = null;
            }
            if (pkt != null) {
                avcodec.av_packet_free((avcodec.AVPacket)pkt);
            }
            if (this.inputFormatContext != null) {
                try {
                    avformat.avformat_close_input((avformat.AVFormatContext)this.inputFormatContext);
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                }
                this.inputFormatContext = null;
            }
            if (this.streamPublished) {
                StreamFetcher.this.getInstance().closeBroadcast(StreamFetcher.this.stream.getStreamId());
                this.streamPublished = false;
            }
            StreamFetcher.this.setThreadActive(false);
            if (!this.stopRequestReceived && StreamFetcher.this.restartStream) {
                StreamFetcher.this.thread = new WorkerThread();
                StreamFetcher.this.thread.start();
            }
            logger.debug("Leaving thread for {}", (Object)StreamFetcher.this.stream.getStreamUrl());
        }

        private void writeAllBufferedPackets() {
            avcodec.AVPacket pkt;
            while (!this.bufferQueue.isEmpty()) {
                pkt = this.bufferQueue.poll();
                StreamFetcher.this.muxAdaptor.writePacket(this.inputFormatContext.streams(pkt.stream_index()), pkt);
                avcodec.av_packet_unref((avcodec.AVPacket)pkt);
            }
            while ((pkt = this.bufferQueue.poll()) != null) {
                pkt.close();
            }
        }

        public void setStopRequestReceived() {
            logger.warn("inside of setStopRequestReceived for {}", (Object)StreamFetcher.this.stream.getStreamId());
            this.stopRequestReceived = true;
        }

        public boolean isStopRequestReceived() {
            return this.stopRequestReceived;
        }

        public void execute(ISchedulingService service) throws CloneNotSupportedException {
            if (this.isJobRunning.compareAndSet(false, true)) {
                if (!this.buffering) {
                    avcodec.AVPacket pkt = this.bufferQueue.poll();
                    if (pkt != null) {
                        StreamFetcher.this.muxAdaptor.writePacket(this.inputFormatContext.streams(pkt.stream_index()), pkt);
                        avcodec.av_packet_unref((avcodec.AVPacket)pkt);
                        StreamFetcher.this.availableBufferQueue.offer(pkt);
                    } else {
                        this.buffering = true;
                    }
                }
                this.isJobRunning.compareAndSet(true, false);
            }
        }
    }
}

