/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtc;

import io.antmedia.muxer.Muxer;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.antmedia.webrtc.api.IWebRTCClient;
import io.antmedia.webrtc.api.IWebRTCMuxer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.avcodec;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;
import org.red5.server.api.scope.IScope;
import org.red5.server.scheduling.QuartzSchedulingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRTCMuxer
extends Muxer
implements IWebRTCMuxer {
    private IWebRTCAdaptor webRTCAdaptor;
    private Queue<IWebRTCClient> webRTCClientList = new ConcurrentLinkedQueue<IWebRTCClient>();
    private String streamId;
    private int width;
    private int height;
    private int videoBitrate;
    private int audioBitrate;
    protected int videoStreamIndex = -1;
    protected int audioStreamIndex = -1;
    private AtomicInteger clientCount = new AtomicInteger(0);
    private boolean videoConfSent = false;
    private byte[] sps;
    private byte[] pps;
    private byte[] keyFrame;
    private byte[] videoConf;
    private boolean isPrepareIOCalled = false;
    private avutil.AVRational videoTimebase;
    private avutil.AVRational audioTimebase;
    protected static Logger logger = LoggerFactory.getLogger(WebRTCMuxer.class);
    private avutil.AVRational timeBaseForMS;
    private long totalSendVideoPacketCallInterval;
    private long lastSendVideoPacketCallTime;
    private long videoPacketCount;
    private long lastSendAudioPacketCallTime;
    private long totalSendAudioPacketCallInterval;
    private int audioPacketCount;
    private long totalVideoProcessingTime;
    private long totalAudioProcessingTime;
    private volatile boolean isStopped = false;

    public WebRTCMuxer(QuartzSchedulingService scheduler, IWebRTCAdaptor webRTCAdaptor) {
        super(scheduler);
        this.webRTCAdaptor = webRTCAdaptor;
        this.timeBaseForMS = new avutil.AVRational();
        this.timeBaseForMS.num(1);
        this.timeBaseForMS.den(1000);
    }

    public void init(IScope scope, String name, int resolutionHeight) {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.height = resolutionHeight;
            this.streamId = name;
        }
    }

    @Override
    public void setWebRTCAdaptor(IWebRTCAdaptor webRTCAdaptor) {
        this.webRTCAdaptor = webRTCAdaptor;
    }

    @Override
    public void registerToAdaptor() {
        this.webRTCAdaptor.registerMuxer(this.streamId, this);
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public int getVideoHeight() {
        return this.height;
    }

    @Override
    public int getVideoWidth() {
        return this.width;
    }

    @Override
    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    @Override
    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    @Override
    public void registerWebRTCClient(IWebRTCClient webRTCClient) {
        this.webRTCClientList.add(webRTCClient);
        this.clientCount.incrementAndGet();
        webRTCClient.setWebRTCMuxer(this);
        webRTCClient.setVideoResolution(this.width, this.height);
        if (this.videoConfSent) {
            webRTCClient.sendVideoConfPacket(this.videoConf, this.keyFrame, 0L);
        }
    }

    @Override
    public boolean unRegisterWebRTCClient(IWebRTCClient webRTCClient) {
        boolean result = this.webRTCClientList.remove(webRTCClient);
        if (result) {
            this.clientCount.decrementAndGet();
        }
        return result;
    }

    @Override
    public void sendVideoPacket(byte[] videoPacket, boolean isKeyFrame, long timestamp) {
        for (IWebRTCClient rtcClient : this.webRTCClientList) {
            rtcClient.sendVideoPacket(videoPacket, isKeyFrame, timestamp);
        }
    }

    public void sendVideoConfPacket(byte[] videoPacket, long timestamp) {
        for (IWebRTCClient rtcClient : this.webRTCClientList) {
            rtcClient.sendVideoConfPacket(this.videoConf, videoPacket, timestamp);
        }
    }

    @Override
    public void sendAudioPacket(byte[] audioPacket, long timestamp) {
        for (IWebRTCClient rtcClient : this.webRTCClientList) {
            rtcClient.sendAudioPacket(audioPacket, timestamp);
        }
    }

    public boolean prepare(avformat.AVFormatContext inputFormatContext) {
        return true;
    }

    public boolean addStream(avcodec.AVCodec codec, avcodec.AVCodecContext codecContext, int streamIndex) {
        if (codecContext.codec_type() == 0) {
            this.videoStreamIndex = streamIndex;
            this.width = codecContext.width();
            this.height = codecContext.height();
            this.videoBitrate = (int)codecContext.bit_rate();
            this.videoTimebase = codecContext.time_base();
        } else if (codecContext.codec_type() == 1) {
            this.audioStreamIndex = streamIndex;
            this.audioBitrate = (int)codecContext.bit_rate();
            this.audioTimebase = codecContext.time_base();
        }
        return true;
    }

    public synchronized boolean prepareIO() {
        if (!this.isPrepareIOCalled) {
            this.isPrepareIOCalled = true;
            this.registerToAdaptor();
        }
        return true;
    }

    public synchronized void writeTrailer() {
        if (this.isStopped) {
            return;
        }
        this.isStopped = true;
        this.webRTCAdaptor.unRegisterMuxer(this.streamId, this);
        if (this.videoPacketCount > 0L) {
            logger.info("Average write packet call interval for video {} average video processing time {} video packet count: {} ", new Object[]{this.totalSendVideoPacketCallInterval / this.videoPacketCount, this.totalVideoProcessingTime / this.videoPacketCount, this.videoPacketCount});
        }
        if (this.audioPacketCount > 0) {
            logger.info("Average write packet call interval: {} average audio processing time: {}  audio packet count: {}", new Object[]{this.totalSendAudioPacketCallInterval / (long)this.audioPacketCount, this.totalAudioProcessingTime / (long)this.audioPacketCount, this.audioPacketCount});
        }
        int i = 0;
        for (IWebRTCClient iWebRTCClient : this.webRTCClientList) {
            logger.info("WebRTC Client {} video frame average sent period: {}  audio frame average period: {} video thread enter interval: {}  audio thread enter interval: {}", new Object[]{i, iWebRTCClient.getVideoFrameSentPeriod(), iWebRTCClient.getAudioFrameSentPeriod(), iWebRTCClient.getVideoThreadCheckInterval(), iWebRTCClient.getAudioThreadCheckInterval()});
            iWebRTCClient.stop();
            ++i;
        }
    }

    public void writePacket(avcodec.AVPacket avpacket, avformat.AVStream inStream) {
    }

    public int findNALStartCode(byte[] data, int offset) {
        int i;
        for (i = offset; i < data.length; ++i) {
            if (data[i] != 0 || data[i + 1] != 0 || data[i + 2] != 1 && (data[i + 2] != 0 || data[i + 3] != 1)) continue;
            return i;
        }
        if (i == data.length) {
            return i;
        }
        return -1;
    }

    public boolean parseVideoConfData(byte[] data) {
        int nalEndIndex;
        int nalStartIndex = this.findNALStartCode(data, 0);
        while ((nalEndIndex = this.findNALStartCode(data, nalStartIndex + 3)) != -1) {
            int nalLength = 0;
            int startCodeLength = 3;
            if (data[nalStartIndex + 3] == 1) {
                startCodeLength = 4;
            }
            nalLength = nalEndIndex - nalStartIndex - startCodeLength;
            byte nalType = (byte)(data[nalStartIndex + startCodeLength] & 0x1F);
            if (nalType == 7) {
                this.sps = new byte[nalLength + startCodeLength];
                System.arraycopy(data, nalStartIndex, this.sps, 0, nalLength + startCodeLength);
            } else if (nalType == 8) {
                this.pps = new byte[nalLength + startCodeLength];
                System.arraycopy(data, nalStartIndex, this.pps, 0, nalLength + startCodeLength);
            } else if (nalType == 5) {
                this.keyFrame = new byte[nalLength + startCodeLength];
                System.arraycopy(data, nalStartIndex, this.keyFrame, 0, nalLength + startCodeLength);
            }
            nalStartIndex = nalEndIndex;
        }
        return this.sps != null && this.pps != null && this.keyFrame != null;
    }

    public synchronized void writePacket(avcodec.AVPacket pkt) {
        long now = System.currentTimeMillis();
        if (pkt.stream_index() == this.videoStreamIndex) {
            long pts = avutil.av_rescale_q((long)pkt.pts(), (avutil.AVRational)this.videoTimebase, (avutil.AVRational)this.timeBaseForMS);
            BytePointer data = pkt.data();
            byte[] byteArray = new byte[pkt.size()];
            data.get(byteArray, 0, byteArray.length);
            boolean isKeyFrame = false;
            if ((pkt.flags() & 1) == 1) {
                isKeyFrame = true;
                this.keyFrame = byteArray;
            }
            if (!this.videoConfSent) {
                this.videoConfSent = true;
                if (this.videoConf == null) {
                    this.parseVideoConfData(byteArray);
                    this.videoConf = new byte[this.sps.length + this.pps.length];
                    System.arraycopy(this.sps, 0, this.videoConf, 0, this.sps.length);
                    System.arraycopy(this.pps, 0, this.videoConf, this.sps.length, this.pps.length);
                    this.sendVideoConfPacket(this.keyFrame, pts);
                } else {
                    this.sendVideoConfPacket(byteArray, pts);
                }
            } else {
                this.sendVideoPacket(byteArray, isKeyFrame, pts);
            }
            this.totalSendVideoPacketCallInterval += this.lastSendVideoPacketCallTime != 0L ? now - this.lastSendVideoPacketCallTime : 0L;
            ++this.videoPacketCount;
            this.totalVideoProcessingTime += System.currentTimeMillis() - now;
            this.lastSendVideoPacketCallTime = now;
        } else if (pkt.stream_index() == this.audioStreamIndex) {
            long pts = avutil.av_rescale_q((long)pkt.pts(), (avutil.AVRational)this.audioTimebase, (avutil.AVRational)this.timeBaseForMS);
            BytePointer data = pkt.data();
            byte[] byteArray = new byte[pkt.size()];
            data.get(byteArray, 0, byteArray.length);
            this.sendAudioPacket(byteArray, pts);
            this.totalSendAudioPacketCallInterval += this.lastSendAudioPacketCallTime != 0L ? now - this.lastSendAudioPacketCallTime : 0L;
            ++this.audioPacketCount;
            this.totalAudioProcessingTime += System.currentTimeMillis() - now;
            this.lastSendAudioPacketCallTime = now;
        }
    }

    public boolean isExtradata_parsed() {
        return this.videoConfSent;
    }

    public void setExtradata_parsed(boolean extradata_parsed) {
        this.videoConfSent = extradata_parsed;
    }

    public byte[] getKeyFrame() {
        return this.keyFrame;
    }

    public void setKeyFrame(byte[] keyFrame) {
        this.keyFrame = keyFrame;
    }

    public byte[] getPps() {
        return this.pps;
    }

    public void setPps(byte[] pps) {
        this.pps = pps;
    }

    public byte[] getSps() {
        return this.sps;
    }

    public void setSps(byte[] sps) {
        this.sps = sps;
    }

    @Override
    public boolean contains(IWebRTCClient webRTCClient) {
        return this.webRTCClientList.contains(webRTCClient);
    }

    public void setVideoResolution(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setBitrate(int videoBitrate, int audioBitrate) {
        this.videoBitrate = videoBitrate;
        this.audioBitrate = audioBitrate;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setVideoBitrate(int videoBitrate) {
        this.videoBitrate = videoBitrate;
    }

    public avutil.AVRational getVideoTimebase() {
        return this.videoTimebase;
    }

    public void setVideoTimebase(avutil.AVRational videoTimebase) {
        this.videoTimebase = videoTimebase;
    }

    public void setAudioBitrate(int audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public avutil.AVRational getAudioTimebase() {
        return this.audioTimebase;
    }

    public void setAudioTimebase(avutil.AVRational audioTimebase) {
        this.audioTimebase = audioTimebase;
    }

    public void setVideoConfData(byte[] videoConfData) {
        this.videoConf = videoConfData;
    }

    @Override
    public Queue<IWebRTCClient> getClientList() {
        return this.webRTCClientList;
    }

    @Override
    public int getClientCount() {
        return this.clientCount.intValue();
    }

    public void setVideoConf(byte[] videoConf) {
        this.videoConf = videoConf;
    }
}

