/*
 * Decompiled with CFR 0.152.
 */
package com.antstreaming.rtsp;

import com.antstreaming.rtsp.RtspConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.red5.server.api.Red5;
import org.red5.server.net.IConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class RtspConnectionManager
implements IConnectionManager<RtspConnection>,
ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(RtspConnectionManager.class);
    protected ConcurrentMap<String, RtspConnection> connMap = new ConcurrentHashMap<String, RtspConnection>();
    private static RtspConnectionManager instance;
    private static ApplicationContext applicationContext;
    protected AtomicInteger conns = new AtomicInteger();
    private ThreadPoolTaskScheduler taskScheduler;

    public static RtspConnectionManager getInstance() {
        if (instance == null) {
            logger.trace("Connection manager instance does not exist");
            if (applicationContext != null && applicationContext.containsBean("rtspConnectionManager")) {
                logger.trace("Connection manager bean exists");
                instance = (RtspConnectionManager)applicationContext.getBean("rtspConnectionManager");
            } else {
                logger.trace("Connection manager bean doesnt exist, creating new instance");
                instance = new RtspConnectionManager();
            }
        }
        return instance;
    }

    public Collection<RtspConnection> getAllConnections() {
        ArrayList<RtspConnection> list = new ArrayList<RtspConnection>(this.connMap.size());
        list.addAll(this.connMap.values());
        return list;
    }

    public Collection<RtspConnection> removeConnections() {
        ArrayList<RtspConnection> list = new ArrayList<RtspConnection>(this.connMap.size());
        list.addAll(this.connMap.values());
        this.connMap.clear();
        this.conns.set(0);
        return list;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        RtspConnectionManager.applicationContext = applicationContext;
        logger.debug("setting application context " + applicationContext.getApplicationName());
    }

    public ThreadPoolTaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public void setTaskScheduler(ThreadPoolTaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
        logger.debug("setting task scheduler");
    }

    public RtspConnection getConnection(int clientId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setConnection(RtspConnection conn) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public RtspConnection getConnectionBySessionId(String sessionId) {
        logger.trace("Getting connection by session id: {}", (Object)sessionId);
        RtspConnection conn = (RtspConnection)this.connMap.get(sessionId);
        if (conn == null && logger.isDebugEnabled()) {
            logger.debug("Connection not found for {}", (Object)sessionId);
            if (logger.isTraceEnabled()) {
                logger.trace("Connections ({}) {}", (Object)this.connMap.size(), this.connMap.values());
            }
        }
        return conn;
    }

    public RtspConnection createConnection(Class<?> connCls) {
        RtspConnection conn = null;
        try {
            conn = (RtspConnection)connCls.newInstance();
            this.connMap.put(conn.getSessionId(), conn);
            logger.trace("Connections: {}", (Object)this.conns.incrementAndGet());
            logger.debug("applicationContext.containsBean(rtmpScheduler) : " + applicationContext.containsBean("rtmpScheduler"));
            logger.debug("connection scheduler : " + conn.getScheduler() + " manager scheduler:" + this.getTaskScheduler());
            conn.setScheduler(this.getTaskScheduler());
            logger.trace("Connection created: {}", (Object)conn);
        }
        catch (Exception ex) {
            logger.warn("Exception creating connection", (Throwable)ex);
        }
        return conn;
    }

    public RtspConnection createConnection(Class<?> connCls, String sessionId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public RtspConnection removeConnection(int clientId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public RtspConnection removeConnection(String sessionId) {
        RtspConnection conn;
        logger.trace("Removing connection with session id: {}", (Object)sessionId);
        if (logger.isTraceEnabled()) {
            logger.trace("Connections ({}) at pre-remove: {}", (Object)this.connMap.size(), this.connMap.values());
        }
        if ((conn = (RtspConnection)this.connMap.remove(sessionId)) != null) {
            logger.trace("Connections: {}", (Object)this.conns.decrementAndGet());
            Red5.setConnectionLocal(null);
        }
        return conn;
    }
}

