/*
 * Decompiled with CFR 0.152.
 */
package com.antstreaming.rtsp;

import com.antstreaming.rtsp.protocol.MessageCodecFactory;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.red5.server.jmx.mxbeans.RTMPMinaTransportMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtspMinaTransport
implements RTMPMinaTransportMXBean {
    private static final Logger log = LoggerFactory.getLogger(RtspMinaTransport.class);
    private NioSocketAcceptor acceptor;
    private IoHandler rtspMessageHandler;
    protected Set<String> addresses = new HashSet<String>();
    private static final int MIN_READ_BUFFER_SIZE = 4096;
    protected IoHandlerAdapter ioHandler;

    public void setIoHandler(IoHandlerAdapter rtmpIOHandler) {
        this.ioHandler = rtmpIOHandler;
        log.info("setting IoHandler");
    }

    public void setIoThreads(int ioThreads) {
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
    }

    public void setUseHeapBuffers(boolean useHeapBuffers) {
    }

    public String getAddress() {
        return null;
    }

    public String getStatistics() {
        return null;
    }

    public void setAddress(String address) {
        this.addresses.add(address);
        log.info("RTSP will be bound to {}", (Object)address);
    }

    public void setAddresses(List<String> addrs) {
        for (String addr : addrs) {
            this.addresses.add(addr);
        }
        log.info("RTSP will be bound to {}", this.addresses);
    }

    public void start() throws Exception {
        this.acceptor = new NioSocketAcceptor(Runtime.getRuntime().availableProcessors() + 1);
        this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new MessageCodecFactory()));
        this.acceptor.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)Executors.newCachedThreadPool()));
        this.acceptor.setHandler((IoHandler)this.ioHandler);
        this.acceptor.getSessionConfig().setMinReadBufferSize(4096);
        HashSet<InetSocketAddress> socketAddresses = new HashSet<InetSocketAddress>();
        for (String addr : this.addresses) {
            if (addr.indexOf(58) != -1) {
                String[] parts = addr.split(":");
                socketAddresses.add(new InetSocketAddress(parts[0], (int)Integer.valueOf(parts[1])));
                continue;
            }
            socketAddresses.add(new InetSocketAddress(addr, 5554));
        }
        log.info("RTSP Binding to {}", (Object)((Object)socketAddresses).toString());
        this.acceptor.bind(socketAddresses);
    }

    public void stop() {
        this.acceptor.unbind();
    }
}

