/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.ipcamera;

import io.antmedia.ipcamera.IOnvifCamera;
import io.antmedia.ipcamera.onvif.soap.OnvifDevice;
import io.antmedia.ipcamera.onvif.soap.devices.PtzDevices;
import java.net.ConnectException;
import java.sql.Date;
import java.sql.Time;
import java.util.List;
import javax.xml.soap.SOAPException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.onvif.ver10.schema.AutoFocusMode;
import org.onvif.ver10.schema.DateTime;
import org.onvif.ver10.schema.FocusConfiguration20;
import org.onvif.ver10.schema.ImagingSettings20;
import org.onvif.ver10.schema.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnvifCamera
implements IOnvifCamera {
    OnvifDevice nvt;
    PtzDevices ptzDevices;
    List<Profile> profiles;
    String profileToken;
    protected static Logger logger = LoggerFactory.getLogger(OnvifCamera.class);

    @Override
    public boolean connect(String address, String username, String password) {
        boolean result = false;
        try {
            this.nvt = new OnvifDevice(address, username, password);
            this.nvt.getDevices().getCapabilities().getDevice();
            this.nvt.getDevices().getServices(false);
            this.ptzDevices = this.nvt.getPtz();
            this.profiles = this.nvt.getDevices().getProfiles();
            this.profileToken = this.profiles.get(0).getToken();
            result = true;
        }
        catch (ConnectException | SOAPException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            result = false;
        }
        return result;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public String getRTSPStreamURI() {
        String PTSPURL = null;
        try {
            PTSPURL = this.nvt.getMedia().getRTSPStreamUri(this.profileToken);
        }
        catch (NullPointerException | ConnectException | SOAPException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return PTSPURL;
    }

    @Override
    public String getTCPStreamURI() {
        String PTSPURL = null;
        try {
            PTSPURL = this.nvt.getMedia().getTCPStreamUri(this.profileToken);
        }
        catch (ConnectException | SOAPException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return PTSPURL;
    }

    @Override
    public boolean MoveUp() {
        this.ptzDevices.relativeMove(this.profileToken, 0.0f, 0.1f, 0.0f);
        try {
            Thread.sleep(500L);
            this.ptzDevices.stopMove(this.profileToken);
        }
        catch (InterruptedException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
        return true;
    }

    @Override
    public boolean MoveDown() {
        this.ptzDevices.relativeMove(this.profileToken, 0.0f, -0.1f, 0.0f);
        try {
            Thread.sleep(500L);
            this.ptzDevices.stopMove(this.profileToken);
        }
        catch (InterruptedException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
        return true;
    }

    @Override
    public boolean MoveRight() {
        this.ptzDevices.relativeMove(this.profileToken, 1.0f, 0.0f, 0.0f);
        try {
            Thread.sleep(500L);
            this.ptzDevices.stopMove(this.profileToken);
        }
        catch (InterruptedException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
        return true;
    }

    @Override
    public boolean MoveLeft() {
        this.ptzDevices.relativeMove(this.profileToken, -1.0f, 0.0f, 0.0f);
        try {
            Thread.sleep(500L);
            this.ptzDevices.stopMove(this.profileToken);
        }
        catch (InterruptedException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
        return true;
    }

    @Override
    public boolean MoveStop() {
        this.ptzDevices.stopMove(this.profileToken);
        return true;
    }

    @Override
    public String getAlarms() {
        return null;
    }

    @Override
    public boolean enableDhcp() {
        return false;
    }

    @Override
    public boolean disableDhcp(String ipaddress, String netmask, String gateway) {
        return false;
    }

    @Override
    public java.util.Date getTime() {
        return this.nvt.getDate();
    }

    public boolean setDateTime(org.onvif.ver10.schema.Date date, org.onvif.ver10.schema.Time time) {
        DateTime dt = new DateTime();
        dt.setDate(date);
        dt.setTime(time);
        return true;
    }

    @Override
    public boolean setBrightness(float brightness) {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        image_set.setBrightness(Float.valueOf(brightness));
        return true;
    }

    @Override
    public float getBrightness() {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        return image_set.getBrightness().floatValue();
    }

    @Override
    public boolean setSaturation(float saturation) {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        image_set.setColorSaturation(Float.valueOf(saturation));
        return true;
    }

    @Override
    public float getSaturation() {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        return image_set.getColorSaturation().floatValue();
    }

    @Override
    public boolean setContrast(float contrast) {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        image_set.setContrast(Float.valueOf(contrast));
        return true;
    }

    @Override
    public float getContrast() {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        return image_set.getContrast().floatValue();
    }

    @Override
    public boolean setSharpness(float sharpness) {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        image_set.setSharpness(Float.valueOf(sharpness));
        return true;
    }

    @Override
    public float getSharpness() {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        return image_set.getSharpness().floatValue();
    }

    @Override
    public boolean setFocusMode(boolean auto) {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        FocusConfiguration20 focus = image_set.getFocus();
        AutoFocusMode foc_mode = auto ? AutoFocusMode.fromValue((String)"AUTO") : AutoFocusMode.fromValue((String)"MANUAL");
        focus.setAutoFocusMode(foc_mode);
        return true;
    }

    @Override
    public boolean isFocusModeAuto() {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        FocusConfiguration20 focus = image_set.getFocus();
        return focus.getAutoFocusMode().value().equals("AUTO");
    }

    @Override
    public boolean setDateTime(Date date, Time time) {
        return false;
    }
}

