/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.ipcamera.onvifdiscovery;

import io.antmedia.ipcamera.onvifdiscovery.ProbeReceiverThread;
import io.antmedia.ipcamera.onvifdiscovery.ProbeSenderThread;
import io.antmedia.ipcamera.onvifdiscovery.URLComparator;
import java.io.File;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;

public class DeviceDiscovery {
    public static String WS_DISCOVERY_SOAP_VERSION = "SOAP 1.2 Protocol";
    public static String WS_DISCOVERY_CONTENT_TYPE = "application/soap+xml";
    public static int WS_DISCOVERY_TIMEOUT = 4000;
    public static int WS_DISCOVERY_PORT = 3702;
    private static final Random random = new SecureRandom();

    public static Collection<URL> discoverWsDevicesAsUrls(boolean useIpv4) {
        return DeviceDiscovery.discoverWsDevicesAsUrls("", "", useIpv4);
    }

    public static Collection<URL> discoverWsDevicesAsUrls(String regexpProtocol, String regexpPath, boolean useIpv4, ArrayList<String> targetAddresses) {
        String probeMsgTemplate;
        try {
            File probeMsgFile = new File(Thread.currentThread().getContextClassLoader().getResource("probe-template.xml").toURI());
            probeMsgTemplate = FileUtils.readFileToString((File)probeMsgFile, (String)"UTF-8");
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
        TreeSet<URL> urls = new TreeSet<URL>(new URLComparator());
        for (String key : DeviceDiscovery.discoverWsDevices(probeMsgTemplate, useIpv4, targetAddresses)) {
            try {
                URL url = new URL(key);
                boolean ok = true;
                if (!regexpProtocol.isEmpty() && !url.getProtocol().matches(regexpProtocol)) {
                    ok = false;
                }
                if (!regexpPath.isEmpty() && !url.getPath().matches(regexpPath)) {
                    ok = false;
                }
                if (!ok) continue;
                urls.add(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return urls;
    }

    public static Collection<URL> discoverWsDevicesAsUrls(String regexpProtocol, String regexpPath, boolean useIpv4) {
        return DeviceDiscovery.discoverWsDevicesAsUrls(regexpProtocol, regexpPath, useIpv4);
    }

    /*
     * Unable to fully structure code
     */
    public static Collection<String> discoverWsDevices(String probeMsgTemplate, boolean useIpv4, ArrayList<String> targetAddresses) {
        addresses = new ConcurrentSkipListSet<String>();
        serverStarted = new CountDownLatch(1);
        serverFinished = new CountDownLatch(1);
        addressList = new ArrayList<InetAddress>();
        if (targetAddresses != null && targetAddresses.size() > 0) {
            for (String addressStr : targetAddresses) {
                try {
                    addr = InetAddress.getByName(addressStr);
                    addressList.add(addr);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                interfaces = NetworkInterface.getNetworkInterfaces();
                if (interfaces == null) ** GOTO lbl32
                while (interfaces.hasMoreElements()) {
                    anInterface = interfaces.nextElement();
                    interfaceAddresses = anInterface.getInterfaceAddresses();
                    var10_14 = interfaceAddresses.iterator();
                    while (var10_14.hasNext()) {
                        address = (InterfaceAddress)var10_14.next();
                        addressList.add(address.getAddress());
                    }
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
lbl32:
        // 4 sources

        executorService = Executors.newCachedThreadPool();
        port = 63454;
        for (InetAddress address : addressList) {
            if (useIpv4 && address instanceof Inet6Address || !useIpv4 && address instanceof Inet4Address) continue;
            try {
                socket = new DatagramSocket(port);
                ++port;
                probeReceiver = new ProbeReceiverThread(addresses, serverStarted, socket, serverFinished);
                probeSender = new ProbeSenderThread(address, socket, probeMsgTemplate, serverStarted, serverFinished, probeReceiver);
                executorService.submit(probeSender);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(DeviceDiscovery.WS_DISCOVERY_TIMEOUT + 2000, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        return addresses;
    }
}

