/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtc.adaptor;

import io.antmedia.recorder.FFmpegFrameRecorder;
import io.antmedia.recorder.Frame;
import io.antmedia.recorder.FrameRecorder;
import io.antmedia.webrtc.adaptor.Adaptor;
import io.antmedia.websocket.WebSocketCommunityHandler;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.AudioSink;
import org.webrtc.AudioTrack;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SessionDescription;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoTrack;

public class RTMPAdaptor
extends Adaptor {
    FFmpegFrameRecorder recorder;
    protected long startTime;
    private static Logger logger = LoggerFactory.getLogger(RTMPAdaptor.class);
    private ExecutorService videoEncoderExecutor;
    private ExecutorService audioEncoderExecutor;
    private volatile boolean isStopped = false;
    private ExecutorService signallingExecutor;
    private boolean enableAudio = false;
    private int audioFrameCount = 0;
    private boolean started = false;
    public static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";

    public RTMPAdaptor(FFmpegFrameRecorder recorder, WebSocketCommunityHandler webSocketHandler) {
        super(webSocketHandler);
        this.recorder = recorder;
        this.setSdpMediaConstraints(new MediaConstraints());
        this.getSdpMediaConstraints().mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        this.getSdpMediaConstraints().mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
    }

    public PeerConnectionFactory createPeerConnectionFactory() {
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        options.networkIgnoreMask = 0;
        return new PeerConnectionFactory(options);
    }

    @Override
    public void start() {
        this.videoEncoderExecutor = Executors.newSingleThreadExecutor();
        this.audioEncoderExecutor = Executors.newSingleThreadExecutor();
        this.signallingExecutor = Executors.newSingleThreadExecutor();
        this.signallingExecutor.execute(() -> {
            ArrayList<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
            iceServers.add(new PeerConnection.IceServer("stun:stun.l.google.com:19302"));
            PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
            MediaConstraints pcConstraints = new MediaConstraints();
            pcConstraints.optional.add(new MediaConstraints.KeyValuePair(DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, "true"));
            this.peerConnectionFactory = this.createPeerConnectionFactory();
            this.peerConnection = this.peerConnectionFactory.createPeerConnection(rtcConfig, pcConstraints, (PeerConnection.Observer)this);
            this.webSocketCommunityHandler.sendStartMessage(this.getStreamId(), this.getSession());
            this.started = true;
        });
    }

    @Override
    public void stop() {
        if (this.isStopped) {
            return;
        }
        this.isStopped = true;
        this.signallingExecutor.execute(() -> {
            this.webSocketCommunityHandler.sendPublishFinishedMessage(this.getStreamId(), this.getSession());
            this.audioEncoderExecutor.shutdownNow();
            this.videoEncoderExecutor.shutdownNow();
            try {
                this.videoEncoderExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e1));
                Thread.currentThread().interrupt();
            }
            try {
                if (this.peerConnection != null) {
                    this.peerConnection.close();
                    this.recorder.stop();
                    this.peerConnection.dispose();
                    this.peerConnectionFactory.dispose();
                    this.peerConnection = null;
                }
            }
            catch (FrameRecorder.Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
        this.signallingExecutor.shutdown();
    }

    public ExecutorService getSignallingExecutor() {
        return this.signallingExecutor;
    }

    @Override
    public void onAddStream(MediaStream stream) {
        VideoTrack videoTrack;
        AudioTrack audioTrack;
        log.warn("onAddStream for stream: {}", (Object)this.getStreamId());
        if (!stream.getAudioTracks().isEmpty() && (audioTrack = stream.getAudioTracks().getFirst()) != null) {
            this.enableAudio = true;
            audioTrack.addSink(new AudioSink(){

                @Override
                public void onData(byte[] audio_data, int bits_per_sample, int sample_rate, int number_of_channels, int number_of_frames) {
                    ByteBuffer tempAudioBuffer = ByteBuffer.wrap(audio_data);
                    if (RTMPAdaptor.this.startTime == 0L) {
                        RTMPAdaptor.this.startTime = System.currentTimeMillis();
                    }
                    if (RTMPAdaptor.this.audioEncoderExecutor == null || RTMPAdaptor.this.audioEncoderExecutor.isShutdown()) {
                        return;
                    }
                    if (bits_per_sample == 16) {
                        RTMPAdaptor.this.audioFrameCount++;
                        RTMPAdaptor.this.audioEncoderExecutor.execute(() -> {
                            short[] data = new short[number_of_frames * number_of_channels];
                            tempAudioBuffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(data, 0, data.length);
                            ShortBuffer audioBuffer = ShortBuffer.wrap(data);
                            try {
                                boolean result = RTMPAdaptor.this.recorder.recordSamples(sample_rate, number_of_channels, new Buffer[]{audioBuffer});
                                if (!result) {
                                    logger.info("could not audio sample for stream Id {}", (Object)RTMPAdaptor.this.getStreamId());
                                }
                            }
                            catch (FrameRecorder.Exception e) {
                                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                            }
                        });
                    }
                }
            });
        }
        if (!stream.getVideoTracks().isEmpty() && (videoTrack = stream.getVideoTracks().getFirst()) != null) {
            videoTrack.addRenderer(new VideoRenderer(new VideoRenderer.Callbacks(){
                private int frameCount;
                private int dropFrameCount = 0;

                @Override
                public void renderFrame(VideoRenderer.I420Frame frame) {
                    if (RTMPAdaptor.this.startTime == 0L) {
                        RTMPAdaptor.this.startTime = System.currentTimeMillis();
                    }
                    if (RTMPAdaptor.this.videoEncoderExecutor == null || RTMPAdaptor.this.videoEncoderExecutor.isShutdown()) {
                        VideoRenderer.renderFrameDone(frame);
                        return;
                    }
                    ++this.frameCount;
                    RTMPAdaptor.this.videoEncoderExecutor.execute(() -> {
                        long pts;
                        if (RTMPAdaptor.this.enableAudio) {
                            pts = (long)RTMPAdaptor.this.audioFrameCount * 10L;
                            logger.trace("audio frame count: {}", (Object)RTMPAdaptor.this.audioFrameCount);
                        } else {
                            pts = (System.currentTimeMillis() - RTMPAdaptor.this.startTime) * 1000L;
                        }
                        int frameNumber = (int)((double)pts * RTMPAdaptor.this.recorder.getFrameRate() / 1000.0);
                        if (frameNumber > RTMPAdaptor.this.recorder.getFrameNumber()) {
                            RTMPAdaptor.this.recorder.setFrameNumber(frameNumber);
                            Frame frameCV = new Frame(frame.width, frame.height, 8, 2);
                            ((ByteBuffer)frameCV.image[0].position(0)).put(frame.yuvPlanes[0]);
                            ((ByteBuffer)frameCV.image[0]).put(frame.yuvPlanes[1]);
                            ((ByteBuffer)frameCV.image[0]).put(frame.yuvPlanes[2]);
                            try {
                                RTMPAdaptor.this.recorder.recordImage(frameCV.imageWidth, frameCV.imageHeight, frameCV.imageDepth, frameCV.imageChannels, frameCV.imageStride, 0, frameCV.image);
                            }
                            catch (FrameRecorder.Exception e) {
                                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                            }
                        } else {
                            ++this.dropFrameCount;
                            logger.debug("dropping video, total drop count: {}", (Object)this.dropFrameCount);
                        }
                        VideoRenderer.renderFrameDone(frame);
                    });
                }
            }));
        }
        this.webSocketCommunityHandler.sendPublishStartedMessage(this.getStreamId(), this.getSession());
    }

    @Override
    public void onSetSuccess() {
        this.peerConnection.createAnswer(this, this.getSdpMediaConstraints());
    }

    public void setRemoteDescription(final SessionDescription sdp) {
        this.signallingExecutor.execute(new Runnable(){

            @Override
            public void run() {
                RTMPAdaptor.this.peerConnection.setRemoteDescription(RTMPAdaptor.this, sdp);
            }
        });
    }

    public void addIceCandidate(final IceCandidate iceCandidate) {
        this.signallingExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!RTMPAdaptor.this.peerConnection.addIceCandidate(iceCandidate)) {
                    Adaptor.log.error("Add ice candidate failed");
                }
            }
        });
    }

    public boolean isStarted() {
        return this.started;
    }
}

