/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.remoting.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.compatibility.flex.messaging.messages.AbstractMessage;
import org.red5.compatibility.flex.messaging.messages.ErrorMessage;
import org.red5.io.amf3.Output;
import org.red5.io.object.Serializer;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.remoting.IRemotingConnection;
import org.red5.server.api.remoting.IRemotingHeader;
import org.red5.server.exception.ClientDetailsException;
import org.red5.server.net.remoting.FlexMessagingService;
import org.red5.server.net.remoting.message.RemotingCall;
import org.red5.server.net.remoting.message.RemotingPacket;
import org.red5.server.net.rtmp.status.StatusObject;
import org.red5.server.service.ServiceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingProtocolEncoder {
    protected static Logger log = LoggerFactory.getLogger(RemotingProtocolEncoder.class);

    public IoBuffer encode(Object message) throws Exception {
        RemotingPacket resp = (RemotingPacket)message;
        IoBuffer buf = IoBuffer.allocate((int)1024);
        buf.setAutoExpand(true);
        if (resp.getEncoding() == IConnection.Encoding.AMF0) {
            buf.putShort((short)0);
        } else {
            buf.putShort((short)3);
        }
        IRemotingConnection conn = (IRemotingConnection)Red5.getConnectionLocal();
        Collection<IRemotingHeader> headers = conn.getHeaders();
        buf.putShort((short)headers.size());
        Object output = resp.getEncoding() == IConnection.Encoding.AMF0 ? new org.red5.io.amf.Output(buf) : new Output(buf);
        for (IRemotingHeader header : headers) {
            org.red5.io.amf.Output.putString((IoBuffer)buf, (String)"RequestPersistentHeader");
            output.writeBoolean(Boolean.valueOf(false));
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("name", header.getName());
            param.put("mustUnderstand", header.getMustUnderstand() ? Boolean.TRUE : Boolean.FALSE);
            param.put("data", header.getValue());
            Serializer.serialize((org.red5.io.object.Output)output, param);
        }
        headers.clear();
        buf.putShort((short)resp.getCalls().size());
        for (RemotingCall call : resp.getCalls()) {
            log.debug("Call");
            org.red5.io.amf.Output.putString((IoBuffer)buf, (String)call.getClientResponse());
            if (!call.isMessaging) {
                org.red5.io.amf.Output.putString((IoBuffer)buf, (String)"null");
            } else {
                org.red5.io.amf.Output.putString((IoBuffer)buf, (String)"");
            }
            buf.putInt(-1);
            log.info("result: {}", call.getResult());
            output = call.isAMF3 ? new Output(buf) : new org.red5.io.amf.Output(buf);
            Object result = call.getClientResult();
            if (!call.isSuccess()) {
                if (call.isMessaging && !(result instanceof ErrorMessage)) {
                    AbstractMessage request = (AbstractMessage)call.getArguments()[0];
                    if (result instanceof ServiceNotFoundException) {
                        ServiceNotFoundException ex = (ServiceNotFoundException)result;
                        result = FlexMessagingService.returnError(request, "serviceNotAvailable", "Flex messaging not activated", ex.getMessage());
                    } else {
                        result = result instanceof Throwable ? FlexMessagingService.returnError(request, "Server.Invoke.Error", ((Throwable)result).getMessage(), (Throwable)result) : FlexMessagingService.returnError(request, "Server.Invoke.Error", result.toString(), "");
                    }
                } else if (!call.isMessaging) {
                    result = this.generateErrorResult("NetConnection.Call.Failed", call.getException());
                }
            }
            Serializer.serialize((org.red5.io.object.Output)output, (Object)result);
        }
        buf.flip();
        if (log.isDebugEnabled()) {
            log.debug(">>{}", (Object)buf.getHexDump());
        }
        return buf;
    }

    protected StatusObject generateErrorResult(String code, Throwable error) {
        String message = "";
        while (error != null && error.getCause() != null) {
            error = error.getCause();
        }
        if (error != null && error.getMessage() != null) {
            message = error.getMessage();
        }
        StatusObject status = new StatusObject(code, "error", message);
        if (error instanceof ClientDetailsException) {
            status.setApplication(((ClientDetailsException)error).getParameters());
            if (((ClientDetailsException)error).includeStacktrace()) {
                ArrayList<String> stack = new ArrayList<String>();
                for (StackTraceElement element : error.getStackTrace()) {
                    stack.add(element.toString());
                }
                status.setAdditional("stacktrace", stack);
            }
        } else if (error != null) {
            status.setApplication((Object)error.getClass().getCanonicalName());
        }
        return status;
    }
}

