/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmps;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.red5.server.net.rtmp.InboundHandshake;
import org.red5.server.net.rtmp.RTMPConnManager;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.codec.RTMPMinaCodecFactory;
import org.red5.server.net.rtmpe.RTMPEIoFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPSIoFilter
extends RTMPEIoFilter {
    private static final Logger log = LoggerFactory.getLogger(RTMPSIoFilter.class);

    @Override
    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object obj) throws Exception {
        log.trace("messageReceived nextFilter: {} session: {} message: {}", new Object[]{nextFilter, session, obj});
        if (obj instanceof SslFilter.SslFilterMessage || !session.isSecured()) {
            log.trace("Either ssl message or un-secured session: {}", (Object)session.isSecured());
            nextFilter.messageReceived(session, obj);
        } else {
            String sessionId = (String)session.getAttribute((Object)"rtmp.sessionid");
            if (sessionId != null) {
                log.info("RTMPS Session id: {}", (Object)sessionId);
                RTMPMinaConnection conn = (RTMPMinaConnection)RTMPConnManager.getInstance().getConnectionBySessionId(sessionId);
                RTMP rtmp = conn.getState();
                byte connectionState = conn.getStateCode();
                IoBuffer message = (IoBuffer)obj;
                InboundHandshake handshake = null;
                switch (connectionState) {
                    case 0: {
                        IoBuffer s1;
                        if (message.indexOf("P".getBytes()[0]) == 0) {
                            log.info("Non-native RTMPS connection requested for: {}", (Object)sessionId);
                            break;
                        }
                        handshake = (InboundHandshake)((Object)session.getAttribute((Object)"rtmp.handshake"));
                        handshake.addBuffer(message);
                        int c0c1Size = handshake.getBufferSize();
                        log.trace("Incoming C0C1 size: {}", (Object)c0c1Size);
                        if (c0c1Size < 1537) break;
                        log.debug("decodeHandshakeC0C1");
                        IoBuffer buf = handshake.getBufferAsIoBuffer();
                        byte connectionType = buf.get();
                        handshake.setHandshakeType(connectionType);
                        log.trace("Incoming C0 connection type: {}", (Object)connectionType);
                        byte[] dst = new byte[1536];
                        buf.get(dst);
                        rtmp.setState((byte)1);
                        int remaining = buf.remaining();
                        if (remaining > 0) {
                            handshake.addBuffer(buf);
                            log.trace("Stored {} bytes for later decoding", (Object)remaining);
                        }
                        if ((s1 = handshake.decodeClientRequest1(IoBuffer.wrap((byte[])dst))) != null) {
                            session.write((Object)s1);
                            break;
                        }
                        log.warn("Client was rejected due to invalid handshake");
                        conn.close();
                        break;
                    }
                    case 1: {
                        handshake = (InboundHandshake)((Object)session.getAttribute((Object)"rtmp.handshake"));
                        handshake.addBuffer(message);
                        int c2Size = handshake.getBufferSize();
                        log.trace("Incoming C2 size: {}", (Object)c2Size);
                        if (c2Size >= 1536) {
                            log.debug("decodeHandshakeC2");
                            IoBuffer buf = handshake.getBufferAsIoBuffer();
                            byte[] dst = new byte[1536];
                            buf.get(dst);
                            if (handshake.decodeClientRequest2(IoBuffer.wrap((byte[])dst))) {
                                log.debug("Connected, removing handshake data and adding rtmp protocol filter");
                                rtmp.setState((byte)2);
                                session.removeAttribute((Object)"rtmp.handshake");
                                log.debug("Adding RTMP protocol filter");
                                session.getFilterChain().addAfter("rtmpsFilter", "protocolFilter", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new RTMPMinaCodecFactory()));
                                if (buf.hasRemaining()) {
                                    log.trace("Receiving message: {}", (Object)buf);
                                    nextFilter.messageReceived(session, (Object)buf);
                                }
                            } else {
                                log.warn("Client was rejected due to invalid handshake");
                                conn.close();
                            }
                        }
                    }
                    case 2: {
                        log.trace("Receiving message: {}", (Object)message);
                        nextFilter.messageReceived(session, (Object)message);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        log.debug("Nothing to do, connection state: {}", (Object)RTMP.states[connectionState]);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid RTMP state: " + connectionState);
                    }
                }
            }
        }
    }
}

