/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.List;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;

public class PeerConnectionFactory {
    private static volatile boolean nativeLibLoaded;
    private static final String TAG = "PeerConnectionFactory";
    private final long nativeFactory;
    private static Thread networkThread;
    private static Thread workerThread;
    private static Thread signalingThread;

    public static native boolean initializeAndroidGlobals(Object var0, boolean var1, boolean var2, boolean var3);

    public static native void initializeFieldTrials(String var0);

    public static String fieldTrialsFindFullName(String name) {
        return nativeLibLoaded ? PeerConnectionFactory.nativeFieldTrialsFindFullName(name) : "";
    }

    private static native String nativeFieldTrialsFindFullName(String var0);

    public static native void initializeInternalTracer();

    public static native void shutdownInternalTracer();

    public static native boolean startInternalTracingCapture(String var0);

    public static native void stopInternalTracingCapture();

    @Deprecated
    public PeerConnectionFactory() {
        this(null);
    }

    public PeerConnectionFactory(Options options) {
        this.nativeFactory = PeerConnectionFactory.nativeCreatePeerConnectionFactory(options);
        if (this.nativeFactory == 0L) {
            throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
        }
    }

    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rtcConfig, MediaConstraints constraints, PeerConnection.Observer observer) {
        long nativeObserver = PeerConnectionFactory.nativeCreateObserver(observer);
        if (nativeObserver == 0L) {
            return null;
        }
        long nativePeerConnection = PeerConnectionFactory.nativeCreatePeerConnection(this.nativeFactory, rtcConfig, constraints, nativeObserver);
        if (nativePeerConnection == 0L) {
            return null;
        }
        return new PeerConnection(nativePeerConnection, nativeObserver);
    }

    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> iceServers, MediaConstraints constraints, PeerConnection.Observer observer) {
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
        return this.createPeerConnection(rtcConfig, constraints, observer);
    }

    public MediaStream createLocalMediaStream(String label) {
        return new MediaStream(PeerConnectionFactory.nativeCreateLocalMediaStream(this.nativeFactory, label));
    }

    public VideoSource createVideoSource() {
        return new VideoSource(PeerConnectionFactory.nativeCreateVideoSource(this.nativeFactory), this.nativeFactory);
    }

    public VideoTrack createVideoTrack(String id, VideoSource source) {
        return new VideoTrack(PeerConnectionFactory.nativeCreateVideoTrack(this.nativeFactory, id, source.nativeSource));
    }

    public AudioSource createAudioSource(MediaConstraints constraints) {
        return new AudioSource(PeerConnectionFactory.nativeCreateAudioSource(this.nativeFactory, constraints), this.nativeFactory);
    }

    public AudioTrack createAudioTrack(String id, AudioSource source) {
        return new AudioTrack(PeerConnectionFactory.nativeCreateAudioTrack(this.nativeFactory, id, source.nativeSource));
    }

    public boolean startAecDump(int file_descriptor, int filesize_limit_bytes) {
        return PeerConnectionFactory.nativeStartAecDump(this.nativeFactory, file_descriptor, filesize_limit_bytes);
    }

    public void stopAecDump() {
        PeerConnectionFactory.nativeStopAecDump(this.nativeFactory);
    }

    @Deprecated
    public void setOptions(Options options) {
        this.nativeSetOptions(this.nativeFactory, options);
    }

    public void dispose() {
        PeerConnectionFactory.nativeFreeFactory(this.nativeFactory);
        networkThread = null;
        workerThread = null;
        signalingThread = null;
    }

    public void threadsCallbacks() {
        PeerConnectionFactory.nativeThreadsCallbacks(this.nativeFactory);
    }

    private static void printStackTrace(Thread thread, String threadName) {
        StackTraceElement[] stackTraces;
        if (thread != null && (stackTraces = thread.getStackTrace()).length > 0) {
            for (StackTraceElement stackTraceElement : stackTraces) {
            }
        }
    }

    public static void printStackTraces() {
        PeerConnectionFactory.printStackTrace(networkThread, "Network thread");
        PeerConnectionFactory.printStackTrace(workerThread, "Worker thread");
        PeerConnectionFactory.printStackTrace(signalingThread, "Signaling thread");
    }

    private static void onNetworkThreadReady() {
        networkThread = Thread.currentThread();
        System.out.println("onNetworkThreadReady");
    }

    private static void onWorkerThreadReady() {
        workerThread = Thread.currentThread();
        System.out.println("onWorkerThreadReady");
    }

    private static void onSignalingThreadReady() {
        signalingThread = Thread.currentThread();
        System.out.println("onSignalingThreadReady");
    }

    public int addVideoConfPacket(byte[] confData, int confDataLength, byte[] packet, int packetLength, int width, int height, boolean isKeyFrame, long timestamp) {
        return this.nativeAddVideoConfPacket(this.nativeFactory, confData, confDataLength, packet, packetLength, width, height, isKeyFrame, timestamp);
    }

    public int addVideoPacket(byte[] packet, int packetLength, int width, int height, boolean isKeyFrame, long timestamp) {
        return this.nativeAddVideoPacket(this.nativeFactory, packet, packetLength, width, height, isKeyFrame, timestamp);
    }

    public void addAudioPacket(byte[] packet, int packetLength, long timestamp, int totalSampleCount) {
        this.nativeAddAudioPacket(this.nativeFactory, packet, packetLength, timestamp, totalSampleCount);
    }

    public long getTargetedBitrate() {
        return this.nativeGetTargetedBitrate(this.nativeFactory);
    }

    private static native long nativeCreatePeerConnectionFactory(Options var0);

    private static native long nativeCreateObserver(PeerConnection.Observer var0);

    private static native long nativeCreatePeerConnection(long var0, PeerConnection.RTCConfiguration var2, MediaConstraints var3, long var4);

    private static native long nativeCreateLocalMediaStream(long var0, String var2);

    private static native void nativeInitializeVideoCapturer(long var0, VideoCapturer var2, long var3, VideoCapturer.CapturerObserver var5);

    private static native long nativeCreateVideoSource(long var0);

    private static native long nativeCreateVideoTrack(long var0, String var2, long var3);

    private static native long nativeCreateAudioSource(long var0, MediaConstraints var2);

    private static native long nativeCreateAudioTrack(long var0, String var2, long var3);

    private static native boolean nativeStartAecDump(long var0, int var2, int var3);

    private static native void nativeStopAecDump(long var0);

    @Deprecated
    public native void nativeSetOptions(long var1, Options var3);

    private static native void nativeSetVideoHwAccelerationOptions(long var0, Object var2, Object var3);

    private static native void nativeThreadsCallbacks(long var0);

    private static native void nativeFreeFactory(long var0);

    private native long nativeGetTargetedBitrate(long var1);

    private native int nativeAddVideoConfPacket(long var1, byte[] var3, int var4, byte[] var5, int var6, int var7, int var8, boolean var9, long var10);

    private native int nativeAddVideoPacket(long var1, byte[] var3, int var4, int var5, int var6, boolean var7, long var8);

    private native void nativeAddAudioPacket(long var1, byte[] var3, int var4, long var5, int var7);

    static {
        try {
            System.loadLibrary("jingle_peerconnection_so");
            nativeLibLoaded = true;
        }
        catch (UnsatisfiedLinkError t) {
            nativeLibLoaded = false;
        }
    }

    public static class Options {
        static final int ADAPTER_TYPE_UNKNOWN = 0;
        static final int ADAPTER_TYPE_ETHERNET = 1;
        static final int ADAPTER_TYPE_WIFI = 2;
        static final int ADAPTER_TYPE_CELLULAR = 4;
        static final int ADAPTER_TYPE_VPN = 8;
        static final int ADAPTER_TYPE_LOOPBACK = 16;
        public int networkIgnoreMask;
        public boolean disableEncryption;
        public boolean disableNetworkMonitor;
    }
}

