/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import io.antmedia.cluster.DBReader;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.IDataStoreFactory;
import io.antmedia.datastore.db.InMemoryDataStore;
import io.antmedia.datastore.db.MapDBStore;
import io.antmedia.datastore.db.MongoStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreFactory
implements IDataStoreFactory {
    public static final String DB_TYPE_MEMORYDB = "memorydb";
    public static final String DB_TYPE_MAPDB = "mapdb";
    public static final String DB_TYPE_MONGODB = "mongodb";
    private static Logger logger = LoggerFactory.getLogger(DataStoreFactory.class);
    private IDataStore dataStore;
    private String appName;
    private String dbName;
    private String dbType;
    private String dbHost;
    private String dbUser;
    private String dbPassword;

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public IDataStore getDataStore() {
        if (this.dataStore == null) {
            if (this.dbType.contentEquals(DB_TYPE_MONGODB)) {
                this.dataStore = this.dbUser != null && !this.dbUser.isEmpty() ? new MongoStore(this.dbHost, this.dbUser, this.dbPassword, this.dbName) : new MongoStore(this.dbName, this.dbHost);
            } else if (this.dbType.contentEquals(DB_TYPE_MAPDB)) {
                this.dataStore = new MapDBStore(this.dbName + ".db");
            } else if (this.dbType.contentEquals(DB_TYPE_MEMORYDB)) {
                this.dataStore = new InMemoryDataStore(this.dbName);
            } else {
                logger.error("Undefined Datastore:{} app:{} db name:{}", new Object[]{this.dbType, this.appName, this.dbName});
            }
            logger.info("Used Datastore:{} app:{} db name:{}", new Object[]{this.getDbType(), this.getAppName(), this.getDbName()});
            if (this.dataStore != null) {
                DBReader.instance.addDataStore(this.appName, this.dataStore);
            }
        }
        return this.dataStore;
    }

    public void setDataStore(IDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

