/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.antmedia.cluster.StreamInfo;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.VoD;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBStore
implements IDataStore {
    private DB db;
    private BTreeMap<String, String> map;
    private BTreeMap<String, String> vodMap;
    private BTreeMap<String, String> detectionMap;
    private BTreeMap<String, String> userVodMap;
    private BTreeMap<String, String> socialEndpointsCredentialsMap;
    private BTreeMap<String, String> tokenMap;
    private Gson gson;
    protected static Logger logger = LoggerFactory.getLogger(MapDBStore.class);
    private static final String MAP_NAME = "BROADCAST";
    private static final String VOD_MAP_NAME = "VOD";
    private static final String DETECTION_MAP_NAME = "DETECTION";
    private static final String USER_MAP_NAME = "USER_VOD";
    private static final String TOKEN = "TOKEN";
    private static final String SOCIAL_ENDPONT_CREDENTIALS_MAP_NAME = "SOCIAL_ENDPONT_CREDENTIALS_MAP_NAME";

    public MapDBStore(String dbName) {
        this.db = DBMaker.fileDB((String)dbName).fileMmapEnableIfSupported().transactionEnable().closeOnJvmShutdown().make();
        this.map = this.db.treeMap(MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.vodMap = this.db.treeMap(VOD_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.detectionMap = this.db.treeMap(DETECTION_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.userVodMap = this.db.treeMap(USER_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.socialEndpointsCredentialsMap = this.db.treeMap(SOCIAL_ENDPONT_CREDENTIALS_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.tokenMap = this.db.treeMap(TOKEN).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        GsonBuilder builder = new GsonBuilder();
        this.gson = builder.create();
    }

    public BTreeMap<String, String> getUserVodMap() {
        return this.userVodMap;
    }

    public void setUserVodMap(BTreeMap<String, String> userVodMap) {
        this.userVodMap = userVodMap;
    }

    public BTreeMap<String, String> getVodMap() {
        return this.vodMap;
    }

    public void setVodMap(BTreeMap<String, String> vodMap) {
        this.vodMap = vodMap;
    }

    public BTreeMap<String, String> getMap() {
        return this.map;
    }

    public void setMap(BTreeMap<String, String> map) {
        this.map = map;
    }

    public BTreeMap<String, String> getDetectionMap() {
        return this.detectionMap;
    }

    public void setDetectionMap(BTreeMap<String, String> detectionMap) {
        this.detectionMap = detectionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(Broadcast broadcast) {
        String streamId = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            if (broadcast != null) {
                try {
                    if (broadcast.getStreamId() == null) {
                        streamId = RandomStringUtils.randomNumeric((int)24);
                        broadcast.setStreamId(streamId);
                    }
                    streamId = broadcast.getStreamId();
                    String rtmpURL = broadcast.getRtmpURL();
                    if (rtmpURL != null) {
                        rtmpURL = rtmpURL + streamId;
                    }
                    broadcast.setRtmpURL(rtmpURL);
                    if (broadcast.getStatus() == null) {
                        broadcast.setStatus("created");
                    }
                    this.map.put((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
                    this.db.commit();
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    streamId = null;
                }
            }
        }
        return streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Broadcast get(String id) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                return (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoD getVoD(String id) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.vodMap.get((Object)id)) != null) {
                return (VoD)this.gson.fromJson(jsonString, VoD.class);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateName(String id, String name, String description) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setName(name);
                broadcast.setDescription(description);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatus(String id, String status) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setStatus(status);
                String jsonVal = this.gson.toJson((Object)broadcast);
                String previousValue = (String)this.map.replace((Object)id, (Object)jsonVal);
                this.db.commit();
                logger.debug("updateStatus replacing id {} having value {} to {}", new Object[]{id, previousValue, jsonVal});
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDuration(String id, long duration) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setDuration(Long.valueOf(duration));
                String jsonVal = this.gson.toJson((Object)broadcast);
                String previousValue = (String)this.map.replace((Object)id, (Object)jsonVal);
                this.db.commit();
                result = true;
                logger.debug("updateStatus replacing id {} having value {} to {}", new Object[]{id, previousValue, jsonVal});
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEndpoint(String id, Endpoint endpoint) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && endpoint != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                ArrayList<Endpoint> endPointList = broadcast.getEndPointList();
                if (endPointList == null) {
                    endPointList = new ArrayList<Endpoint>();
                }
                endPointList.add(endpoint);
                broadcast.setEndPointList(endPointList);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEndpoint(String id, Endpoint endpoint) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Broadcast broadcast;
            List endPointList;
            String jsonString;
            if (id != null && endpoint != null && (jsonString = (String)this.map.get((Object)id)) != null && (endPointList = (broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class)).getEndPointList()) != null) {
                Iterator iterator = endPointList.iterator();
                while (iterator.hasNext()) {
                    Endpoint endpointItem = (Endpoint)iterator.next();
                    if (!endpointItem.getRtmpUrl().equals(endpoint.getRtmpUrl())) continue;
                    iterator.remove();
                    result = true;
                    break;
                }
                if (result) {
                    broadcast.setEndPointList(endPointList);
                    this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                    this.db.commit();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllEndpoints(String id) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setEndPointList(null);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBroadcastCount() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            return this.map.getSize();
        }
    }

    public long getActiveBroadcastCount() {
        Collection values = this.map.values();
        int activeBroadcastCount = 0;
        for (String broadcastString : values) {
            Broadcast broadcast = (Broadcast)this.gson.fromJson(broadcastString, Broadcast.class);
            String status = broadcast.getStatus();
            if (status == null || !status.equals("broadcasting")) continue;
            ++activeBroadcastCount;
        }
        return activeBroadcastCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String id) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean bl = result = this.map.remove((Object)id) != null;
            if (result) {
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> getBroadcastList(int offset, int size) {
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.map.values();
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            Iterator iterator = values.iterator();
            while (itemCount < size && iterator.hasNext()) {
                if (t < offset) {
                    ++t;
                    iterator.next();
                    continue;
                }
                list.add((Broadcast)this.gson.fromJson((String)iterator.next(), Broadcast.class));
                ++itemCount;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VoD> getVodList(int offset, int size) {
        ArrayList<VoD> list = new ArrayList<VoD>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.vodMap.values();
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            for (String vodString : values) {
                if (t < offset) {
                    ++t;
                    continue;
                }
                list.add((VoD)this.gson.fromJson(vodString, VoD.class));
                if (++itemCount < size) continue;
                break;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> filterBroadcastList(int offset, int size, String type) {
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            Object[] objectArray = this.map.getValues().toArray();
            Broadcast[] broadcastArray = new Broadcast[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                broadcastArray[i] = (Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class);
            }
            ArrayList<Object> filterList = new ArrayList<Object>();
            for (int i = 0; i < broadcastArray.length; ++i) {
                if (!broadcastArray[i].getType().equals(type)) continue;
                filterList.add(this.gson.fromJson((String)objectArray[i], Broadcast.class));
            }
            Iterator iterator = filterList.iterator();
            while (itemCount < size && iterator.hasNext()) {
                if (t < offset) {
                    ++t;
                    iterator.next();
                    continue;
                }
                list.add((Broadcast)iterator.next());
                ++itemCount;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addVod(VoD vod) {
        String id = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            try {
                if (vod.getVodId() == null) {
                    vod.setVodId(RandomStringUtils.randomNumeric((int)24));
                }
                id = vod.getVodId();
                this.vodMap.put((Object)vod.getVodId(), (Object)this.gson.toJson((Object)vod));
                this.db.commit();
                logger.warn("VoD is saved to DB {} with voID {}", (Object)vod.getVodName(), (Object)id);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                id = null;
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> getExternalStreamsList() {
        ArrayList<Broadcast> streamsList = new ArrayList<Broadcast>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            int i;
            Object[] objectArray = this.map.getValues().toArray();
            Broadcast[] broadcastArray = new Broadcast[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                broadcastArray[i] = (Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class);
            }
            for (i = 0; i < broadcastArray.length; ++i) {
                if (!broadcastArray[i].getType().equals("ipCamera") && !broadcastArray[i].getType().equals("streamSource")) continue;
                streamsList.add((Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class));
            }
        }
        return streamsList;
    }

    public void close() {
        this.db.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteVod(String id) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean bl = result = this.vodMap.remove((Object)id) != null;
            if (result) {
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalVodNumber() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            return this.getVodMap().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fetchUserVodList(File userfile) {
        if (userfile == null) {
            return 0;
        }
        int numberOfSavedFiles = 0;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            int i;
            Object[] objectArray = this.vodMap.getValues().toArray();
            VoD[] vodtArray = new VoD[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                vodtArray[i] = (VoD)this.gson.fromJson((String)objectArray[i], VoD.class);
            }
            for (i = 0; i < vodtArray.length; ++i) {
                if (!vodtArray[i].getType().equals("userVod")) continue;
                this.vodMap.remove((Object)vodtArray[i].getVodId());
                this.db.commit();
            }
            File[] listOfFiles = userfile.listFiles();
            if (listOfFiles != null) {
                for (File file : listOfFiles) {
                    String fileExtension = FilenameUtils.getExtension((String)file.getName());
                    if (!file.isFile() || !fileExtension.equals("mp4") && !fileExtension.equals("flv") && !fileExtension.equals("mkv")) continue;
                    long fileSize = file.length();
                    long unixTime = System.currentTimeMillis();
                    String path = file.getPath();
                    String[] subDirs = path.split(Pattern.quote(File.separator));
                    Integer pathLength = subDirs.length;
                    String relativePath = "streams/" + subDirs[pathLength - 2] + '/' + subDirs[pathLength - 1];
                    String vodId = RandomStringUtils.randomNumeric((int)24);
                    VoD newVod = new VoD("vodFile", "vodFile", relativePath, file.getName(), unixTime, 0L, fileSize, "userVod", vodId);
                    this.addVod(newVod);
                    ++numberOfSavedFiles;
                }
            }
        }
        return numberOfSavedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSourceQualityParameters(String id, String quality, double speed, int pendingPacketQueue) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setSpeed(speed);
                broadcast.setQuality(quality);
                broadcast.setPendingPacketSize(pendingPacketQueue);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocialEndpointCredentials addSocialEndpointCredentials(SocialEndpointCredentials credentials) {
        SocialEndpointCredentials addedCredential = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            if (credentials != null && credentials.getAccountName() != null && credentials.getAccessToken() != null && credentials.getServiceName() != null) {
                if (credentials.getId() == null) {
                    String id = RandomStringUtils.randomAlphanumeric((int)6);
                    credentials.setId(id);
                    this.socialEndpointsCredentialsMap.put((Object)id, (Object)this.gson.toJson((Object)credentials));
                    this.db.commit();
                    addedCredential = credentials;
                } else if (this.socialEndpointsCredentialsMap.get((Object)credentials.getId()) != null) {
                    this.socialEndpointsCredentialsMap.put((Object)credentials.getId(), (Object)this.gson.toJson((Object)credentials));
                    this.db.commit();
                    addedCredential = credentials;
                }
            }
        }
        return addedCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialEndpointCredentials> getSocialEndpoints(int offset, int size) {
        ArrayList<SocialEndpointCredentials> list = new ArrayList<SocialEndpointCredentials>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.socialEndpointsCredentialsMap.values();
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            for (String credentialString : values) {
                if (t < offset) {
                    ++t;
                    continue;
                }
                list.add((SocialEndpointCredentials)this.gson.fromJson(credentialString, SocialEndpointCredentials.class));
                if (++itemCount < size) continue;
                break;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSocialEndpointCredentials(String id) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean bl = result = this.socialEndpointsCredentialsMap.remove((Object)id) != null;
            if (result) {
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocialEndpointCredentials getSocialEndpointCredentials(String id) {
        SocialEndpointCredentials credential = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.socialEndpointsCredentialsMap.get((Object)id)) != null) {
                credential = (SocialEndpointCredentials)this.gson.fromJson(jsonString, SocialEndpointCredentials.class);
            }
        }
        return credential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalBroadcastNumber() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            return this.getMap().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDetection(String id, long timeElapsed, List<TensorFlowObject> detectedObjects) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            try {
                if (detectedObjects != null) {
                    for (TensorFlowObject tensorFlowObject : detectedObjects) {
                        tensorFlowObject.setDetectionTime(timeElapsed);
                    }
                    this.detectionMap.put((Object)id, (Object)this.gson.toJson(detectedObjects));
                    this.db.commit();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TensorFlowObject> getDetection(String id) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.detectionMap.get((Object)id)) != null) {
                Type listType = new TypeToken<ArrayList<TensorFlowObject>>(){}.getType();
                return (List)this.gson.fromJson(jsonString, listType);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TensorFlowObject> getDetectionList(String idFilter, int offsetSize, int batchSize) {
        ArrayList<TensorFlowObject> list = new ArrayList<TensorFlowObject>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Type listType = new TypeToken<ArrayList<TensorFlowObject>>(){}.getType();
            int offsetCount = 0;
            int batchCount = 0;
            Iterator keyIterator = this.detectionMap.keyIterator();
            while (keyIterator.hasNext()) {
                String keyValue = (String)keyIterator.next();
                if (!keyValue.startsWith(idFilter)) continue;
                if (offsetCount < offsetSize) {
                    ++offsetCount;
                    continue;
                }
                if (batchCount >= batchSize) break;
                List detectedList = (List)this.gson.fromJson((String)this.detectionMap.get((Object)keyValue), listType);
                list.addAll(detectedList);
                batchCount = list.size();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectDetectedTotal(String id) {
        ArrayList list = new ArrayList();
        Type listType = new TypeToken<ArrayList<TensorFlowObject>>(){}.getType();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Iterator keyIterator = this.detectionMap.keyIterator();
            while (keyIterator.hasNext()) {
                String keyValue = (String)keyIterator.next();
                if (!keyValue.startsWith(id)) continue;
                List detectedList = (List)this.gson.fromJson((String)this.detectionMap.get((Object)keyValue), listType);
                list.addAll(detectedList);
            }
        }
        return list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editStreamSourceInfo(Broadcast broadcast) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            try {
                logger.debug("inside of editStreamSourceInfo {}", (Object)broadcast.getStreamId());
                Broadcast oldBroadcast = this.get(broadcast.getStreamId());
                oldBroadcast.setName(broadcast.getName());
                oldBroadcast.setUsername(broadcast.getUsername());
                oldBroadcast.setPassword(broadcast.getPassword());
                oldBroadcast.setIpAddr(broadcast.getIpAddr());
                oldBroadcast.setStreamUrl(broadcast.getStreamUrl());
                oldBroadcast.setStreamUrl(broadcast.getStreamUrl());
                this.getMap().replace((Object)oldBroadcast.getStreamId(), (Object)this.gson.toJson((Object)oldBroadcast));
                this.db.commit();
                result = true;
            }
            catch (Exception e) {
                result = false;
            }
        }
        logger.debug("result inside edit camera:{} ", (Object)result);
        return result;
    }

    public synchronized boolean updateHLSViewerCount(String streamId, int diffCount) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = this.get(streamId)) != null) {
            int hlsViewerCount = broadcast.getHlsViewerCount();
            broadcast.setHlsViewerCount(hlsViewerCount += diffCount);
            this.map.replace((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
            this.db.commit();
            result = true;
        }
        return result;
    }

    public synchronized boolean updateWebRTCViewerCount(String streamId, boolean increment) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = this.get(streamId)) != null) {
            int webRTCViewerCount = broadcast.getWebRTCViewerCount();
            webRTCViewerCount = increment ? ++webRTCViewerCount : --webRTCViewerCount;
            broadcast.setWebRTCViewerCount(webRTCViewerCount);
            this.map.replace((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
            result = true;
        }
        return result;
    }

    public synchronized boolean updateRtmpViewerCount(String streamId, boolean increment) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = this.get(streamId)) != null) {
            int rtmpViewerCount = broadcast.getRtmpViewerCount();
            rtmpViewerCount = increment ? ++rtmpViewerCount : --rtmpViewerCount;
            broadcast.setRtmpViewerCount(rtmpViewerCount);
            this.map.replace((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
            result = true;
        }
        return result;
    }

    public void addStreamInfoList(List<StreamInfo> streamInfoList) {
    }

    public List<StreamInfo> getStreamInfoList(String streamId) {
        return new ArrayList<StreamInfo>();
    }

    public void clearStreamInfoList(String streamId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToken(Token token) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            if (token.getStreamId() != null && token.getTokenId() != null) {
                try {
                    this.tokenMap.put((Object)token.getTokenId(), (Object)this.gson.toJson((Object)token));
                    this.db.commit();
                    result = true;
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token validateToken(Token token) {
        Token fetchedToken = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonToken;
            if (token.getTokenId() != null && (jsonToken = (String)this.tokenMap.get((Object)token.getTokenId())) != null) {
                fetchedToken = (Token)this.gson.fromJson(jsonToken, Token.class);
                if (fetchedToken.getStreamId().equals(token.getStreamId()) && fetchedToken.getType().equals(token.getType())) {
                    boolean result;
                    boolean bl = result = this.tokenMap.remove((Object)token.getTokenId()) != null;
                    if (result) {
                        this.db.commit();
                    }
                    return fetchedToken;
                }
                fetchedToken = null;
            }
        }
        return fetchedToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean revokeTokens(String streamId) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            int i;
            Object[] objectArray = this.tokenMap.getValues().toArray();
            Token[] tokenArray = new Token[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                tokenArray[i] = (Token)this.gson.fromJson((String)objectArray[i], Token.class);
            }
            for (i = 0; i < tokenArray.length; ++i) {
                if (tokenArray[i].getStreamId().equals(streamId)) {
                    boolean bl = result = this.tokenMap.remove((Object)tokenArray[i].getTokenId()) != null;
                    if (!result) break;
                }
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Token> listAllTokens(String streamId, int offset, int size) {
        ArrayList<Token> list = new ArrayList<Token>();
        ArrayList<Token> listToken = new ArrayList<Token>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.tokenMap.values();
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                Token token = (Token)this.gson.fromJson((String)iterator.next(), Token.class);
                if (!token.getStreamId().equals(streamId)) continue;
                list.add(token);
            }
            Iterator listIterator = list.iterator();
            while (itemCount < size && listIterator.hasNext()) {
                if (t < offset) {
                    ++t;
                    listIterator.next();
                    continue;
                }
                listToken.add((Token)listIterator.next());
                ++itemCount;
            }
        }
        return listToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setMp4Muxing(String streamId, int enabled) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (streamId != null && (jsonString = (String)this.map.get((Object)streamId)) != null && (enabled == 1 || enabled == 0 || enabled == -1)) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setMp4Enabled(enabled);
                this.map.replace((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }
}

