/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtc.adaptor;

import io.antmedia.recorder.FFmpegFrameRecorder;
import io.antmedia.recorder.Frame;
import io.antmedia.recorder.FrameRecorder;
import io.antmedia.webrtc.adaptor.Adaptor;
import io.antmedia.webrtc.api.IAudioTrackListener;
import io.antmedia.websocket.WebSocketCommunityHandler;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.VideoTrack;
import org.webrtc.WrappedNativeI420Buffer;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.audio.WebRtcAudioTrack;

public class RTMPAdaptor
extends Adaptor {
    public static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    public static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    public static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    public static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    FFmpegFrameRecorder recorder;
    private long startTime;
    private static Logger logger = LoggerFactory.getLogger(RTMPAdaptor.class);
    private ExecutorService videoEncoderExecutor;
    private ExecutorService audioEncoderExecutor;
    private volatile boolean isStopped = false;
    private ScheduledExecutorService signallingExecutor;
    private boolean enableAudio = false;
    private volatile int audioFrameCount = 0;
    private boolean started = false;
    private ScheduledFuture<?> audioDataSchedulerFuture;
    private WebRtcAudioTrack webRtcAudioTrack;
    public static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private static String stunServerUri = "stun:stun.l.google.com:19302";

    public RTMPAdaptor(FFmpegFrameRecorder recorder, WebSocketCommunityHandler webSocketHandler) {
        super(webSocketHandler);
        this.recorder = recorder;
        this.setSdpMediaConstraints(new MediaConstraints());
        this.getSdpMediaConstraints().mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        this.getSdpMediaConstraints().mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
    }

    public PeerConnectionFactory createPeerConnectionFactory() {
        PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)PeerConnectionFactory.InitializationOptions.builder(null).createInitializationOptions());
        SoftwareVideoEncoderFactory encoderFactory = new SoftwareVideoEncoderFactory();
        SoftwareVideoDecoderFactory decoderFactory = new SoftwareVideoDecoderFactory();
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        options.disableNetworkMonitor = true;
        JavaAudioDeviceModule adm = (JavaAudioDeviceModule)JavaAudioDeviceModule.builder(null).setUseHardwareAcousticEchoCanceler(false).setUseHardwareNoiseSuppressor(false).setAudioRecordErrorCallback(null).setAudioTrackErrorCallback(null).setAudioTrackListener(new IAudioTrackListener(){

            public void playoutStopped() {
            }

            public void playoutStarted() {
                RTMPAdaptor.this.initAudioTrackExecutor();
            }
        }).createAudioDeviceModule();
        this.webRtcAudioTrack = adm.getAudioTrack();
        return PeerConnectionFactory.builder().setOptions(options).setAudioDeviceModule((AudioDeviceModule)adm).setVideoEncoderFactory((VideoEncoderFactory)encoderFactory).setVideoDecoderFactory((VideoDecoderFactory)decoderFactory).createPeerConnectionFactory();
    }

    @Override
    public void start() {
        this.videoEncoderExecutor = Executors.newSingleThreadExecutor();
        this.audioEncoderExecutor = Executors.newSingleThreadExecutor();
        this.signallingExecutor = Executors.newSingleThreadScheduledExecutor();
        this.signallingExecutor.execute(() -> {
            try {
                this.peerConnectionFactory = this.createPeerConnectionFactory();
                ArrayList<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
                iceServers.add(PeerConnection.IceServer.builder((String)stunServerUri).createIceServer());
                PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
                rtcConfig.enableDtlsSrtp = true;
                this.peerConnection = this.peerConnectionFactory.createPeerConnection(rtcConfig, (PeerConnection.Observer)this);
                this.webSocketCommunityHandler.sendStartMessage(this.getStreamId(), this.getSession());
                this.started = true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
    }

    @Override
    public void stop() {
        if (this.isStopped) {
            return;
        }
        this.isStopped = true;
        if (this.audioDataSchedulerFuture != null) {
            this.audioDataSchedulerFuture.cancel(false);
        }
        this.signallingExecutor.execute(() -> {
            this.webSocketCommunityHandler.sendPublishFinishedMessage(this.getStreamId(), this.getSession());
            this.audioEncoderExecutor.shutdownNow();
            this.videoEncoderExecutor.shutdownNow();
            try {
                this.videoEncoderExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e1));
                Thread.currentThread().interrupt();
            }
            try {
                if (this.peerConnection != null) {
                    this.peerConnection.close();
                    this.recorder.stop();
                    this.peerConnection.dispose();
                    this.peerConnectionFactory.dispose();
                    this.peerConnection = null;
                }
            }
            catch (FrameRecorder.Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
        this.signallingExecutor.shutdown();
    }

    public ExecutorService getSignallingExecutor() {
        return this.signallingExecutor;
    }

    public void initAudioTrackExecutor() {
        this.audioDataSchedulerFuture = this.signallingExecutor.scheduleAtFixedRate(() -> {
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            if (this.audioEncoderExecutor == null || this.audioEncoderExecutor.isShutdown()) {
                return;
            }
            ++this.audioFrameCount;
            ByteBuffer playoutData = this.webRtcAudioTrack.getPlayoutData();
            this.audioEncoderExecutor.execute(() -> {
                ShortBuffer audioBuffer = playoutData.asShortBuffer();
                try {
                    boolean result = this.recorder.recordSamples(this.webRtcAudioTrack.getSampleRate(), this.webRtcAudioTrack.getChannels(), new Buffer[]{audioBuffer});
                    if (!result) {
                        logger.info("could not audio sample for stream Id {}", (Object)this.getStreamId());
                    }
                }
                catch (FrameRecorder.Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            });
        }, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onAddStream(MediaStream stream) {
        VideoTrack videoTrack;
        log.warn("onAddStream for stream: {}", (Object)this.getStreamId());
        if (!stream.audioTracks.isEmpty()) {
            this.enableAudio = true;
        }
        if (!stream.videoTracks.isEmpty() && (videoTrack = (VideoTrack)stream.videoTracks.get(0)) != null) {
            videoTrack.addSink(new VideoSink(){
                private int frameCount;
                private int dropFrameCount = 0;
                private long pts;
                private int frameNumber;
                private int videoFrameLogCounter = 0;
                private int lastFrameNumber = -1;

                public void onFrame(VideoFrame frame) {
                    if (RTMPAdaptor.this.startTime == 0L) {
                        RTMPAdaptor.this.startTime = System.currentTimeMillis();
                    }
                    if (RTMPAdaptor.this.videoEncoderExecutor == null || RTMPAdaptor.this.videoEncoderExecutor.isShutdown()) {
                        return;
                    }
                    frame.retain();
                    ++this.frameCount;
                    ++this.videoFrameLogCounter;
                    if (this.videoFrameLogCounter % 100 == 0) {
                        logger.info("Received total video frames: {}  received fps: {}", (Object)this.frameCount, (Object)((long)this.frameCount / ((System.currentTimeMillis() - RTMPAdaptor.this.startTime) / 1000L)));
                        this.videoFrameLogCounter = 0;
                    }
                    RTMPAdaptor.this.videoEncoderExecutor.execute(() -> {
                        if (RTMPAdaptor.this.enableAudio) {
                            this.pts = (long)RTMPAdaptor.this.audioFrameCount * 10L;
                            logger.trace("audio frame count: {}", (Object)RTMPAdaptor.this.audioFrameCount);
                        } else {
                            this.pts = System.currentTimeMillis() - RTMPAdaptor.this.startTime;
                        }
                        this.frameNumber = (int)((double)this.pts * RTMPAdaptor.this.recorder.getFrameRate() / 1000.0);
                        if (this.frameNumber > this.lastFrameNumber) {
                            RTMPAdaptor.this.recorder.setFrameNumber(this.frameNumber);
                            this.lastFrameNumber = this.frameNumber;
                            Frame frameCV = new Frame(frame.getRotatedWidth(), frame.getRotatedHeight(), 8, 2);
                            VideoFrame.Buffer buffer = frame.getBuffer();
                            if (buffer instanceof WrappedNativeI420Buffer) {
                                WrappedNativeI420Buffer wrappedBuffer = (WrappedNativeI420Buffer)buffer;
                                ((ByteBuffer)frameCV.image[0].position(0)).put(wrappedBuffer.getDataY());
                                ((ByteBuffer)frameCV.image[0]).put(wrappedBuffer.getDataU());
                                ((ByteBuffer)frameCV.image[0]).put(wrappedBuffer.getDataV());
                            }
                            try {
                                RTMPAdaptor.this.recorder.recordImage(frameCV.imageWidth, frameCV.imageHeight, frameCV.imageDepth, frameCV.imageChannels, frameCV.imageStride, 0, frameCV.image);
                            }
                            catch (FrameRecorder.Exception e) {
                                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                            }
                        } else {
                            ++this.dropFrameCount;
                            logger.trace("dropping video, total drop count: {} frame number: {} recorder frame number: {}", new Object[]{this.dropFrameCount, this.frameNumber, this.lastFrameNumber});
                        }
                        frame.release();
                    });
                }
            });
        }
        this.webSocketCommunityHandler.sendPublishStartedMessage(this.getStreamId(), this.getSession(), null);
    }

    @Override
    public void onSetSuccess() {
        this.peerConnection.createAnswer((SdpObserver)this, this.getSdpMediaConstraints());
    }

    public void setRemoteDescription(SessionDescription sdp) {
        this.signallingExecutor.execute(() -> this.peerConnection.setRemoteDescription((SdpObserver)this, sdp));
    }

    public void addIceCandidate(IceCandidate iceCandidate) {
        this.signallingExecutor.execute(() -> {
            if (!this.peerConnection.addIceCandidate(iceCandidate)) {
                log.error("Add ice candidate failed for {}", (Object)iceCandidate);
            }
        });
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public ScheduledFuture getAudioDataSchedulerFuture() {
        return this.audioDataSchedulerFuture;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

