/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.websocket;

import io.antmedia.recorder.FFmpegFrameRecorder;
import io.antmedia.recorder.FrameRecorder;
import io.antmedia.webrtc.adaptor.RTMPAdaptor;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.webrtc.IceCandidate;
import org.webrtc.SessionDescription;

public abstract class WebSocketCommunityHandler {
    private static Logger logger = LoggerFactory.getLogger(WebSocketCommunityHandler.class);
    private JSONParser jsonParser = new JSONParser();

    @OnOpen
    public void onOpen(Session session, EndpointConfig config) {
    }

    @OnClose
    public void onClose(Session session) {
        RTMPAdaptor connectionContext = (RTMPAdaptor)session.getUserProperties().get(session.getId());
        if (connectionContext != null) {
            connectionContext.stop();
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
    }

    @Nonnull
    public abstract ApplicationContext getAppContext();

    @OnMessage
    public void onMessage(Session session, String message) {
        try {
            if (message == null) {
                logger.error("Received message null for session id: {}", (Object)session.getId());
                return;
            }
            JSONObject jsonObject = (JSONObject)this.jsonParser.parse(message);
            String cmd = (String)jsonObject.get((Object)"command");
            if (cmd == null) {
                logger.error("Received message does not contain any command for session id: {}", (Object)session.getId());
                return;
            }
            String streamId = (String)jsonObject.get((Object)"streamId");
            if (streamId == null || streamId.isEmpty()) {
                this.sendNoStreamIdSpecifiedError(session);
                return;
            }
            if (cmd.equals("publish")) {
                this.startRTMPAdaptor(session, streamId);
            } else if (cmd.equals("takeConfiguration")) {
                RTMPAdaptor connectionContext = (RTMPAdaptor)session.getUserProperties().get(session.getId());
                String typeString = (String)jsonObject.get((Object)"type");
                String sdpDescription = (String)jsonObject.get((Object)"sdp");
                this.setRemoteDescription(connectionContext, typeString, sdpDescription, streamId);
            } else if (cmd.equals("takeCandidate")) {
                RTMPAdaptor connectionContext = (RTMPAdaptor)session.getUserProperties().get(session.getId());
                String sdpMid = (String)jsonObject.get((Object)"id");
                String sdp = (String)jsonObject.get((Object)"candidate");
                long sdpMLineIndex = (Long)jsonObject.get((Object)"label");
                this.addICECandidate(streamId, connectionContext, sdpMid, sdp, sdpMLineIndex);
            } else if (cmd.equals("stop")) {
                RTMPAdaptor connectionContext = (RTMPAdaptor)session.getUserProperties().get(session.getId());
                if (connectionContext != null) {
                    connectionContext.stop();
                } else {
                    logger.warn("Connection context is null for stop. Wrong message order for stream: {}", (Object)streamId);
                }
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void startRTMPAdaptor(Session session, String streamId) {
        String outputURL = "rtmp://127.0.0.1/WebRTCApp/" + streamId;
        RTMPAdaptor connectionContext = this.getNewRTMPAdaptor(outputURL);
        session.getUserProperties().put(session.getId(), connectionContext);
        connectionContext.setSession(session);
        connectionContext.setStreamId(streamId);
        connectionContext.start();
    }

    public RTMPAdaptor getNewRTMPAdaptor(String outputURL) {
        return new RTMPAdaptor(WebSocketCommunityHandler.getNewRecorder(outputURL), this);
    }

    public void addICECandidate(String streamId, RTMPAdaptor connectionContext, String sdpMid, String sdp, long sdpMLineIndex) {
        if (connectionContext != null) {
            IceCandidate iceCandidate = new IceCandidate(sdpMid, (int)sdpMLineIndex, sdp);
            connectionContext.addIceCandidate(iceCandidate);
        } else {
            logger.warn("Connection context is null for take candidate. Wrong message order for stream: {}", (Object)streamId);
        }
    }

    private void setRemoteDescription(RTMPAdaptor connectionContext, String typeString, String sdpDescription, String streamId) {
        if (connectionContext != null) {
            SessionDescription.Type type;
            if (typeString.equals("offer")) {
                type = SessionDescription.Type.OFFER;
                logger.info("received sdp type is offer {}", (Object)streamId);
            } else {
                type = SessionDescription.Type.ANSWER;
                logger.info("received sdp type is answer {}", (Object)streamId);
            }
            SessionDescription sdp = new SessionDescription(type, sdpDescription);
            connectionContext.setRemoteDescription(sdp);
        } else {
            logger.warn("Connection context is null. Wrong message order for stream: {}", (Object)streamId);
        }
    }

    public void sendSDPConfiguration(String description, String type, String streamId, Session session) {
        this.sendMessage(WebSocketCommunityHandler.getSDPConfigurationJSON(description, type, streamId).toJSONString(), session);
    }

    public void sendPublishStartedMessage(String streamId, Session session, String roomName) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"command", (Object)"notification");
        jsonObj.put((Object)"definition", (Object)"publish_started");
        jsonObj.put((Object)"streamId", (Object)streamId);
        if (roomName != null) {
            jsonObj.put((Object)"ATTR_ROOM_NAME", (Object)roomName);
        }
        this.sendMessage(jsonObj.toJSONString(), session);
    }

    public void sendPublishFinishedMessage(String streamId, Session session) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"notification");
        jsonObject.put((Object)"definition", (Object)"publish_finished");
        jsonObject.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonObject.toJSONString(), session);
    }

    public void sendStartMessage(String streamId, Session session) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"start");
        jsonObject.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonObject.toJSONString(), session);
    }

    public static FFmpegFrameRecorder getNewRecorder(String outputURL) {
        FFmpegFrameRecorder recorder = WebSocketCommunityHandler.initRecorder(outputURL);
        try {
            recorder.start();
        }
        catch (FrameRecorder.Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return recorder;
    }

    public static FFmpegFrameRecorder initRecorder(String outputURL) {
        FFmpegFrameRecorder recorder = new FFmpegFrameRecorder(outputURL, 640, 480, 1);
        recorder.setFormat("flv");
        recorder.setSampleRate(44100);
        recorder.setFrameRate(20.0);
        recorder.setPixelFormat(0);
        recorder.setVideoCodec(28);
        recorder.setAudioCodec(86018);
        recorder.setAudioChannels(2);
        recorder.setGopSize(40);
        recorder.setVideoQuality(29.0);
        return recorder;
    }

    protected final void sendNoStreamIdSpecifiedError(Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"noStreamNameSpecified");
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void sendTakeCandidateMessage(long sdpMLineIndex, String sdpMid, String sdp, String streamId, Session session) {
        this.sendMessage(WebSocketCommunityHandler.getTakeCandidateJSON(sdpMLineIndex, sdpMid, sdp, streamId).toJSONString(), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String message, Session session) {
        WebSocketCommunityHandler webSocketCommunityHandler = this;
        synchronized (webSocketCommunityHandler) {
            if (session.isOpen()) {
                try {
                    session.getBasicRemote().sendText(message);
                }
                catch (IOException e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    public static JSONObject getTakeCandidateJSON(long sdpMLineIndex, String sdpMid, String sdp, String streamId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"takeCandidate");
        jsonObject.put((Object)"label", (Object)sdpMLineIndex);
        jsonObject.put((Object)"id", (Object)sdpMid);
        jsonObject.put((Object)"candidate", (Object)sdp);
        jsonObject.put((Object)"streamId", (Object)streamId);
        return jsonObject;
    }

    public static JSONObject getSDPConfigurationJSON(String description, String type, String streamId) {
        JSONObject jsonResponseObject = new JSONObject();
        jsonResponseObject.put((Object)"command", (Object)"takeConfiguration");
        jsonResponseObject.put((Object)"sdp", (Object)description);
        jsonResponseObject.put((Object)"type", (Object)type);
        jsonResponseObject.put((Object)"streamId", (Object)streamId);
        return jsonResponseObject;
    }
}

