/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.util;

public class ServerDetector {
    private static String type = ServerDetector.getServerType();
    private static boolean geronimo;
    private static boolean glassfish;
    private static boolean jboss;
    private static boolean jetty;
    private static boolean jonas;
    private static boolean resin;
    private static boolean tomcat;
    private static boolean weblogic;
    private static boolean websphere;
    public static final String GERONIMO_CLASS = "/org/apache/geronimo/system/main/Daemon.class";
    public static final String GERONIMO_ID = "geronimo";
    public static final String GLASSFISH_ID = "glassfish";
    public static final String GLASSFISH_SYSTEM_PROPERTY = "com.sun.aas.instanceRoot";
    public static final String JBOSS_CLASS = "/org/jboss/Main.class";
    public static final String JBOSS_ID = "jboss";
    public static final String JETTY_CLASS = "/org/mortbay/jetty/Server.class";
    public static final String JETTY_ID = "jetty";
    public static final String JONAS_CLASS = "/org/objectweb/jonas/server/Server.class";
    public static final String JONAS_ID = "jonas";
    public static final String RESIN_CLASS = "/com/caucho/server/resin/Resin.class";
    public static final String RESIN_ID = "resin";
    public static final String TOMCAT_BOOTSTRAP_CLASS = "/org/apache/catalina/startup/Bootstrap.class";
    public static final String TOMCAT_EMBEDDED_CLASS = "/org/apache/catalina/startup/Embedded.class";
    public static final String TOMCAT_ID = "tomcat";
    public static final String WEBLOGIC_CLASS = "/weblogic/Server.class";
    public static final String WEBLOGIC_ID = "weblogic";
    public static final String WEBSPHERE_CLASS = "/com/ibm/websphere/product/VersionInfo.class";
    public static final String WEBSPHERE_ID = "websphere";

    private static String getServerType() {
        if (type == null) {
            String tmp = null;
            if (ServerDetector.isGeronimo()) {
                tmp = GERONIMO_ID;
            } else if (ServerDetector.isGlassfish()) {
                tmp = GLASSFISH_ID;
            } else if (ServerDetector.isJBoss()) {
                tmp = JBOSS_ID;
            } else if (ServerDetector.isJOnAS()) {
                tmp = JONAS_ID;
            } else if (ServerDetector.isResin()) {
                tmp = RESIN_ID;
            } else if (ServerDetector.isWebLogic()) {
                tmp = WEBLOGIC_ID;
            } else if (ServerDetector.isWebSphere()) {
                tmp = WEBSPHERE_ID;
            }
            if (ServerDetector.isTomcat()) {
                tmp = tmp == null ? TOMCAT_ID : tmp + "-tomcat";
            } else if (ServerDetector.isJetty()) {
                tmp = tmp == null ? JETTY_ID : tmp + "-jetty";
            }
            if (tmp == null) {
                throw new RuntimeException("Server is not supported");
            }
            return tmp;
        }
        return type;
    }

    public static boolean isGeronimo() {
        if (!geronimo) {
            geronimo = ServerDetector.detect(GERONIMO_CLASS);
        }
        return geronimo;
    }

    public static boolean isGlassfish() {
        String value;
        if (!glassfish && (value = System.getProperty(GLASSFISH_SYSTEM_PROPERTY)) != null) {
            glassfish = true;
        }
        return glassfish;
    }

    public static boolean isJBoss() {
        if (!jboss) {
            jboss = ServerDetector.detect(JBOSS_CLASS);
        }
        return jboss;
    }

    public static boolean isJetty() {
        if (!jetty) {
            jetty = ServerDetector.detect(JETTY_CLASS);
        }
        return jetty;
    }

    public static boolean isJOnAS() {
        if (!jonas) {
            jonas = ServerDetector.detect(JONAS_CLASS);
        }
        return jonas;
    }

    public static boolean isResin() {
        if (!resin) {
            resin = ServerDetector.detect(RESIN_CLASS);
        }
        return resin;
    }

    public static boolean isTomcat() {
        if (!tomcat && !(tomcat = ServerDetector.detect(TOMCAT_BOOTSTRAP_CLASS))) {
            tomcat = ServerDetector.detect(TOMCAT_EMBEDDED_CLASS);
        }
        return tomcat;
    }

    public static boolean isWebLogic() {
        if (!weblogic) {
            weblogic = ServerDetector.detect(WEBLOGIC_CLASS);
        }
        return weblogic;
    }

    public static boolean isWebSphere() {
        if (!websphere) {
            websphere = ServerDetector.detect(WEBSPHERE_CLASS);
        }
        return websphere;
    }

    private static boolean detect(String className) {
        try {
            ClassLoader.getSystemClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass(className);
                return true;
            }
            catch (ClassNotFoundException cnfe2) {
                return false;
            }
        }
    }
}

