/*
 * Decompiled with CFR 0.152.
 */
package com.antstreaming.rtsp.protocol;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SafeProperties
extends Properties {
    private static final long serialVersionUID = 5011694856722313621L;
    private static final String keyValueSeparators = "=:\t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = "\t\r\n\f";
    private static final String RtspLineSeparator = "\r\n";
    private PropertiesContext context = new PropertiesContext();

    public PropertiesContext getContext() {
        return this.context;
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, "8859_1"));
        while (true) {
            String line;
            String intactLine = line = in.readLine();
            if (line == null) {
                return;
            }
            if (line.length() > 0) {
                int keyStart;
                int len = line.length();
                for (keyStart = 0; keyStart < len && whiteSpaceChars.indexOf(line.charAt(keyStart)) != -1; ++keyStart) {
                }
                if (keyStart == len) continue;
                char firstChar = line.charAt(keyStart);
                if (firstChar != '#' && firstChar != '!') {
                    int valueIndex;
                    int separatorIndex;
                    while (this.continueLine(line)) {
                        int startIndex;
                        String nextLine = in.readLine();
                        intactLine = intactLine + "\n" + nextLine;
                        if (nextLine == null) {
                            nextLine = "";
                        }
                        String loppedLine = line.substring(0, len - 1);
                        for (startIndex = 0; startIndex < nextLine.length() && whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) != -1; ++startIndex) {
                        }
                        nextLine = nextLine.substring(startIndex, nextLine.length());
                        line = new String(loppedLine + nextLine);
                        len = line.length();
                    }
                    for (separatorIndex = keyStart; separatorIndex < len; ++separatorIndex) {
                        char currentChar = line.charAt(separatorIndex);
                        if (currentChar == '\\') {
                            ++separatorIndex;
                            continue;
                        }
                        if (keyValueSeparators.indexOf(currentChar) != -1) break;
                    }
                    for (valueIndex = separatorIndex; valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1; ++valueIndex) {
                    }
                    if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                        ++valueIndex;
                    }
                    while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                        ++valueIndex;
                    }
                    String key = line.substring(keyStart, separatorIndex);
                    String value = separatorIndex < len ? line.substring(valueIndex, len) : "";
                    key = this.loadConvert(key);
                    value = this.loadConvert(value);
                    this.put(key, value, intactLine);
                    continue;
                }
                this.context.addCommentLine(intactLine);
                continue;
            }
            this.context.addCommentLine(intactLine);
        }
    }

    private String loadConvert(String theString) {
        return theString;
    }

    @Override
    public synchronized void store(OutputStream out, String header) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (header != null) {
            SafeProperties.writeln(awriter, "#" + header);
        }
        List entrys = this.context.getCommentOrEntrys();
        for (Object obj : entrys) {
            if (obj.toString() == null) continue;
            SafeProperties.writeln(awriter, obj.toString());
        }
        awriter.flush();
    }

    public synchronized String getString() {
        StringBuffer sb = new StringBuffer();
        List entrys = this.context.getCommentOrEntrys();
        for (Object obj : entrys) {
            if (obj.toString() != null) {
                sb.append(obj.toString()).append(RtspLineSeparator);
            }
            obj = null;
        }
        return sb.toString();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        return theString;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.context.putOrUpdate(key.toString(), value.toString());
        return super.put(key, value);
    }

    public synchronized Object put(Object key, Object value, String line) {
        this.context.putOrUpdate(key.toString(), value.toString(), line);
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.context.remove(key.toString());
        return super.remove(key);
    }

    class PropertiesContext {
        private List commentOrEntrys = new ArrayList();

        PropertiesContext() {
        }

        public List getCommentOrEntrys() {
            return this.commentOrEntrys;
        }

        public void addCommentLine(String line) {
            this.commentOrEntrys.add(line);
        }

        public void putOrUpdate(PropertyEntry pe) {
            this.remove(pe.getKey());
            this.commentOrEntrys.add(pe);
        }

        public void putOrUpdate(String key, String value, String line) {
            PropertyEntry pe = new PropertyEntry(key, value, line);
            this.remove(key);
            this.commentOrEntrys.add(pe);
        }

        public void putOrUpdate(String key, String value) {
            PropertyEntry pe = new PropertyEntry(key, value);
            this.remove(key);
            this.commentOrEntrys.add(pe);
        }

        public void remove(String key) {
            for (int i = 0; i < this.commentOrEntrys.size(); ++i) {
                Object obj = this.commentOrEntrys.get(i);
                if (!(obj instanceof PropertyEntry) || obj == null || !key.equals(((PropertyEntry)obj).getKey())) continue;
                this.commentOrEntrys.remove(obj);
            }
        }

        public void addComment(String comment) {
            if (comment != null) {
                SafeProperties.this.context.addCommentLine("#" + comment);
            }
        }

        class PropertyEntry {
            private String key;
            private String value;
            private String line;

            public PropertyEntry(String key, String value) {
                this.key = key;
                this.value = value;
            }

            public PropertyEntry(String key, String value, String line) {
                this(key, value);
                this.line = line;
            }

            public String getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getLine() {
                return this.line;
            }

            public void setLine(String line) {
                this.line = line;
            }

            public String toString() {
                if (this.line != null) {
                    return this.line;
                }
                if (this.key != null && this.value != null) {
                    String k = SafeProperties.this.saveConvert(this.key, true);
                    String v = SafeProperties.this.saveConvert(this.value, false);
                    return k + ":" + v;
                }
                return null;
            }
        }
    }
}

