/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia;

import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.VoD;
import io.antmedia.ipcamera.OnvifCamera;
import io.antmedia.muxer.IAntMediaStreamHandler;
import io.antmedia.rest.BroadcastRestService;
import io.antmedia.rest.model.Result;
import io.antmedia.social.endpoint.PeriscopeEndpoint;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import io.antmedia.streamsource.StreamFetcher;
import io.antmedia.streamsource.StreamFetcherManager;
import io.vertx.core.Vertx;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.red5.server.adapter.MultiThreadedApplicationAdapter;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.red5.server.api.stream.ISubscriberStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntMediaApplicationAdapter
extends MultiThreadedApplicationAdapter
implements IAntMediaStreamHandler {
    public static final String BEAN_NAME = "web.handler";
    public static final String BROADCAST_STATUS_CREATED = "created";
    public static final String BROADCAST_STATUS_BROADCASTING = "broadcasting";
    public static final String BROADCAST_STATUS_FINISHED = "finished";
    public static final String HOOK_ACTION_END_LIVE_STREAM = "liveStreamEnded";
    public static final String HOOK_ACTION_START_LIVE_STREAM = "liveStreamStarted";
    public static final String HOOK_ACTION_VOD_READY = "vodReady";
    public static final String VERTX_BEAN_NAME = "vertxCore";
    protected static Logger logger = LoggerFactory.getLogger(AntMediaApplicationAdapter.class);
    public static final String LIVE_STREAM = "liveStream";
    public static final String IP_CAMERA = "ipCamera";
    public static final String STREAM_SOURCE = "streamSource";
    protected static final int END_POINT_LIMIT = 20;
    public static final String FACEBOOK = "facebook";
    public static final String PERISCOPE = "periscope";
    public static final String YOUTUBE = "youtube";
    public static final String FACEBOOK_ENDPOINT_CLASS = "io.antmedia.enterprise.social.endpoint.FacebookEndpoint";
    public static final String YOUTUBE_ENDPOINT_CLASS = "io.antmedia.enterprise.social.endpoint.YoutubeEndpoint";
    private Map<String, VideoServiceEndpoint> videoServiceEndpoints = new HashMap<String, VideoServiceEndpoint>();
    private List<VideoServiceEndpoint> videoServiceEndpointsHavingError = new ArrayList<VideoServiceEndpoint>();
    private List<IStreamPublishSecurity> streamPublishSecurityList;
    private HashMap<String, OnvifCamera> onvifCameraList = new HashMap();
    private StreamFetcherManager streamFetcherManager;
    private IDataStore dataStore;
    DataStoreFactory dataStoreFactory;
    private AppSettings appSettings;
    private Vertx vertx;

    @Override
    public boolean appStart(final IScope app) {
        this.vertx = (Vertx)this.getContext().getBean(VERTX_BEAN_NAME);
        this.getDataStore();
        if (this.getStreamPublishSecurityList() != null) {
            for (IStreamPublishSecurity streamPublishSecurity : this.getStreamPublishSecurityList()) {
                this.registerStreamPublishSecurity(streamPublishSecurity);
            }
        }
        String scheduledJobName = this.addScheduledOnceJob(0L, new IScheduledJob(){

            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                AntMediaApplicationAdapter.this.streamFetcherManager = new StreamFetcherManager(AntMediaApplicationAdapter.this, AntMediaApplicationAdapter.this.getDataStore(), app);
                AntMediaApplicationAdapter.this.streamFetcherManager.setRestartStreamFetcherPeriod(AntMediaApplicationAdapter.this.appSettings.getRestartStreamFetcherPeriod());
                List streams = AntMediaApplicationAdapter.this.getDataStore().getExternalStreamsList();
                logger.info("Stream source size: {}", (Object)streams.size());
                AntMediaApplicationAdapter.this.streamFetcherManager.startStreams(streams);
                List socialEndpoints = AntMediaApplicationAdapter.this.getDataStore().getSocialEndpoints(0, 20);
                logger.info("socialEndpoints size: {}", (Object)socialEndpoints.size());
                for (SocialEndpointCredentials socialEndpointCredentials : socialEndpoints) {
                    VideoServiceEndpoint endPointService = null;
                    if (socialEndpointCredentials.getServiceName().equals(AntMediaApplicationAdapter.FACEBOOK)) {
                        endPointService = AntMediaApplicationAdapter.this.getEndpointService(AntMediaApplicationAdapter.FACEBOOK_ENDPOINT_CLASS, socialEndpointCredentials, AntMediaApplicationAdapter.this.appSettings.getFacebookClientId(), AntMediaApplicationAdapter.this.appSettings.getFacebookClientSecret());
                    } else if (socialEndpointCredentials.getServiceName().equals(AntMediaApplicationAdapter.PERISCOPE)) {
                        endPointService = AntMediaApplicationAdapter.this.getEndpointService(PeriscopeEndpoint.class.getName(), socialEndpointCredentials, AntMediaApplicationAdapter.this.appSettings.getPeriscopeClientId(), AntMediaApplicationAdapter.this.appSettings.getPeriscopeClientSecret());
                    } else if (socialEndpointCredentials.getServiceName().equals(AntMediaApplicationAdapter.YOUTUBE)) {
                        endPointService = AntMediaApplicationAdapter.this.getEndpointService(AntMediaApplicationAdapter.YOUTUBE_ENDPOINT_CLASS, socialEndpointCredentials, AntMediaApplicationAdapter.this.appSettings.getYoutubeClientId(), AntMediaApplicationAdapter.this.appSettings.getYoutubeClientSecret());
                    }
                    if (endPointService == null) continue;
                    endPointService.setCollectInteractivity(AntMediaApplicationAdapter.this.appSettings.isCollectSocialMediaActivity());
                    AntMediaApplicationAdapter.this.videoServiceEndpoints.put(endPointService.getCredentials().getId(), endPointService);
                }
                if (AntMediaApplicationAdapter.this.appSettings != null) {
                    AntMediaApplicationAdapter.this.synchUserVoDFolder(null, AntMediaApplicationAdapter.this.appSettings.getVodFolder());
                }
            }
        });
        logger.info("AppStart scheduled job name: {}", (Object)scheduledJobName);
        return super.appStart(app);
    }

    public boolean synchUserVoDFolder(String oldFolderPath, String vodFolderPath) {
        boolean result = false;
        File streamsFolder = new File("webapps/" + this.getScope().getName() + "/streams");
        try {
            this.deleteOldFolderPath(oldFolderPath, streamsFolder);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        File f = new File(vodFolderPath == null ? "" : vodFolderPath);
        try {
            String newLinkPath;
            File newLinkFile;
            if (!streamsFolder.exists()) {
                streamsFolder.mkdir();
            }
            if (f.exists() && f.isDirectory() && !(newLinkFile = new File(newLinkPath = streamsFolder.getAbsolutePath() + "/" + f.getName())).exists()) {
                Path target = f.toPath();
                Files.createSymbolicLink(newLinkFile.toPath(), target, new FileAttribute[0]);
            }
            this.getDataStore().fetchUserVodList(f);
            result = true;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return result;
    }

    public boolean deleteOldFolderPath(String oldFolderPath, File streamsFolder) throws IOException {
        boolean result = false;
        if (oldFolderPath != null && !oldFolderPath.isEmpty() && streamsFolder != null) {
            File f = new File(oldFolderPath);
            File linkFile = new File(streamsFolder.getAbsolutePath(), f.getName());
            if (linkFile.exists() && linkFile.isDirectory()) {
                Files.delete(linkFile.toPath());
                result = true;
            }
        }
        return result;
    }

    @Override
    public void streamBroadcastClose(IBroadcastStream stream) {
        String streamName = stream.getPublishedName();
        this.vertx.executeBlocking(future -> {
            try {
                this.closeBroadcast(streamName);
                future.complete((Object)true);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                future.complete((Object)false);
            }
        }, result -> logger.info("close broadcast operation for {} is finished with {}", (Object)streamName, result.result()));
        super.streamBroadcastClose(stream);
    }

    public void closeBroadcast(String streamName) {
        try {
            if (this.dataStore != null) {
                this.getDataStore().updateStatus(streamName, BROADCAST_STATUS_FINISHED);
                Broadcast broadcast = this.getDataStore().get(streamName);
                if (broadcast != null) {
                    List endPointList;
                    final String listenerHookURL = broadcast.getListenerHookURL();
                    final String streamId = broadcast.getStreamId();
                    if (listenerHookURL != null && listenerHookURL.length() > 0) {
                        final String name = broadcast.getName();
                        final String category = broadcast.getCategory();
                        this.addScheduledOnceJob(100L, new IScheduledJob(){

                            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                                AntMediaApplicationAdapter.this.notifyHook(listenerHookURL, streamId, AntMediaApplicationAdapter.HOOK_ACTION_END_LIVE_STREAM, name, category, null, null);
                            }
                        });
                    }
                    if ((endPointList = broadcast.getEndPointList()) != null) {
                        for (Endpoint endpoint : endPointList) {
                            VideoServiceEndpoint videoServiceEndPoint = this.getVideoServiceEndPoint(endpoint.getEndpointServiceId());
                            if (videoServiceEndPoint == null) continue;
                            try {
                                videoServiceEndPoint.stopBroadcast(endpoint);
                            }
                            catch (Exception e) {
                                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                            }
                        }
                    }
                    if (endPointList != null) {
                        this.recreateEndpointsForSocialMedia(broadcast, endPointList);
                    }
                    if (broadcast.isZombi()) {
                        this.getDataStore().delete(streamName);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void recreateEndpointsForSocialMedia(Broadcast broadcast, List<Endpoint> endPointList) {
        for (Endpoint endpoint : endPointList) {
            VideoServiceEndpoint videoServiceEndPoint;
            if (endpoint.type == null || endpoint.type.equals("") || (videoServiceEndPoint = this.getVideoServiceEndPoint(endpoint.getEndpointServiceId())) == null) continue;
            try {
                Endpoint newEndpoint = videoServiceEndPoint.createBroadcast(broadcast.getName(), broadcast.getDescription(), broadcast.getStreamId(), broadcast.isIs360(), broadcast.isPublicStream(), 720, true);
                this.getDataStore().removeEndpoint(broadcast.getStreamId(), endpoint);
                this.getDataStore().addEndpoint(broadcast.getStreamId(), newEndpoint);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public VideoServiceEndpoint getEndpointService(String className, SocialEndpointCredentials socialEndpointCredentials, String clientId, String clientSecret) {
        try {
            Class<?> endpointClass = Class.forName(className);
            VideoServiceEndpoint endPointService = (VideoServiceEndpoint)endpointClass.getConstructor(String.class, String.class, IDataStore.class, SocialEndpointCredentials.class, Vertx.class).newInstance(clientId, clientSecret, this.dataStore, socialEndpointCredentials, this.vertx);
            endPointService.setCollectInteractivity(this.appSettings.isCollectSocialMediaActivity());
            return endPointService;
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    @Override
    public void streamPlayItemPlay(ISubscriberStream stream, IPlayItem item, boolean isLive) {
        super.streamPlayItemPlay(stream, item, isLive);
        this.addScheduledOnceJob(0L, service -> {
            if (this.dataStore != null) {
                this.dataStore.updateRtmpViewerCount(item.getName(), true);
            }
        });
    }

    @Override
    public void streamPlayItemStop(ISubscriberStream stream, IPlayItem item) {
        super.streamPlayItemStop(stream, item);
        this.addScheduledOnceJob(0L, service -> {
            if (this.dataStore != null) {
                this.dataStore.updateRtmpViewerCount(item.getName(), false);
            }
        });
    }

    @Override
    public void streamSubscriberClose(ISubscriberStream stream) {
        super.streamSubscriberClose(stream);
        this.addScheduledOnceJob(0L, service -> {
            if (this.dataStore != null) {
                this.dataStore.updateRtmpViewerCount(stream.getBroadcastStreamPublishName(), false);
            }
        });
    }

    @Override
    public void streamPublishStart(IBroadcastStream stream) {
        String streamName = stream.getPublishedName();
        logger.info("stream name in streamPublishStart: {}", (Object)streamName);
        this.startPublish(streamName);
        super.streamPublishStart(stream);
    }

    public void startPublish(final String streamName) {
        this.addScheduledOnceJob(0L, new IScheduledJob(){

            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                try {
                    IDataStore dataStoreLocal = AntMediaApplicationAdapter.this.getDataStore();
                    if (dataStoreLocal != null) {
                        List endPointList;
                        Broadcast broadcast = dataStoreLocal.get(streamName);
                        if (broadcast == null) {
                            broadcast = AntMediaApplicationAdapter.saveUndefinedBroadcast(streamName, AntMediaApplicationAdapter.this.getScope().getName(), dataStoreLocal, AntMediaApplicationAdapter.this.appSettings);
                        } else {
                            boolean result = dataStoreLocal.updateStatus(streamName, AntMediaApplicationAdapter.BROADCAST_STATUS_BROADCASTING);
                            logger.info(" Status of stream {} is set to Broadcasting with result: {}", (Object)broadcast.getStreamId(), (Object)result);
                        }
                        final String listenerHookURL = broadcast.getListenerHookURL();
                        final String streamId = broadcast.getStreamId();
                        if (listenerHookURL != null && listenerHookURL.length() > 0) {
                            final String name = broadcast.getName();
                            final String category = broadcast.getCategory();
                            AntMediaApplicationAdapter.this.addScheduledOnceJob(100L, new IScheduledJob(){

                                public void execute(ISchedulingService service) throws CloneNotSupportedException {
                                    AntMediaApplicationAdapter.this.notifyHook(listenerHookURL, streamId, AntMediaApplicationAdapter.HOOK_ACTION_START_LIVE_STREAM, name, category, null, null);
                                }
                            });
                        }
                        if ((endPointList = broadcast.getEndPointList()) != null) {
                            for (Endpoint endpoint : endPointList) {
                                VideoServiceEndpoint videoServiceEndPoint = AntMediaApplicationAdapter.this.getVideoServiceEndPoint(endpoint.getEndpointServiceId());
                                if (videoServiceEndPoint == null) continue;
                                try {
                                    videoServiceEndPoint.publishBroadcast(endpoint);
                                    AntMediaApplicationAdapter.this.log.info("publish broadcast called for {}", (Object)videoServiceEndPoint.getName());
                                }
                                catch (Exception e) {
                                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        });
    }

    public static Broadcast saveUndefinedBroadcast(String streamName, String scopeName, IDataStore dataStore, AppSettings appSettings) {
        Broadcast newBroadcast = new Broadcast();
        newBroadcast.setDate(Long.valueOf(System.currentTimeMillis()));
        newBroadcast.setZombi(true);
        try {
            newBroadcast.setStreamId(streamName);
            String settingsListenerHookURL = null;
            String fqdn = null;
            if (appSettings != null) {
                settingsListenerHookURL = appSettings.getListenerHookURL();
                fqdn = appSettings.getServerName();
            }
            return BroadcastRestService.saveBroadcast(newBroadcast, BROADCAST_STATUS_BROADCASTING, scopeName, dataStore, settingsListenerHookURL, fqdn);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public VideoServiceEndpoint getVideoServiceEndPoint(String id) {
        if (this.videoServiceEndpoints != null) {
            return this.videoServiceEndpoints.get(id);
        }
        return null;
    }

    public void muxingFinished(final String streamId, File file, long duration, int resolution) {
        String muxerFinishScript;
        int index;
        String vodName = file.getName();
        String filePath = file.getPath();
        long fileSize = file.length();
        long systemTime = System.currentTimeMillis();
        String[] subDirs = filePath.split(Pattern.quote(File.separator));
        Integer pathLength = subDirs.length;
        String relativePath = subDirs[pathLength - 2] + '/' + subDirs[pathLength - 1];
        String listenerHookURL = null;
        String streamName = file.getName();
        Broadcast broadcast = this.getDataStore().get(streamId);
        if (broadcast != null) {
            streamName = broadcast.getName();
            listenerHookURL = broadcast.getListenerHookURL();
            if (resolution != 0) {
                streamName = streamName + " (" + resolution + "p)";
            }
        }
        final String vodId = RandomStringUtils.randomNumeric((int)24);
        VoD newVod = new VoD(streamName, streamId, relativePath, vodName, systemTime, duration, fileSize, "streamVod", vodId);
        if (this.getDataStore().addVod(newVod) == null) {
            logger.warn("Stream vod with stream id {} cannot be added to data store", (Object)streamId);
        }
        if (listenerHookURL != null && !listenerHookURL.isEmpty() && (index = vodName.lastIndexOf(".mp4")) != -1) {
            final String baseName = vodName.substring(0, index);
            final String finalListenerHookURL = listenerHookURL;
            this.addScheduledOnceJob(100L, new IScheduledJob(){

                public void execute(ISchedulingService service) throws CloneNotSupportedException {
                    AntMediaApplicationAdapter.this.notifyHook(finalListenerHookURL, streamId, AntMediaApplicationAdapter.HOOK_ACTION_VOD_READY, null, null, baseName, vodId);
                }
            });
        }
        if ((muxerFinishScript = this.appSettings.getMuxerFinishScript()) != null && !muxerFinishScript.isEmpty()) {
            this.runScript(muxerFinishScript + "  " + file.getAbsolutePath());
        }
    }

    public void runScript(String scriptFile) {
        this.vertx.executeBlocking(future -> {
            try {
                logger.info("running muxer finish script: {}", (Object)scriptFile);
                Process exec = Runtime.getRuntime().exec(scriptFile);
                int result = exec.waitFor();
                future.complete();
                logger.info("completing script: {} with return value {}", (Object)scriptFile, (Object)result);
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            catch (InterruptedException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
        }, res -> {});
    }

    public void startDeviceAuthStatusPolling(VideoServiceEndpoint videoServiceEndpoint, VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters) {
        int timeDelta = askDeviceAuthParameters.interval * 1000;
        this.addScheduledOnceJob(timeDelta, (IScheduledJob)new AuthCheckJob(0, timeDelta, videoServiceEndpoint, this));
    }

    public Map<String, VideoServiceEndpoint> getVideoServiceEndpoints() {
        return this.videoServiceEndpoints;
    }

    public List<VideoServiceEndpoint> getVideoServiceEndpointsHavingError() {
        return this.videoServiceEndpointsHavingError;
    }

    public void setVideoServiceEndpoints(Map<String, VideoServiceEndpoint> videoServiceEndpoints) {
        this.videoServiceEndpoints = videoServiceEndpoints;
    }

    public StringBuilder notifyHook(String url, String id, String action, String streamName, String category, String vodName, String vodId) {
        StringBuilder response = null;
        if (url != null && url.length() > 0) {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("id", id);
            variables.put("action", action);
            if (streamName != null) {
                variables.put("streamName", streamName);
            }
            if (category != null) {
                variables.put("category", category);
            }
            if (vodName != null) {
                variables.put("vodName", vodName);
            }
            if (vodId != null) {
                variables.put("vodId", vodId);
            }
            try {
                response = this.sendPOST(url, variables);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return response;
    }

    public StringBuilder sendPOST(String url, Map<String, String> variables) throws IOException {
        StringBuilder response = null;
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("User-Agent", "Daaavuuuuuttttt https://www.youtube.com/watch?v=cbyTDRgW4Jg");
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> entrySet = variables.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                urlParameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            UrlEncodedFormEntity postParams = new UrlEncodedFormEntity(urlParameters);
            httpPost.setEntity((HttpEntity)postParams);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            logger.info("POST Response Status:: {}", (Object)httpResponse.getStatusLine().getStatusCode());
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                String inputLine;
                BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
                response = new StringBuilder();
                while ((inputLine = reader.readLine()) != null) {
                    response.append(inputLine);
                }
                reader.close();
            }
        }
        return response;
    }

    public CloseableHttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

    public List<IStreamPublishSecurity> getStreamPublishSecurityList() {
        return this.streamPublishSecurityList;
    }

    public void setStreamPublishSecurityList(List<IStreamPublishSecurity> streamPublishSecurityList) {
        this.streamPublishSecurityList = streamPublishSecurityList;
    }

    public AppSettings getAppSettings() {
        if (this.appSettings == null) {
            AppSettings appSettingsTmp = new AppSettings();
            appSettingsTmp.setMp4MuxingEnabled(true);
            appSettingsTmp.setAddDateTimeToMp4FileName(true);
            appSettingsTmp.setWebRTCEnabled(false);
            appSettingsTmp.setHlsMuxingEnabled(true);
            appSettingsTmp.setObjectDetectionEnabled(Boolean.valueOf(false));
            appSettingsTmp.setAdaptiveResolutionList(null);
            appSettingsTmp.setHlsListSize(null);
            appSettingsTmp.setHlsTime(null);
            appSettingsTmp.setHlsPlayListType(null);
            appSettingsTmp.setDeleteHLSFilesOnEnded(true);
            appSettingsTmp.setPreviewOverwrite(false);
            appSettingsTmp.setTokenControlEnabled(false);
            this.appSettings = appSettingsTmp;
        }
        return this.appSettings;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public StreamFetcher startStreaming(Broadcast broadcast) {
        return this.streamFetcherManager.startStreaming(broadcast);
    }

    public Result stopStreaming(Broadcast broadcast) {
        return this.streamFetcherManager.stopStreaming(broadcast);
    }

    public OnvifCamera getOnvifCamera(String id) {
        Broadcast camera;
        OnvifCamera onvifCamera = this.onvifCameraList.get(id);
        if (onvifCamera == null && (camera = this.getDataStore().get(id)) != null) {
            onvifCamera = new OnvifCamera();
            onvifCamera.connect(camera.getIpAddr(), camera.getUsername(), camera.getPassword());
            this.onvifCameraList.put(id, onvifCamera);
        }
        return onvifCamera;
    }

    public StreamFetcherManager getStreamFetcherManager() {
        return this.streamFetcherManager;
    }

    public void setStreamFetcherManager(StreamFetcherManager streamFetcherManager) {
        this.streamFetcherManager = streamFetcherManager;
    }

    public void setQualityParameters(String id, String quality, double speed, int pendingPacketSize) {
        logger.info("update source quality for stream: {} quality:{} speed:{}", new Object[]{id, quality, speed});
        this.getDataStore().updateSourceQualityParameters(id, quality, speed, pendingPacketSize);
    }

    public IDataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = this.dataStoreFactory.getDataStore();
        }
        return this.dataStore;
    }

    public DataStoreFactory getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(DataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    private static class AuthCheckJob
    implements IScheduledJob {
        private int count;
        private VideoServiceEndpoint videoServiceEndpoint;
        private int interval;
        private AntMediaApplicationAdapter appAdapter;

        public AuthCheckJob(int count, int interval, VideoServiceEndpoint videoServiceEndpoint, AntMediaApplicationAdapter adapter) {
            this.count = count;
            this.videoServiceEndpoint = videoServiceEndpoint;
            this.interval = interval;
            this.appAdapter = adapter;
        }

        public void execute(ISchedulingService service) throws CloneNotSupportedException {
            try {
                if (!this.videoServiceEndpoint.askIfDeviceAuthenticated()) {
                    ++this.count;
                    if (this.count < 10) {
                        if (this.videoServiceEndpoint.getError() == null) {
                            service.addScheduledOnceJob((long)this.interval, (IScheduledJob)new AuthCheckJob(this.count, this.interval, this.videoServiceEndpoint, this.appAdapter));
                            logger.info("Asking authetnication for {}", (Object)this.videoServiceEndpoint.getName());
                        } else {
                            this.appAdapter.getVideoServiceEndpointsHavingError().add(this.videoServiceEndpoint);
                        }
                    } else {
                        this.videoServiceEndpoint.setError("AUTHENTICATION_TIMEOUT");
                        this.appAdapter.getVideoServiceEndpointsHavingError().add(this.videoServiceEndpoint);
                        logger.info("Not authenticated for {} and will not try again", (Object)this.videoServiceEndpoint.getName());
                    }
                } else {
                    logger.info("Authenticated, adding video service endpoint type: {} with id: {} to the app", (Object)this.videoServiceEndpoint.getName(), (Object)this.videoServiceEndpoint.getCredentials().getId());
                    this.appAdapter.getVideoServiceEndpoints().put(this.videoServiceEndpoint.getCredentials().getId(), this.videoServiceEndpoint);
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }
}

