/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.filter.TokenFilterManager;
import io.antmedia.statistic.IStreamStats;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class HlsStatisticsFilter
implements Filter {
    protected static Logger logger = LoggerFactory.getLogger(HlsStatisticsFilter.class);
    private IStreamStats streamStats;
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String method = httpRequest.getMethod();
        if (method.equals("GET")) {
            String streamId;
            String sessionId = httpRequest.getSession().getId();
            chain.doFilter(request, response);
            int status = ((HttpServletResponse)response).getStatus();
            if (200 <= status && status <= 400 && (streamId = TokenFilterManager.getStreamId(httpRequest.getRequestURI())) != null) {
                logger.info("req ip {} session id {} stream id {} status {}", new Object[]{request.getRemoteHost(), sessionId, streamId, status});
                this.getStreamStats().registerNewViewer(streamId, sessionId);
            }
        } else {
            chain.doFilter((ServletRequest)httpRequest, response);
        }
    }

    public void destroy() {
    }

    public IStreamStats getStreamStats() {
        if (this.streamStats == null) {
            ApplicationContext context = (ApplicationContext)this.filterConfig.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            this.streamStats = (IStreamStats)context.getBean("hls.viewerstats");
        }
        return this.streamStats;
    }
}

