/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.security.ITokenService;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class TokenSessionFilter
implements HttpSessionListener {
    private ITokenService tokenService;
    protected static Logger logger = LoggerFactory.getLogger(TokenSessionFilter.class);
    ApplicationContext context;

    public void sessionCreated(HttpSessionEvent se) {
        logger.info("session created:{}", (Object)se.getSession().getId());
        this.context = (ApplicationContext)se.getSession().getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.getTokenService().getAuthenticatedMap().remove(se.getSession().getId());
    }

    public ITokenService getTokenService() {
        if (this.tokenService == null) {
            this.tokenService = (ITokenService)this.context.getBean(ITokenService.BeanName.TOKEN_SERVICE.toString());
        }
        return this.tokenService;
    }

    public void setTokenService(ITokenService tokenService) {
        this.tokenService = tokenService;
    }
}

