/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.statistic;

import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.nvml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPUUtils {
    private static Logger logger = LoggerFactory.getLogger(GPUUtils.class);
    private static GPUUtils instance;
    private static boolean noGPU;
    private Integer deviceCount = null;

    private GPUUtils() {
    }

    public static GPUUtils getInstance() {
        if (instance == null) {
            instance = new GPUUtils();
            try {
                Class.forName("org.bytedeco.javacpp.nvml");
                logger.info("nvml class found:");
                Loader.load(nvml.class);
                int result = nvml.nvmlInit_v2();
                if (result == 0) {
                    logger.info("cuda cannot be initialized.");
                    noGPU = false;
                }
            }
            catch (UnsatisfiedLinkError e) {
                logger.info("no cuda installed.");
                return instance;
            }
            catch (ClassNotFoundException e) {
                logger.info("nvml class not found:");
                return instance;
            }
        }
        return instance;
    }

    public int getDeviceCount() {
        if (noGPU) {
            return 0;
        }
        if (this.deviceCount == null) {
            IntPointer count = new IntPointer(1L);
            int result = nvml.nvmlDeviceGetCount_v2((IntPointer)count);
            this.deviceCount = result == 0 ? Integer.valueOf(count.get()) : Integer.valueOf(0);
        }
        return this.deviceCount;
    }

    private nvml.nvmlUtilization_t getUtilization(int deviceNo) {
        nvml.nvmlUtilization_t deviceUtilization;
        nvml.nvmlDevice_st device = new nvml.nvmlDevice_st();
        int result = nvml.nvmlDeviceGetHandleByIndex_v2((int)deviceNo, (nvml.nvmlDevice_st)device);
        if (result == 0 && (result = nvml.nvmlDeviceGetUtilizationRates((nvml.nvmlDevice_st)device, (nvml.nvmlUtilization_t)(deviceUtilization = new nvml.nvmlUtilization_t()))) == 0) {
            return deviceUtilization;
        }
        return null;
    }

    public int getMemoryUtilization(int deviceNo) {
        nvml.nvmlUtilization_t utilization;
        if (!noGPU && (utilization = this.getUtilization(deviceNo)) != null) {
            return utilization.memory();
        }
        return -1;
    }

    public int getGPUUtilization(int deviceNo) {
        nvml.nvmlUtilization_t utilization;
        if (!noGPU && (utilization = this.getUtilization(deviceNo)) != null) {
            return utilization.gpu();
        }
        return -1;
    }

    static {
        noGPU = true;
    }
}

