/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.statistic;

import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.statistic.IStreamStats;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.red5.server.api.scheduling.ISchedulingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class HlsViewerStats
implements IStreamStats,
ApplicationContextAware {
    protected static Logger logger = LoggerFactory.getLogger(HlsViewerStats.class);
    public static final String BEAN_NAME = "hls.viewerstats";
    private IDataStore dataStore;
    private DataStoreFactory dataStoreFactory;
    public static final int DEFAULT_TIME_PERIOD_FOR_VIEWER_COUNT = 10000;
    private int timePeriodMS = 10000;
    Map<String, Map<String, Long>> streamsViewerMap = new ConcurrentHashMap<String, Map<String, Long>>();
    private int timeoutMS = 20000;

    @Override
    public void registerNewViewer(String streamId, String sessionId) {
        Map<String, Long> viewerMap = this.streamsViewerMap.get(streamId);
        if (viewerMap == null) {
            viewerMap = new ConcurrentHashMap<String, Long>();
        }
        if (!viewerMap.containsKey(sessionId)) {
            this.getDataStore().updateHLSViewerCount(streamId, 1);
        }
        viewerMap.put(sessionId, System.currentTimeMillis());
        this.streamsViewerMap.put(streamId, viewerMap);
    }

    @Override
    public int getViewerCount(String streamId) {
        Map<String, Long> viewerMap = this.streamsViewerMap.get(streamId);
        int viewerCount = 0;
        if (viewerMap != null) {
            viewerCount = viewerMap.size();
        }
        return viewerCount;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.dataStoreFactory = (DataStoreFactory)applicationContext.getBean("dataStoreFactory");
        ISchedulingService scheduler = (ISchedulingService)applicationContext.getBean("schedulingService");
        if (applicationContext.containsBean("app.settings")) {
            AppSettings settings = (AppSettings)applicationContext.getBean("app.settings");
            this.timeoutMS = HlsViewerStats.getTimeoutMSFromSettings(settings, this.timeoutMS);
        }
        scheduler.addScheduledJobAfterDelay(this.timePeriodMS, service -> {
            Iterator<Map.Entry<String, Map<String, Long>>> streamIterator = this.streamsViewerMap.entrySet().iterator();
            long now = System.currentTimeMillis();
            while (streamIterator.hasNext()) {
                Map.Entry<String, Map<String, Long>> streamViewerEntry = streamIterator.next();
                Map<String, Long> viewerMapEnty = streamViewerEntry.getValue();
                Iterator<Map.Entry<String, Long>> viewerIterator = viewerMapEnty.entrySet().iterator();
                int numberOfDecrement = 0;
                while (viewerIterator.hasNext()) {
                    Map.Entry<String, Long> viewer = viewerIterator.next();
                    if (viewer.getValue() >= now - (long)this.getTimeoutMS()) continue;
                    viewerIterator.remove();
                    ++numberOfDecrement;
                }
                numberOfDecrement = -1 * numberOfDecrement;
                this.getDataStoreFactory().getDataStore().updateHLSViewerCount(streamViewerEntry.getKey(), numberOfDecrement);
            }
        }, this.timePeriodMS);
    }

    public static int getTimeoutMSFromSettings(AppSettings settings, int defaultValue) {
        int newTimePeriodMS = defaultValue;
        String hlsTime = settings.getHlsTime();
        if (hlsTime != null && !hlsTime.isEmpty()) {
            try {
                newTimePeriodMS = Integer.valueOf(hlsTime) * 10 * 1000;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return newTimePeriodMS;
    }

    public void setTimePeriodMS(int timePeriodMS) {
        this.timePeriodMS = timePeriodMS;
    }

    public int getTimePeriodMS() {
        return this.timePeriodMS;
    }

    public int getTimeoutMS() {
        return this.timeoutMS;
    }

    public IDataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = this.getDataStoreFactory().getDataStore();
        }
        return this.dataStore;
    }

    public void setDataStore(IDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public DataStoreFactory getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(DataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }
}

