/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AppSettings;
import io.antmedia.settings.ServerSettings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.catalina.util.NetMask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public abstract class AbstractFilter
implements Filter {
    protected static Logger logger = LoggerFactory.getLogger(AbstractFilter.class);
    protected FilterConfig config;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
    }

    public AppSettings getAppSettings() {
        AppSettings appSettings = null;
        ConfigurableWebApplicationContext context = this.getAppContext();
        if (context != null) {
            appSettings = (AppSettings)context.getBean("app.settings");
        }
        return appSettings;
    }

    public ServerSettings getServerSetting() {
        ServerSettings serverSettings = null;
        ConfigurableWebApplicationContext context = this.getAppContext();
        if (context != null) {
            serverSettings = (ServerSettings)context.getBean("ant.media.server.settings");
        }
        return serverSettings;
    }

    public boolean checkCIDRList(List<NetMask> allowedCIDRList, String remoteIPAdrress) {
        try {
            InetAddress addr = InetAddress.getByName(remoteIPAdrress);
            for (NetMask nm : allowedCIDRList) {
                if (!nm.matches(addr)) continue;
                return true;
            }
        }
        catch (UnknownHostException e) {
            logger.error("error", (Throwable)e);
        }
        return false;
    }

    public ConfigurableWebApplicationContext getAppContext() {
        ConfigurableWebApplicationContext appContext = (ConfigurableWebApplicationContext)this.getConfig().getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (appContext != null && appContext.isRunning()) {
            return appContext;
        }
        if (appContext == null) {
            logger.warn("App context not initialized ");
        } else {
            logger.warn("App context not running yet.");
        }
        return null;
    }

    public FilterConfig getConfig() {
        return this.config;
    }

    public void setConfig(FilterConfig config) {
        this.config = config;
    }

    public void destroy() {
    }
}

