/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.filter.AbstractFilter;
import io.antmedia.filter.TokenFilterManager;
import io.antmedia.statistic.IStreamStats;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class HlsStatisticsFilter
extends AbstractFilter {
    protected static Logger logger = LoggerFactory.getLogger(HlsStatisticsFilter.class);
    private IStreamStats streamStats;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String method = httpRequest.getMethod();
        if ("GET".equals(method)) {
            String streamId;
            String sessionId = httpRequest.getSession().getId();
            chain.doFilter(request, response);
            int status = ((HttpServletResponse)response).getStatus();
            if (200 <= status && status <= 400 && (streamId = TokenFilterManager.getStreamId(httpRequest.getRequestURI())) != null) {
                logger.debug("req ip {} session id {} stream id {} status {}", new Object[]{request.getRemoteHost(), sessionId, streamId, status});
                IStreamStats stats = this.getStreamStats();
                if (stats != null) {
                    stats.registerNewViewer(streamId, sessionId);
                }
            }
        } else {
            chain.doFilter((ServletRequest)httpRequest, response);
        }
    }

    public IStreamStats getStreamStats() {
        ConfigurableWebApplicationContext context;
        if (this.streamStats == null && (context = this.getAppContext()) != null) {
            this.streamStats = (IStreamStats)context.getBean("hls.viewerstats");
        }
        return this.streamStats;
    }
}

