/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AppSettings;
import org.bytedeco.javacpp.avcodec;
import org.bytedeco.javacpp.avformat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class StreamAcceptFilter
implements ApplicationContextAware {
    private AppSettings appSettings;
    protected static Logger logger = LoggerFactory.getLogger(StreamAcceptFilter.class);

    public boolean isValidStreamParameters(avformat.AVFormatContext inputFormatContext, avcodec.AVPacket pkt) {
        return this.checkFPSAccept(this.getStreamFps(inputFormatContext, pkt)) && this.checkResolutionAccept(this.getStreamResolution(inputFormatContext, pkt)) && this.checkBitrateAccept(this.getStreamBitrate(inputFormatContext, pkt));
    }

    public boolean checkFPSAccept(int streamFPSValue) {
        if (this.getMaxFps() > 0 && this.getMaxFps() < streamFPSValue) {
            logger.error("Exceeding Max FPS({}) limit. FPS is: {}", (Object)this.getMaxFps(), (Object)streamFPSValue);
            return false;
        }
        return true;
    }

    public boolean checkResolutionAccept(int streamResolutionValue) {
        if (this.getMaxResolution() > 0 && this.getMaxResolution() < streamResolutionValue) {
            logger.error("Exceeding Max Resolution({}) acceptable limit. Resolution is: {}", (Object)this.getMaxResolution(), (Object)streamResolutionValue);
            return false;
        }
        return true;
    }

    public boolean checkBitrateAccept(long streamBitrateValue) {
        if (this.getMaxBitrate() > 0 && (long)this.getMaxBitrate() < streamBitrateValue) {
            logger.error("Exceeding Max Bitrate({}) acceptable limit. Stream Bitrate is: {}", (Object)this.getMaxBitrate(), (Object)streamBitrateValue);
            return false;
        }
        return true;
    }

    public int getStreamFps(avformat.AVFormatContext inputFormatContext, avcodec.AVPacket pkt) {
        int streamFPSValue = inputFormatContext.streams(pkt.stream_index()).r_frame_rate().num() / inputFormatContext.streams(pkt.stream_index()).r_frame_rate().den();
        logger.info("Stream FPS value: {}", (Object)streamFPSValue);
        return streamFPSValue;
    }

    public int getStreamResolution(avformat.AVFormatContext inputFormatContext, avcodec.AVPacket pkt) {
        int streamResolutionValue = inputFormatContext.streams(pkt.stream_index()).codecpar().height();
        logger.error("Stream Resolution value: {}", (Object)streamResolutionValue);
        return streamResolutionValue;
    }

    public long getStreamBitrate(avformat.AVFormatContext inputFormatContext, avcodec.AVPacket pkt) {
        long streamBitrateValue = inputFormatContext.streams(pkt.stream_index()).codecpar().bit_rate();
        logger.error("Stream Bitrate value: {}", (Object)streamBitrateValue);
        return streamBitrateValue;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (applicationContext.containsBean("app.settings")) {
            this.appSettings = (AppSettings)applicationContext.getBean("app.settings");
        }
    }

    public AppSettings getAppSettings() {
        return this.appSettings;
    }

    public int getMaxFps() {
        if (this.appSettings != null) {
            return this.appSettings.getMaxFpsAccept();
        }
        return 0;
    }

    public int getMaxResolution() {
        if (this.appSettings != null) {
            return this.appSettings.getMaxResolutionAccept();
        }
        return 0;
    }

    public int getMaxBitrate() {
        if (this.appSettings != null) {
            return this.appSettings.getMaxBitrateAccept();
        }
        return 0;
    }
}

