/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.security.ITokenService;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class TokenSessionFilter
implements HttpSessionListener {
    private ITokenService tokenService;
    protected static Logger logger = LoggerFactory.getLogger(TokenSessionFilter.class);
    ConfigurableWebApplicationContext context;

    public void sessionCreated(HttpSessionEvent se) {
        logger.debug("session created:{}", (Object)se.getSession().getId());
        this.context = (ConfigurableWebApplicationContext)se.getSession().getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        ITokenService tokenServiceTmp = this.getTokenService();
        if (tokenServiceTmp != null) {
            tokenServiceTmp.getAuthenticatedMap().remove(se.getSession().getId());
        }
    }

    public ITokenService getTokenService() {
        if (this.tokenService == null) {
            if (this.context != null && this.context.isRunning()) {
                this.tokenService = (ITokenService)this.context.getBean(ITokenService.BeanName.TOKEN_SERVICE.toString());
            } else {
                logger.warn("Context is null or not running");
            }
        }
        return this.tokenService;
    }

    public void setTokenService(ITokenService tokenService) {
        this.tokenService = tokenService;
    }

    public void setContext(ApplicationContext context) {
        this.context = (ConfigurableWebApplicationContext)context;
    }
}

